/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;

public class XmlTagFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof XmlTag) {
            char ch;
            ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(psiElement.getNode());
            ASTNode endTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(psiElement.getNode());
            if (emptyTagEnd != null || endTagEnd != null) {
                return;
            }
            int insertionOffset = psiElement.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            int caretAt = editor.getCaretModel().getOffset();
            CharSequence text = doc.getCharsSequence();
            int probableCommaOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)insertionOffset, (String)" \t");
            if (probableCommaOffset >= text.length() || (ch = text.charAt(probableCommaOffset)) != '/' && ch != '>') {
                doc.insertString(insertionOffset, (CharSequence)"/>");
            }
        }
    }
}

