/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PresentableActionHandlerBasedAction
extends BaseCodeInsightAction {
    private String myCurrentActionName = null;

    protected String getCommandName() {
        String actionName = this.myCurrentActionName;
        return actionName != null ? this.myCurrentActionName : super.getCommandName();
    }

    @Override
    public void update(AnActionEvent event) {
        event.getPresentation().copyFrom(this.getTemplatePresentation());
        super.update(event);
        this.myCurrentActionName = event.getPresentation().getText();
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext, @Nullable String actionPlace) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "update"));
        }
        CodeInsightActionHandler handler2 = this.getValidHandler(editor, file);
        presentation.setEnabled(handler2 != null);
        if (handler2 instanceof ContextAwareActionHandler && !ActionPlaces.isMainMenuOrActionSearch((String)actionPlace)) {
            presentation.setVisible(((ContextAwareActionHandler)handler2).isAvailableForQuickList(editor, file, dataContext));
        }
        if (presentation.isVisible() && handler2 instanceof PresentableCodeInsightActionHandler) {
            ((PresentableCodeInsightActionHandler)handler2).update(editor, file, presentation);
        }
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "isValidForFile"));
        }
        return this.getValidHandler(editor, file) != null;
    }

    @Nullable
    private CodeInsightActionHandler getValidHandler(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "getValidHandler"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/actions/PresentableActionHandlerBasedAction", "getValidHandler"));
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        CodeInsightActionHandler codeInsightActionHandler = (CodeInsightActionHandler)this.getLanguageExtension().forLanguage(language);
        if (codeInsightActionHandler != null) {
            if (codeInsightActionHandler instanceof LanguageCodeInsightActionHandler) {
                if (((LanguageCodeInsightActionHandler)codeInsightActionHandler).isValidFor(editor, file)) {
                    return codeInsightActionHandler;
                }
            } else {
                return codeInsightActionHandler;
            }
        }
        return null;
    }

    @NotNull
    protected abstract LanguageExtension<? extends CodeInsightActionHandler> getLanguageExtension();
}

