/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterDialog;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class CreateFieldFromParameterActionBase
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(CreateFieldFromParameterActionBase.class);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "isAvailable"));
        }
        PsiParameter parameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        if (parameter == null || !this.isAvailable(parameter)) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.create.field.from.parameter.text", (Object[])new Object[]{parameter.getName()}));
        return true;
    }

    protected abstract boolean isAvailable(PsiParameter var1);

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.create.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "invoke"));
        }
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        if (myParameter == null || !FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        try {
            this.processParameter(project, myParameter, !ApplicationManager.getApplication().isUnitTestMode());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void processParameter(final @NotNull Project project, final @NotNull PsiParameter myParameter, boolean isInteractive) {
        boolean isFinalToCalc;
        Object fieldNameToCalc;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "processParameter"));
        }
        if (myParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myParameter", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "processParameter"));
        }
        final PsiType type = this.getSubstitutedType(myParameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        final PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class);
        final PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind, propertyName, null, type);
        Object[] names = suggestedNameInfo.names;
        if (isInteractive) {
            ArrayList<String> namesList = new ArrayList<String>();
            ContainerUtil.addAll(namesList, (Object[])names);
            String defaultName = styleManager.propertyNameToVariableName(propertyName, kind);
            if (namesList.contains(defaultName)) {
                Collections.swap(namesList, 0, namesList.indexOf(defaultName));
            } else {
                namesList.add(0, defaultName);
            }
            names = ArrayUtil.toStringArray(namesList);
            CreateFieldFromParameterDialog dialog = new CreateFieldFromParameterDialog(project, (String[])names, targetClass, method.isConstructor(), type);
            if (!dialog.showAndGet()) {
                return;
            }
            fieldNameToCalc = dialog.getEnteredName();
            isFinalToCalc = dialog.isDeclareFinal();
            suggestedNameInfo.nameChosen((String)fieldNameToCalc);
        } else {
            isFinalToCalc = !isMethodStatic && method.isConstructor();
            fieldNameToCalc = names[0];
        }
        boolean isFinal = isFinalToCalc;
        Object fieldName = fieldNameToCalc;
        ApplicationManager.getApplication().runWriteAction(new Runnable((String)fieldName, isMethodStatic, isFinal){
            final /* synthetic */ String val$fieldName;
            final /* synthetic */ boolean val$isMethodStatic;
            final /* synthetic */ boolean val$isFinal;
            {
                this.val$fieldName = string;
                this.val$isMethodStatic = bl;
                this.val$isFinal = bl2;
            }

            @Override
            public void run() {
                try {
                    CreateFieldFromParameterActionBase.this.performRefactoring(project, targetClass, method, myParameter, type, this.val$fieldName, this.val$isMethodStatic, this.val$isFinal);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    protected abstract PsiType getSubstitutedType(PsiParameter var1);

    protected abstract void performRefactoring(Project var1, PsiClass var2, PsiMethod var3, PsiParameter var4, PsiType var5, String var6, boolean var7, boolean var8);

    public boolean startInWriteAction() {
        return false;
    }
}

