/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JoinDeclarationAndAssignmentAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.join.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/JoinDeclarationAndAssignmentAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/JoinDeclarationAndAssignmentAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/JoinDeclarationAndAssignmentAction", "isAvailable"));
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        if (JoinDeclarationAndAssignmentAction.getPair(element) != null) {
            this.setText(CodeInsightBundle.message((String)"intention.join.declaration.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static Pair<PsiLocalVariable, PsiAssignmentExpression> getPair(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class);
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class);
        if (declarationStatement != null) {
            assignmentExpression = JoinDeclarationAndAssignmentAction.getAssignmentStatement(declarationStatement);
        } else if (assignmentExpression != null) {
            declarationStatement = JoinDeclarationAndAssignmentAction.getDeclarationStatement(assignmentExpression);
        }
        if (declarationStatement != null && assignmentExpression != null) {
            PsiElement resolve;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            PsiExpression rExpression = assignmentExpression.getRExpression();
            if (lExpression instanceof PsiReferenceExpression && rExpression != null && (resolve = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiLocalVariable && resolve.getParent() == declarationStatement) {
                PsiLocalVariable variable = (PsiLocalVariable)resolve;
                if (ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)rExpression), (boolean)false).findFirst() != null) {
                    return null;
                }
                return Pair.create((Object)variable, (Object)assignmentExpression);
            }
        }
        return null;
    }

    private static PsiAssignmentExpression getAssignmentStatement(PsiDeclarationStatement statement) {
        PsiExpression expression;
        PsiElement element = PsiTreeUtil.skipSiblingsForward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (element instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)element).getExpression()) instanceof PsiAssignmentExpression) {
            return (PsiAssignmentExpression)expression;
        }
        return null;
    }

    private static PsiDeclarationStatement getDeclarationStatement(PsiAssignmentExpression assignmentExpression) {
        PsiElement element;
        PsiElement parent = assignmentExpression.getParent();
        if (parent instanceof PsiExpressionStatement && (element = PsiTreeUtil.skipSiblingsBackward((PsiElement)parent, (Class[])new Class[]{PsiWhiteSpace.class})) instanceof PsiDeclarationStatement) {
            return (PsiDeclarationStatement)element;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/JoinDeclarationAndAssignmentAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/JoinDeclarationAndAssignmentAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        Pair<PsiLocalVariable, PsiAssignmentExpression> pair = JoinDeclarationAndAssignmentAction.getPair(element);
        PsiLocalVariable variable = (PsiLocalVariable)pair.getFirst();
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)pair.getSecond();
        PsiExpression initializerExpression = DeclarationJoinLinesHandler.getInitializerExpression(variable, assignmentExpression);
        variable.setInitializer(initializerExpression);
        assignmentExpression.delete();
    }
}

