/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandLiveTemplateCustomAction
extends EditorAction {
    public ExpandLiveTemplateCustomAction() {
        super((EditorActionHandler)ExpandLiveTemplateCustomAction.createExpandTemplateHandler('C'));
        this.setInjectedContext(true);
    }

    static EditorWriteActionHandler createExpandTemplateHandler(final char shortcutChar) {
        return new EditorWriteActionHandler(true){

            public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
                Project project = editor.getProject();
                assert (project != null);
                TemplateManager.getInstance(project).startTemplate(editor, shortcutChar);
            }

            protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/editorActions/ExpandLiveTemplateCustomAction$1", "isEnabledForCaret"));
                }
                if (caret == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/template/impl/editorActions/ExpandLiveTemplateCustomAction$1", "isEnabledForCaret"));
                }
                Project project = editor.getProject();
                return project != null && ((TemplateManagerImpl)TemplateManager.getInstance(project)).prepareTemplate(editor, shortcutChar, null) != null;
            }
        };
    }
}

