/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ExpressionUtil;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestVariableNameMacro
extends Macro {
    public String getName() {
        return "suggestVariableName";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.suggest.variable.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SuggestVariableNameMacro", "getDefaultValue"));
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SuggestVariableNameMacro", "calculateResult"));
        }
        String[] names = SuggestVariableNameMacro.getNames(context);
        if (names == null || names.length == 0) {
            return null;
        }
        return new TextResult(names[0]);
    }

    @Nullable
    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SuggestVariableNameMacro", "calculateQuickResult"));
        }
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SuggestVariableNameMacro", "calculateLookupItems"));
        }
        String[] names = SuggestVariableNameMacro.getNames(context);
        if (names == null || names.length < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            items[i] = LookupElementBuilder.create((String)names[i]);
        }
        return items;
    }

    private static String[] getNames(ExpressionContext context) {
        String[] names = ExpressionUtil.getNames(context);
        if (names == null || names.length == 0) {
            return names;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(context.getEditor().getDocument());
        PsiElement e = file.findElementAt(context.getStartOffset());
        PsiVariable[] vars = MacroUtil.getVariablesVisibleAt(e, "");
        LinkedList<String> namesList = new LinkedList<String>(Arrays.asList(names));
        for (PsiVariable var : vars) {
            if (e.equals(var.getNameIdentifier())) continue;
            namesList.remove(var.getName());
        }
        if (namesList.isEmpty()) {
            String name = names[0];
            int j = 1;
            while (true) {
                block6: {
                    String name1 = name + j;
                    for (PsiVariable var : vars) {
                        if (!name1.equals(var.getName()) || var.getNameIdentifier().equals(e)) {
                            continue;
                        }
                        break block6;
                    }
                    return new String[]{name1};
                }
                ++j;
            }
        }
        return ArrayUtil.toStringArray(namesList);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

