/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

interface NullableMethodAnalysisData {
    public static final Type NullType = Type.getObjectType((String)"null");
    public static final Type ThisType = Type.getObjectType((String)"this");
    public static final Type CallType = Type.getObjectType((String)"/Call");
    public static final BasicValue ThisValue = new BasicValue(ThisType);

    public static final class Constraint {
        static final Constraint EMPTY = new Constraint(0, 0);
        final int calls;
        final int nulls;

        public Constraint(int calls, int nulls) {
            this.calls = calls;
            this.nulls = nulls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constraint that = (Constraint)o;
            if (this.calls != that.calls) {
                return false;
            }
            return this.nulls == that.nulls;
        }

        public int hashCode() {
            int result2 = this.calls;
            result2 = 31 * result2 + this.nulls;
            return result2;
        }
    }

    public static final class Calls
    extends BasicValue {
        final int mergedLabels;

        public Calls(int mergedLabels) {
            super(CallType);
            this.mergedLabels = mergedLabels;
        }

        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Calls calls = (Calls)((Object)o);
            return this.mergedLabels == calls.mergedLabels;
        }

        public int hashCode() {
            return this.mergedLabels;
        }
    }

    public static final class LabeledNull
    extends BasicValue {
        final int origins;

        public LabeledNull(int origins) {
            super(NullType);
            this.origins = origins;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            LabeledNull that = (LabeledNull)((Object)o);
            return this.origins == that.origins;
        }

        public int hashCode() {
            return this.origins;
        }
    }
}

