/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysisData;
import com.intellij.codeInspection.bytecodeAnalysis.asm.InterpreterExt;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

class NullableMethodInterpreter
extends BasicInterpreter
implements InterpreterExt<NullableMethodAnalysisData.Constraint> {
    final InsnList insns;
    final boolean[] origins;
    private final int[] originsMapping;
    final Key[] keys;
    NullableMethodAnalysisData.Constraint constraint = null;
    int delta = 0;
    int nullsDelta = 0;
    int notNullInsn = -1;
    int notNullCall = 0;
    int notNullNull = 0;

    NullableMethodInterpreter(InsnList insns, boolean[] origins, int[] originsMapping) {
        this.insns = insns;
        this.origins = origins;
        this.originsMapping = originsMapping;
        this.keys = new Key[originsMapping.length];
    }

    public BasicValue newValue(Type type) {
        return NullableMethodAnalysisData.ThisType.equals((Object)type) ? NullableMethodAnalysisData.ThisValue : super.newValue(type);
    }

    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        int insnIndex;
        if (insn.getOpcode() == 1 && this.origins[insnIndex = this.insns.indexOf(insn)]) {
            return new NullableMethodAnalysisData.LabeledNull(1 << this.originsMapping[insnIndex]);
        }
        return super.newOperation(insn);
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 180: 
            case 190: 
            case 194: {
                if (!(value instanceof NullableMethodAnalysisData.Calls)) break;
                this.delta = ((NullableMethodAnalysisData.Calls)value).mergedLabels;
                break;
            }
            case 198: {
                if (value instanceof NullableMethodAnalysisData.Calls) {
                    this.notNullInsn = this.insns.indexOf(insn) + 1;
                    this.notNullCall = ((NullableMethodAnalysisData.Calls)value).mergedLabels;
                    break;
                }
                if (!(value instanceof NullableMethodAnalysisData.LabeledNull)) break;
                this.notNullInsn = this.insns.indexOf(insn) + 1;
                this.notNullNull = ((NullableMethodAnalysisData.LabeledNull)value).origins;
                break;
            }
            case 199: {
                if (value instanceof NullableMethodAnalysisData.Calls) {
                    this.notNullInsn = this.insns.indexOf((AbstractInsnNode)((JumpInsnNode)insn).label);
                    this.notNullCall = ((NullableMethodAnalysisData.Calls)value).mergedLabels;
                    break;
                }
                if (!(value instanceof NullableMethodAnalysisData.LabeledNull)) break;
                this.notNullInsn = this.insns.indexOf((AbstractInsnNode)((JumpInsnNode)insn).label);
                this.notNullNull = ((NullableMethodAnalysisData.LabeledNull)value).origins;
                break;
            }
        }
        return super.unaryOperation(insn, value);
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 181: {
                if (value1 instanceof NullableMethodAnalysisData.Calls) {
                    this.delta = ((NullableMethodAnalysisData.Calls)value1).mergedLabels;
                }
                if (!(value1 instanceof NullableMethodAnalysisData.LabeledNull)) break;
                this.nullsDelta = ((NullableMethodAnalysisData.LabeledNull)value1).origins;
                break;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        if (value1 instanceof NullableMethodAnalysisData.Calls) {
            this.delta = ((NullableMethodAnalysisData.Calls)value1).mergedLabels;
        }
        if (value1 instanceof NullableMethodAnalysisData.LabeledNull) {
            this.nullsDelta = ((NullableMethodAnalysisData.LabeledNull)value1).origins;
        }
        return null;
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opCode = insn.getOpcode();
        switch (opCode) {
            case 182: 
            case 183: 
            case 185: {
                BasicValue receiver = values.get(0);
                if (receiver instanceof NullableMethodAnalysisData.Calls) {
                    this.delta = ((NullableMethodAnalysisData.Calls)receiver).mergedLabels;
                }
                if (!(receiver instanceof NullableMethodAnalysisData.LabeledNull)) break;
                this.nullsDelta = ((NullableMethodAnalysisData.LabeledNull)receiver).origins;
                break;
            }
        }
        switch (opCode) {
            case 182: 
            case 183: 
            case 184: {
                int insnIndex = this.insns.indexOf(insn);
                if (!this.origins[insnIndex]) break;
                boolean stable = opCode == 184 || opCode == 183;
                MethodInsnNode mNode = (MethodInsnNode)insn;
                Method method = new Method(mNode.owner, mNode.name, mNode.desc);
                int label = 1 << this.originsMapping[insnIndex];
                if (this.keys[insnIndex] == null) {
                    this.keys[insnIndex] = new Key(method, Direction.NullableOut, stable);
                }
                return new NullableMethodAnalysisData.Calls(label);
            }
        }
        return super.naryOperation(insn, values);
    }

    @Override
    public BasicValue merge(BasicValue v1, BasicValue v2) {
        if (v1 instanceof NullableMethodAnalysisData.LabeledNull) {
            if (v2 instanceof NullableMethodAnalysisData.LabeledNull) {
                return new NullableMethodAnalysisData.LabeledNull(((NullableMethodAnalysisData.LabeledNull)v1).origins | ((NullableMethodAnalysisData.LabeledNull)v2).origins);
            }
            return v1;
        }
        if (v2 instanceof NullableMethodAnalysisData.LabeledNull) {
            return v2;
        }
        if (v1 instanceof NullableMethodAnalysisData.Calls) {
            if (v2 instanceof NullableMethodAnalysisData.Calls) {
                NullableMethodAnalysisData.Calls calls1 = (NullableMethodAnalysisData.Calls)v1;
                NullableMethodAnalysisData.Calls calls2 = (NullableMethodAnalysisData.Calls)v2;
                return new NullableMethodAnalysisData.Calls(calls1.mergedLabels | calls2.mergedLabels);
            }
            return v1;
        }
        if (v2 instanceof NullableMethodAnalysisData.Calls) {
            return v2;
        }
        return super.merge(v1, v2);
    }

    @Override
    public void init(NullableMethodAnalysisData.Constraint previous) {
        this.constraint = previous;
        this.delta = 0;
        this.nullsDelta = 0;
        this.notNullInsn = -1;
        this.notNullCall = 0;
        this.notNullNull = 0;
    }

    @Override
    public NullableMethodAnalysisData.Constraint getAfterData(int insn) {
        NullableMethodAnalysisData.Constraint afterData = this.mkAfterData();
        if (this.notNullInsn == insn) {
            return new NullableMethodAnalysisData.Constraint(afterData.calls | this.notNullCall, afterData.nulls | this.notNullNull);
        }
        return afterData;
    }

    private NullableMethodAnalysisData.Constraint mkAfterData() {
        if (this.delta == 0 && this.nullsDelta == 0 && this.notNullInsn == -1) {
            return this.constraint;
        }
        return new NullableMethodAnalysisData.Constraint(this.constraint.calls | this.delta, this.constraint.nulls | this.nullsDelta);
    }

    @Override
    public NullableMethodAnalysisData.Constraint merge(NullableMethodAnalysisData.Constraint data1, NullableMethodAnalysisData.Constraint data2) {
        if (data1.equals(data2)) {
            return data1;
        }
        return new NullableMethodAnalysisData.Constraint(data1.calls | data2.calls, data1.nulls | data2.nulls);
    }
}

