/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RefPackageImpl
extends RefEntityImpl
implements RefPackage {
    private final String myQualifiedName;

    public RefPackageImpl(@NotNull String name, @NotNull RefManager refManager) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefPackageImpl", "<init>"));
        }
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/reference/RefPackageImpl", "<init>"));
        }
        super(RefPackageImpl.getPackageSuffix(name), refManager);
        this.myQualifiedName = name;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefPackageImpl", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    private static String getPackageSuffix(@NotNull String fullName) {
        if (fullName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullName", "com/intellij/codeInspection/reference/RefPackageImpl", "getPackageSuffix"));
        }
        int dotIndex = fullName.lastIndexOf(46);
        String string = dotIndex >= 0 ? fullName.substring(dotIndex + 1) : fullName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefPackageImpl", "getPackageSuffix"));
        }
        return string;
    }

    @Override
    public void accept(final @NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefPackageImpl", "accept"));
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ((RefJavaVisitor)visitor).visitPackage((RefPackage)RefPackageImpl.this);
                }
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getExternalName() {
        return this.getQualifiedName();
    }

    public static RefEntity packageFromFQName(RefManager manager, String name) {
        return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getPackage(name);
    }

    public boolean isValid() {
        return true;
    }

    public Icon getIcon(boolean expanded) {
        return PlatformIcons.PACKAGE_ICON;
    }
}

