/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.compiler.classFilesIndex.chainsSearch.CachedRelevantStaticMethodSearcher;
import com.intellij.compiler.classFilesIndex.chainsSearch.ChainCompletionStringUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.ChainRelevance;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodsChain;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.ChainCompletionLookupElementUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.ChainCompletionNewVariableLookupElement;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.WeightableChainLookupElement;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub.GetterLookupSubLookupElement;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub.SubLookupElement;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub.VariableSubLookupElement;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ContextRelevantStaticMethod;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ContextRelevantVariableGetter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodsChainLookupRangingHelper {
    public static List<LookupElement> chainsToWeightableLookupElements(List<MethodsChain> chains, ChainCompletionContext context) {
        CachedRelevantStaticMethodSearcher staticMethodSearcher = new CachedRelevantStaticMethodSearcher(context);
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>(chains.size());
        for (MethodsChain chain : chains) {
            LookupElement lookupElement = MethodsChainLookupRangingHelper.chainToWeightableLookupElement(chain, context, staticMethodSearcher);
            if (lookupElement == null) continue;
            lookupElements.add(lookupElement);
        }
        return lookupElements;
    }

    @Nullable
    private static LookupElement chainToWeightableLookupElement(MethodsChain chain, ChainCompletionContext context, CachedRelevantStaticMethodSearcher staticMethodSearcher) {
        int chainSize = chain.size();
        assert (chainSize != 0);
        int lastMethodWeight = chain.getChainWeight();
        int unreachableParametersCount = 0;
        int notMatchedStringVars = 0;
        int matchedParametersInContext = 0;
        Boolean isFirstMethodStatic = null;
        Boolean hasCallingVariableInContext = null;
        ChainCompletionNewVariableLookupElement chainLookupElement = null;
        PsiClass newVariableClass = null;
        NullableNotNullManager nullableNotNullManager = NullableNotNullManager.getInstance((Project)context.getProject());
        for (PsiMethod[] psiMethods : chain.getPath()) {
            PsiClass qualifierClass;
            boolean isHead;
            PsiMethod method = MethodChainsSearchUtil.getMethodWithMinNotPrimitiveParameters(psiMethods, Collections.singleton(context.getTarget().getClassQName()));
            if (method == null) {
                return null;
            }
            if (isFirstMethodStatic == null) {
                isFirstMethodStatic = psiMethods[0].hasModifierProperty("static");
            }
            boolean bl = isHead = chainLookupElement == null;
            if (isHead) {
                String qualifierClassName = chain.getQualifierClassName();
                qualifierClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(qualifierClassName, context.getResolveScope());
            } else {
                qualifierClass = null;
            }
            MethodProcResult procResult = MethodsChainLookupRangingHelper.processMethod(method, qualifierClass, isHead, lastMethodWeight, context, staticMethodSearcher, nullableNotNullManager);
            if (procResult == null) {
                return null;
            }
            if (hasCallingVariableInContext == null) {
                hasCallingVariableInContext = procResult.hasCallingVariableInContext();
            }
            if (isHead && procResult.isIntroduceNewVariable()) {
                newVariableClass = qualifierClass;
            }
            matchedParametersInContext += procResult.getMatchedParametersInContext();
            unreachableParametersCount += procResult.getUnreachableParametersCount();
            notMatchedStringVars += procResult.getNotMatchedStringVars();
            chainLookupElement = isHead ? procResult.getLookupElement() : new JavaChainLookupElement((LookupElement)chainLookupElement, procResult.getLookupElement());
        }
        if (newVariableClass != null) {
            chainLookupElement = ChainCompletionNewVariableLookupElement.create(newVariableClass, chainLookupElement);
        }
        ChainRelevance relevance = new ChainRelevance(chainSize, lastMethodWeight, unreachableParametersCount, notMatchedStringVars, hasCallingVariableInContext, isFirstMethodStatic, matchedParametersInContext);
        return new WeightableChainLookupElement((LookupElement)chainLookupElement, relevance);
    }

    @Nullable
    private static MethodProcResult processMethod(@NotNull PsiMethod method, @Nullable PsiClass qualifierClass, boolean isHeadMethod, int weight, ChainCompletionContext context, CachedRelevantStaticMethodSearcher staticMethodSearcher, NullableNotNullManager nullableNotNullManager) {
        Object lookupElement;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/compiler/classFilesIndex/chainsSearch/MethodsChainLookupRangingHelper", "processMethod"));
        }
        int unreachableParametersCount = 0;
        int notMatchedStringVars = 0;
        int matchedParametersInContext = 0;
        boolean hasCallingVariableInContext = false;
        boolean introduceNewVariable = false;
        PsiParameterList parameterList = method.getParameterList();
        TIntObjectHashMap parametersMap = new TIntObjectHashMap(parameterList.getParametersCount());
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            String typeQName = parameter.getType().getCanonicalText();
            if ("java.lang.String".equals(typeQName)) {
                PsiVariable relevantStringVar = context.findRelevantStringInContext(parameter.getName());
                if (relevantStringVar == null) {
                    ++notMatchedStringVars;
                    continue;
                }
                parametersMap.put(i, (Object)new VariableSubLookupElement(relevantStringVar));
                continue;
            }
            if (ChainCompletionStringUtil.isPrimitiveOrArrayOfPrimitives(typeQName)) continue;
            Collection<PsiVariable> contextVariables = context.getVariables(typeQName);
            PsiVariable contextVariable = (PsiVariable)ContainerUtil.getFirstItem(contextVariables, null);
            if (contextVariable != null) {
                if (contextVariables.size() == 1) {
                    parametersMap.put(i, (Object)new VariableSubLookupElement(contextVariable));
                }
                ++matchedParametersInContext;
                continue;
            }
            Collection<ContextRelevantVariableGetter> relevantVariablesGetters = context.getRelevantVariablesGetters(typeQName);
            ContextRelevantVariableGetter contextVariableGetter = (ContextRelevantVariableGetter)ContainerUtil.getFirstItem(relevantVariablesGetters, null);
            if (contextVariableGetter != null) {
                if (relevantVariablesGetters.size() == 1) {
                    parametersMap.put(i, (Object)contextVariableGetter.createSubLookupElement());
                }
                ++matchedParametersInContext;
                continue;
            }
            Collection<PsiMethod> containingClassMethods = context.getContainingClassMethods(typeQName);
            PsiMethod contextRelevantGetter = (PsiMethod)ContainerUtil.getFirstItem(containingClassMethods, null);
            if (contextRelevantGetter != null) {
                if (containingClassMethods.size() == 1) {
                    parametersMap.put(i, (Object)new GetterLookupSubLookupElement(method.getName()));
                }
                ++matchedParametersInContext;
                continue;
            }
            ContextRelevantStaticMethod contextRelevantStaticMethod = (ContextRelevantStaticMethod)ContainerUtil.getFirstItem(staticMethodSearcher.getRelevantStaticMethods(typeQName, weight), null);
            if (contextRelevantStaticMethod != null) {
                ++matchedParametersInContext;
                continue;
            }
            if (nullableNotNullManager.isNullable((PsiModifierListOwner)parameter, true)) continue;
            ++unreachableParametersCount;
        }
        if (isHeadMethod) {
            if (method.hasModifierProperty("static")) {
                hasCallingVariableInContext = true;
                lookupElement = ChainCompletionLookupElementUtil.createLookupElement(method, (TIntObjectHashMap<SubLookupElement>)parametersMap);
            } else {
                if (method.isConstructor()) {
                    return null;
                }
                String classQName = qualifierClass.getQualifiedName();
                if (classQName == null) {
                    return null;
                }
                Object e = ContainerUtil.getFirstItem(context.getContextRefElements(classQName), null);
                if (e != null) {
                    VariableLookupItem firstChainElement;
                    if (e instanceof PsiVariable) {
                        firstChainElement = new VariableLookupItem((PsiVariable)e);
                    } else if (e instanceof PsiMethod) {
                        firstChainElement = ChainCompletionLookupElementUtil.createLookupElement((PsiMethod)e, null);
                    } else if (e instanceof LookupElement) {
                        firstChainElement = (LookupElement)e;
                    } else {
                        throw new AssertionError();
                    }
                    hasCallingVariableInContext = true;
                    lookupElement = new JavaChainLookupElement((LookupElement)firstChainElement, ChainCompletionLookupElementUtil.createLookupElement(method, (TIntObjectHashMap<SubLookupElement>)parametersMap));
                } else {
                    lookupElement = ChainCompletionLookupElementUtil.createLookupElement(method, (TIntObjectHashMap<SubLookupElement>)parametersMap);
                    if (!context.getContainingClassQNames().contains(classQName)) {
                        introduceNewVariable = true;
                    }
                }
            }
        } else {
            lookupElement = ChainCompletionLookupElementUtil.createLookupElement(method, (TIntObjectHashMap<SubLookupElement>)parametersMap);
        }
        return new MethodProcResult((LookupElement)lookupElement, unreachableParametersCount, notMatchedStringVars, hasCallingVariableInContext, introduceNewVariable, matchedParametersInContext);
    }

    private static class MethodProcResult {
        private final LookupElement myMethodLookup;
        private final int myUnreachableParametersCount;
        private final int myNotMatchedStringVars;
        private final boolean myHasCallingVariableInContext;
        private final boolean myIntroduceNewVariable;
        private final int myMatchedParametersInContext;

        private MethodProcResult(LookupElement methodLookup, int unreachableParametersCount, int notMatchedStringVars, boolean hasCallingVariableInContext, boolean introduceNewVariable, int matchedParametersInContext) {
            this.myMethodLookup = methodLookup;
            this.myUnreachableParametersCount = unreachableParametersCount;
            this.myNotMatchedStringVars = notMatchedStringVars;
            this.myHasCallingVariableInContext = hasCallingVariableInContext;
            this.myIntroduceNewVariable = introduceNewVariable;
            this.myMatchedParametersInContext = matchedParametersInContext;
        }

        private boolean isIntroduceNewVariable() {
            return this.myIntroduceNewVariable;
        }

        private boolean hasCallingVariableInContext() {
            return this.myHasCallingVariableInContext;
        }

        private LookupElement getLookupElement() {
            return this.myMethodLookup;
        }

        private int getUnreachableParametersCount() {
            return this.myUnreachableParametersCount;
        }

        private int getNotMatchedStringVars() {
            return this.myNotMatchedStringVars;
        }

        public int getMatchedParametersInContext() {
            return this.myMatchedParametersInContext;
        }
    }
}

