/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressForClassFix;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompilerPropertiesAction;
import com.intellij.compiler.impl.ExcludeFromCompileAction;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CompilerErrorTreeView
extends NewErrorTreeViewPanel {
    public CompilerErrorTreeView(Project project, Runnable rerunAction) {
        super(project, "reference.toolWindows.messages", true, true, rerunAction);
    }

    @Override
    protected void fillRightToolbarGroup(DefaultActionGroup group) {
        super.fillRightToolbarGroup(group);
        group.add((AnAction)new CompilerPropertiesAction());
    }

    @Override
    protected void addExtraPopupMenuActions(DefaultActionGroup group) {
        group.add((AnAction)new ExcludeFromCompileAction(this.myProject, this));
        group.addSeparator();
        group.add((AnAction)new SuppressJavacWarningsAction());
        group.add((AnAction)new SuppressJavacWarningForClassAction());
        group.addSeparator();
        ActionGroup popupGroup = (ActionGroup)ActionManager.getInstance().getAction("CompilerErrorViewPopupMenu");
        if (popupGroup != null) {
            for (AnAction action : popupGroup.getChildren(null)) {
                group.add(action);
            }
        }
    }

    @Override
    protected boolean shouldShowFirstErrorInEditor() {
        return CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).AUTO_SHOW_ERRORS_IN_EDITOR;
    }

    private class SuppressJavacWarningForClassAction
    extends SuppressJavacWarningsAction {
        private SuppressJavacWarningForClassAction() {
        }

        @Override
        protected SuppressFix getSuppressAction(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningForClassAction", "getSuppressAction"));
            }
            return new SuppressForClassFix(id){

                @Override
                protected boolean use15Suppressions(@NotNull PsiDocCommentOwner container) {
                    if (container == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningForClassAction$1", "use15Suppressions"));
                    }
                    return true;
                }
            };
        }
    }

    private class SuppressJavacWarningsAction
    extends AnAction {
        private SuppressJavacWarningsAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            NavigatableMessageElement messageElement = (NavigatableMessageElement)CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            String[] text = messageElement.getText();
            String id = text[0].substring(1, text[0].indexOf("]"));
            final SuppressFix suppressInspectionFix = this.getSuppressAction(id);
            final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            assert (project != null);
            final OpenFileDescriptor navigatable = (OpenFileDescriptor)messageElement.getNavigatable();
            final PsiFile file = PsiManager.getInstance((Project)project).findFile(navigatable.getFile());
            assert (file != null);
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                suppressInspectionFix.invoke(project, file.findElementAt(navigatable.getOffset()));
                            }
                            catch (IncorrectOperationException e1) {
                                LOG.error((Throwable)e1);
                            }
                        }
                    });
                }
            }, suppressInspectionFix.getText(), null);
        }

        public void update(AnActionEvent e) {
            Navigatable navigatable;
            NavigatableMessageElement messageElement;
            String[] text;
            Presentation presentation = e.getPresentation();
            presentation.setVisible(false);
            presentation.setEnabled(false);
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            ErrorTreeElement errorTreeElement = CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            if (errorTreeElement instanceof NavigatableMessageElement && (text = (messageElement = (NavigatableMessageElement)errorTreeElement).getText()).length > 0 && text[0].startsWith("[") && text[0].indexOf("]") != -1 && (navigatable = messageElement.getNavigatable()) instanceof OpenFileDescriptor) {
                OpenFileDescriptor fileDescriptor = (OpenFileDescriptor)navigatable;
                VirtualFile virtualFile = fileDescriptor.getFile();
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                if (module == null) {
                    return;
                }
                Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (jdk == null) {
                    return;
                }
                boolean is_1_5 = JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_5);
                if (!is_1_5) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (psiFile == null) {
                    return;
                }
                if (LanguageLevelUtil.getEffectiveLanguageLevel((Module)module).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                    return;
                }
                PsiElement context = psiFile.findElementAt(fileDescriptor.getOffset());
                if (context == null) {
                    return;
                }
                String id = text[0].substring(1, text[0].indexOf("]"));
                SuppressFix suppressInspectionFix = this.getSuppressAction(id);
                boolean available = suppressInspectionFix.isAvailable(project, context);
                presentation.setEnabled(available);
                presentation.setVisible(available);
                if (available) {
                    presentation.setText(suppressInspectionFix.getText());
                }
            }
        }

        protected SuppressFix getSuppressAction(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction", "getSuppressAction"));
            }
            return new SuppressFix(id){

                @Override
                public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction$2", "isAvailable"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction$2", "isAvailable"));
                    }
                    if (this.getContainer(context) instanceof PsiClass) {
                        return false;
                    }
                    return super.isAvailable(project, context);
                }

                @Override
                protected boolean use15Suppressions(@NotNull PsiDocCommentOwner container) {
                    if (container == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction$2", "use15Suppressions"));
                    }
                    return true;
                }
            };
        }
    }
}

