/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.nio.ByteBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0011\"\u0002\u0001\u0006\u0003!9Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u00035\u0005B!\u0001E\u0004\u001b\u001dI!!C\u0001\u0019\u0003%\u0011\u0011\"\u0001\r\u00031\u0003IB\u0001\u0003\u0003\u000e\u00051\u0005\u0001\u0014\u0002+\u0004\u0007EIB!\u0011\u0005\t\u00015\r\u0012BB\u0005\u0006!\u0007)\"\u0001$\u0001\u0019\u0003a\t\u0011BB\u0005\u0006!\u0007)\"\u0001$\u0001\u0019\u0005a\u0011\u0001\u0014A)\u0004\u0003\u0011\u0015\u0011kA\u0001\u0006\u0001Q\u001b1\u0001"}, strings={"NON_EXISTENT_FILE_DATA", "Lcom/intellij/openapi/util/Pair;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "DirectoryBasedStorageKt", "loadFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;"}, moduleName="configuration-store-impl")
public final class DirectoryBasedStorageKt {
    private static final Pair<byte[], String> NON_EXISTENT_FILE_DATA = Pair.create(null, (Object)SystemProperties.getLineSeparator());

    private static final Pair<byte[], String> loadFile(VirtualFile file) {
        if (file == null || !file.exists()) {
            Pair<byte[], String> pair = NON_EXISTENT_FILE_DATA;
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"NON_EXISTENT_FILE_DATA");
            return pair;
        }
        byte[] bytes = file.contentsToByteArray();
        String lineSeparator = file.getDetectedLineSeparator();
        if (lineSeparator == null) {
            CharSequence charSequence = CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(bytes));
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"CharsetToolkit.UTF8_CHAR\u2026e(ByteBuffer.wrap(bytes))");
            lineSeparator = FileBasedStorageKt.detectLineSeparators(charSequence, null).getSeparatorString();
        }
        Pair pair = Pair.create((Object)bytes, (Object)lineSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create<ByteArray, S\u2026ng>(bytes, lineSeparator)");
        return pair;
    }

    @NotNull
    public static final /* synthetic */ Pair<byte[], String> access$loadFile(@Nullable VirtualFile file) {
        return DirectoryBasedStorageKt.loadFile(file);
    }
}

