/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.SchemeManagerImplKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntProgression;
import kotlin.IntRange;
import kotlin.RangesKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0004)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0006\u0015\t\u0001\"A\u0003\u0002\t\r)\u0011\u0001#\u0004\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005!\u0011!B\u0001\t\"\u0015\t\u00012A\u0003\u0002\t\u000f)\u0011\u0001\u0003\t\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0007\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001\u0003\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\n\u000b\u0005a\u0011!B\u0001\u0005\b\u0015\tA\"A\u0003\u0002\t\ra\u0001!\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u0002+\u0019!\t\u0001c\u0001\u0016\u0003a\u0011Q#\u0001S\u00013\u001dI!!C\u0001%\u0002%\u0011\u0011\"\u0001S\u00021\u000bI\u0012\u0001G\u0002\u001e\u0002}\n\u001b%C\u0002\t\b5\t\u0001\u0004B\u0005\u0007\u0011\u0013iA!\u0003\u0002\n\u0003q\u0005\u0001$B\u0005\u0005\u0011\u0017i!\u0001$\u0001\u0019\r%\u0019\u0001RB\u0007\u00021\u001dIA\u0001B\u0001\t\u00105\t\u0001\u0004C\u0005\u0006\t\u0005A\t\"\u0004\u0002\r\u0002aI\u0011kA\u0001\t\u0014\u0015vAa\u0003\u0005\u0015\u001b\u0005AJ#G\u0002\t+5\tA\u0004A\r\u0004\u0011Wi\u0011\u0001g\tR\u0007\u0005Aa#J\u0005\u0005\u0003!5R\"\u0001M\u00153\u0011A\t\"\u0004\u0002\r\u0002aIQ\u0005\u0003\u0003\u0002\u0011]i\u0011\u0001g\t\u001a\u0007!=R\"\u0001\r\u0019K\u0011!1\u0002#\r\u000e\u0003a%RE\u0004\u0003\u0002\u0011eiA!\u0003\u0002\n\u0003a!\u00014G\r\u0007\u0011AiA!\u0003\u0002\n\u0003q\u0001\u00014G\u0013\f\t\u0005A!$D\u0001\u0019*e1\u0001RG\u0007\u0005\u0013\tI\u0011\u0001g\u000e\u00197\u0015^A!\u0001\u0005\u001d\u001b\ta\t\u0001(\u0001\u001a\u0007!\u0015R\"\u0001\r\u0005#\u000e\t\u0001\u0012HS\f\t-AQ$\u0004\u0002\r\u0002q\u0001\u0011d\u0001E\u001e\u001b\u0005AB!U\u0002\u0002\u0011s)s\u0001B\u0006\t=5!\u0011BA\u0005\u00021\u0011A\u001a$\n\f\u0005\u0017!uRbE\u0005\u0007\u0013\u0015\u0001r$\u0006\u0002\r\u0002q\u0001A\u0004\u0001\t +%Ia!C\u0003\u0011?U\u0011A\u0012\u0001\u000f\u00019\u0001a\t\u0001g\u0010\u00197\u0015>Aa\u0003\u0005!\u001b\ta\t\u0001\b\u0001R\u0007\u0005A\t%J\u0003\u0005\u0017!\tSB\u0001G\u00011\u0011)S\u0001B\u0001\tD5\u0011A\u0012\u0001\r\rK1!\u0011\u0001\u0003\u0012\u000e\u0003a!\u0011d\u0001E\u0013\u001b\u0005A\u0002$G\u0002\tF5\t\u00014E\u0013\u0005\t-A1%D\u0001\u0019\u000f\u0015jA!\u0001E$\u001b\u000fAB%U\u0002\u0002\t\u0013J2\u0001C\u000b\u000e\u0003q\u0005\u0011kA\u0001\tK\u0015VAa\u0003E&\u001b\u0005A\u001a#G\u0002\t+5\tA\u0014A)\u0004\u0003!1S\u0005\u0003\u0003\u0002\u0011\u001bj\u0011\u0001g\t\u001a\u0007!9S\"\u0001\r\rK!!\u0011\u0001#\u0014\u000e\u0003a\r\u0012d\u0001E(\u001b\u0005A\u0002&*\u0006\u0005\u0003!ES\"\u0001M\u00123\rA\u0011&D\u0001\u001d\u0002E\u001b\u0011\u0001\u0003\u0014&\u0016\u0011\t\u00012K\u0007\u00021GI2\u0001C\u000b\u000e\u0003q\u0005\u0011kA\u0001\tM\u0015JBa\u0003\u0005+\u001b\u0005AJ#G\u0002\tV5\t\u0001\u0004B\r\u0004\u0011-j\u0011\u0001g\u0016\u001a\u0019!aSBC\u0005\u0003\u0013\u0005AR&\u0003\u0002\n\u0003q\u0001\u0011BA\u0005\u00021oAJ&j\n\u0005\u0003!mSB\u0001G\u00019\u0003I2\u0001#\n\u000e\u0003aA\u0012d\u0001\u0005/\u001b\u0005Aj&G\u0002\t_5\t\u00014E)\u0004\u0003!}Se\u0002\u0003\f\u0011AjA!\u0003\u0002\n\u0003q\u0005\u00014GS\u000b\t\u0005A\t'D\u0001\u0019*e\u0019\u0001\"M\u0007\u00029\u0001\t6!\u0001E2K?!\u0011\u0001\u0003\u001a\u000e\u00051\u0005A\u0014A\r\u0004\u0011\u001dj\u0011\u0001\u0007\u0007\u001a\u0007!yS\"\u0001M\u0012#\u000e\t\u0001RM\u0013\n\t\u0005A1'D\u0001\u0019*e!\u0001\u0012C\u0007\u0003\u0019\u0003A\u0012\"J\u0002\th5\t\u0001\u0014F\u0013\f\t\u0005AA'D\u0001\u0019*e1\u0001RG\u0007\u0005\u0013\tI\u0011\u0001g\u000e\u00197\u0015\"A!\u0001E5\u001b\u0005AJ#*\u0006\u0005\u0017!)T\"\u0001M\u00153\rAQ#D\u0001\u001d\u0001E\u001b\u0011\u0001c\u0019&\u0017\u0011\t\u00012N\u0007\u00021SIb\u0001\u0003\u001c\u000e\t%\u0011\u0011\"\u0001\u000f\u00011\u007f)#\u0002#\u001c\u000e\u0003a%\u0012D\u0002E\u001b\u001b\u0011I!!C\u0001\u00198aYRU\u0004\u0003\u0002\u0011]j\u0011\u0001'\u000b\u001a\u0007!)R\"\u0001O\u00013\rAy'D\u0001\u0019qE\u001b\u0011\u0001#\u001d& \u0011Y\u0001\"O\u0007\u00021SIB\u0001C\u000b\u000e\u00051\u0005A\u0004A\r\u0004\u0011gj\u0011\u0001g\tR\u0007\u0005Aa#J\u0007\u0005\u0017!QT\"\u0001M\u00153\u0011AY$\u0004\u0002\r\u0002a!\u0011d\u0001E:\u001b\u0005A\u001a#*\u000e\u0005\u0017!UT\"\u0001M\u00153\u0019Aa'\u0004\u0003\n\u0005%\tA\u0004\u0001M 3\u0011A1(\u0004\u0002\r\u0002q\u0001\u0011d\u0002E<\u001b\u0015I!!C\u0001\u001d\u00011\u0005\u0001\u0004P)\u0004\u0003!eT\u0005\u0002\u0003\f\u0011uj\u0011\u0001\u0007\u0003&\u0013\u0011\r\u0005\u0003c\u001f\u000e\u0003q\u0005Q#\u0001\r\u0003#\u000e\t\u0001BP\u0013\u0007\t\u0005Ai(D\u0001\u0019*U\t\u0001tD\u0015\u000b\t\u0007c\u0002BC\u0007\u0003\u0019\u0003AB\u0001H\u0001!\u0003E\u001b\u0011!\u0002\u0001*\u0013\u0011\tE\u0004#\u0006\u000e\u00051\u0005A\u0004A)\u0004\u0005\u0015\t\u0001bC\u0015\t\t\u0005c\u0002rC\u0007\u0003\u0019\u0003AB\"U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u000fi\u0011\u0001\u0007\u0003R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0003\"AI\"\u0004\u0003\n\u0005%\t\u0001\u0004\u0002\r\u000e#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001RB\u0007\u00021\u001d\t6!A\u0003\u0001S)!\u0011\t\u0003E\u0005\u001b\u0011I!!C\u0001\u001d\u0002a)\u0011kA\u0001\u0006\u0001%BA!\u0011\u0005\t\f5\u0011A\u0012\u0001\r\u0007#\u000e\tQ\u0001A\u0015\u000e\t\u0005C\u00012D\u0007\b\u0013\tI\u0011\u0001\u0007\u0003\n\u0005%\tA\u0014\u0001\r\u000f#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001rB\u0007\u00021!\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u000f\u001b\u0005AB!U\u0002\u0002\u000b\u0001IS\u0002B!\t\u0011=iq!\u0003\u0002\n\u0003q\u0005\u0011BA\u0005\u00021?Ab\"U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011AiA!\u0003\u0002\n\u0003q\u0001\u0001\u0014E)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\tR\"\u0001M\u0012#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BE\u0007\u00021G\t6!A\u0003\u0001S5!\u0011\t\u0003E\u0013\u001b\ta\t\u0001\u0007\u0003\u0016\u0003a\u0011A$I)\u0004\u00075\u0011Aa\u0005E\u0014"}, strings={"Lcom/intellij/configurationStore/SchemeManagerImpl;", "T", "Lcom/intellij/openapi/options/Scheme;", "E", "Lcom/intellij/openapi/options/ExternalizableScheme;", "Lcom/intellij/openapi/options/SchemesManager;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "fileSpec", "", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "ioDirectory", "Ljava/io/File;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "virtualFileTrackerDisposable", "Lcom/intellij/openapi/Disposable;", "(Ljava/lang/String;Lcom/intellij/openapi/options/SchemeProcessor;Lcom/intellij/configurationStore/StreamProvider;Ljava/io/File;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/Disposable;)V", "currentPendingSchemeName", "currentScheme", "Lcom/intellij/openapi/options/Scheme;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToDelete", "Lgnu/trove/THashSet;", "readOnlyExternalizableSchemes", "Lgnu/trove/THashMap;", "schemeExtension", "schemeToInfo", "Lcom/intellij/configurationStore/SchemeManagerImpl$ExternalInfo;", "schemes", "Ljava/util/ArrayList;", "updateExtension", "", "useVfs", "fileName", "getFileName", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Ljava/lang/String;", "addNewScheme", "", "scheme", "replaceExisting", "(Lcom/intellij/openapi/options/Scheme;Z)V", "addVfsListener", "canRead", "name", "", "clearAllSchemes", "collectExistingNames", "", "deleteFiles", "errors", "", "", "findExternalizableSchemeByFileName", "(Ljava/lang/String;)Lcom/intellij/openapi/options/Scheme;", "findSchemeByName", "schemeName", "getAllSchemeNames", "getAllSchemes", "kotlin.jvm.PlatformType", "", "getCurrentScheme", "()Lcom/intellij/openapi/options/Scheme;", "getCurrentSchemeName", "getDirectory", "getFileExtension", "allowAny", "getRootDirectory", "getState", "Lcom/intellij/openapi/options/SchemeProcessor$State;", "Lorg/jetbrains/annotations/NotNull;", "(Lcom/intellij/openapi/options/Scheme;)Lcom/intellij/openapi/options/SchemeProcessor$State;", "isMetadataEditable", "(Lcom/intellij/openapi/options/Scheme;)Z", "isMy", "file", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "isOverwriteOnLoad", "existingScheme", "isRenamed", "loadBundledScheme", "resourceName", "requestor", "", "convertor", "Lcom/intellij/util/ThrowableConvertor;", "Lorg/jdom/Element;", "loadScheme", "input", "Ljava/io/InputStream;", "duringLoad", "(Ljava/lang/CharSequence;Ljava/io/InputStream;Z)Lcom/intellij/openapi/options/Scheme;", "loadSchemes", "processPendingCurrentSchemeName", "newScheme", "(Lcom/intellij/openapi/options/Scheme;)V", "readSchemeFromFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)Lcom/intellij/openapi/options/Scheme;", "refreshVirtualDirectoryAndAddListener", "reload", "removeDirectoryIfEmpty", "removeExternalizableSchemes", "removeScheme", "retainExternalInfo", "newSchemes", "save", "saveScheme", "nameGenerator", "Lcom/intellij/util/text/UniqueNameGenerator;", "(Lcom/intellij/openapi/options/Scheme;Lcom/intellij/util/text/UniqueNameGenerator;)V", "setCurrent", "notify", "setCurrentSchemeName", "setSchemes", "newCurrentScheme", "removeCondition", "Lcom/intellij/openapi/util/Condition;", "(Ljava/util/List;Lcom/intellij/openapi/options/Scheme;Lcom/intellij/openapi/util/Condition;)V", "toString", "asExternalizable", "(Lcom/intellij/openapi/options/ExternalizableScheme;)Lcom/intellij/openapi/options/Scheme;", "scheduleDelete", "ExternalInfo"}, moduleName="configuration-store-impl")
public final class SchemeManagerImpl<T extends Scheme, E extends ExternalizableScheme & T>
extends SchemesManager<T, E>
implements SafeWriteRequestor {
    private final ArrayList<T> schemes;
    private final THashMap<String, E> readOnlyExternalizableSchemes;
    private volatile String currentPendingSchemeName;
    private T currentScheme;
    private VirtualFile directory;
    private final String schemeExtension;
    private final boolean updateExtension;
    private final THashSet<String> filesToDelete;
    private final THashMap<E, ExternalInfo> schemeToInfo;
    private final boolean useVfs;
    private final String fileSpec;
    private final SchemeProcessor<E> processor;
    private final StreamProvider provider;
    private final File ioDirectory;
    private final RoamingType roamingType;

    private final void refreshVirtualDirectoryAndAddListener(Disposable virtualFileTrackerDisposable) {
        VirtualFile directory;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        if (virtualFile == null) {
            return;
        }
        this.directory = directory = virtualFile;
        directory.getChildren();
        if (directory instanceof NewVirtualFile) {
            ((NewVirtualFile)directory).markDirty();
        }
        directory.refresh(true, false, new Runnable(this, virtualFileTrackerDisposable){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ Disposable $virtualFileTrackerDisposable;

            public final void run() {
                SchemeManagerImpl.access$addVfsListener(this.this$0, this.$virtualFileTrackerDisposable);
            }
            {
                this.this$0 = schemeManagerImpl;
                this.$virtualFileTrackerDisposable = disposable;
            }
        });
    }

    private final void addVfsListener(Disposable virtualFileTrackerDisposable) {
        Object object = ServiceManager.getService(VirtualFileTracker.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)object;
        String string = "file://" + StringsKt.replace$default((String)this.ioDirectory.getAbsolutePath(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4);
        VirtualFileListener virtualFileListener = (VirtualFileListener)new VirtualFileAdapter(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null || !SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    return;
                }
                String string = event.getFile().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
                E oldScheme = SchemeManagerImpl.access$findExternalizableSchemeByFileName(this.this$0, string);
                Object oldCurrentScheme = null;
                if (oldScheme != null) {
                    oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$p(this.this$0);
                    this.this$0.removeScheme(oldScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeDeleted((ExternalizableScheme)oldScheme);
                }
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                E newScheme = SchemeManagerImpl.access$readSchemeFromFile(this.this$0, virtualFile, false);
                if (newScheme != null) {
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).initScheme((ExternalizableScheme)newScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeAdded((ExternalizableScheme)newScheme);
                    this.updateCurrentScheme(oldCurrentScheme, newScheme);
                }
            }

            private final void updateCurrentScheme(T oldCurrentScheme, E newCurrentScheme) {
                if (Intrinsics.areEqual(oldCurrentScheme, SchemeManagerImpl.access$getCurrentScheme$p(this.this$0)) ^ true && SchemeManagerImpl.access$getCurrentScheme$p(this.this$0) == null) {
                    Object object = newCurrentScheme;
                    if (object == null) {
                        object = (Scheme)CollectionsKt.firstOrNull((List)SchemeManagerImpl.access$getSchemes$p(this.this$0));
                    }
                    this.this$0.setCurrent((Scheme)object);
                }
            }

            static /* bridge */ /* synthetic */ void updateCurrentScheme$default(addVfsListener.1 var0, Scheme scheme, Scheme scheme2, int n) {
                if ((n & 2) != 0) {
                    scheme2 = null;
                }
                var0.updateCurrentScheme(scheme, scheme2);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        VirtualFile[] virtualFileArray = dir.getChildren();
                        for (int i = 0; i < virtualFileArray.length; ++i) {
                            VirtualFile file;
                            VirtualFile virtualFile = file = virtualFileArray[i];
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                            if (!SchemeManagerImpl.access$isMy(this.this$0, virtualFile)) continue;
                            VirtualFile virtualFile2 = file;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                            this.schemeCreatedExternally(virtualFile2);
                        }
                    }
                } else if (SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                    this.schemeCreatedExternally(virtualFile);
                }
            }

            private final void schemeCreatedExternally(VirtualFile file) {
                E readScheme = SchemeManagerImpl.access$readSchemeFromFile(this.this$0, file, false);
                if (readScheme != null) {
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).initScheme((ExternalizableScheme)readScheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeAdded((ExternalizableScheme)readScheme);
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                T oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$p(this.this$0);
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory$p(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        SchemeManagerImpl.access$setDirectory$p(this.this$0, null);
                        SchemeManagerImpl.access$removeExternalizableSchemes(this.this$0);
                    }
                } else if (SchemeManagerImpl.access$isMy(this.this$0, event)) {
                    String string = event.getFile().getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.file.name");
                    E e = SchemeManagerImpl.access$findExternalizableSchemeByFileName(this.this$0, string);
                    if (e == null) {
                        return;
                    }
                    E scheme = e;
                    this.this$0.removeScheme(scheme);
                    SchemeManagerImpl.access$getProcessor$p(this.this$0).onSchemeDeleted((ExternalizableScheme)scheme);
                }
                addVfsListener.1.updateCurrentScheme$default(this, oldCurrentScheme, null, 2);
            }
            {
                this.this$0 = $outer;
            }
        };
        Disposable disposable = virtualFileTrackerDisposable;
        if (disposable == null) {
            Intrinsics.throwNpe();
        }
        virtualFileTracker.addTracker(string, virtualFileListener, false, disposable);
    }

    /*
     * WARNING - void declaration
     */
    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull(convertor, (String)"convertor");
        try {
            URL url;
            URL uRL = url = requestor instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName);
            if (url == null) {
                ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName);
                return;
            }
            Element element = JDOMUtil.load((InputStream)URLUtil.openStream((URL)url));
            Scheme scheme = (Scheme)convertor.convert((Object)element);
            if (scheme instanceof ExternalizableScheme) {
                void $receiver;
                void $receiver2;
                String fileName = PathUtilRt.getFileName((String)url.getPath());
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                String extension = this.getFileExtension(charSequence, true);
                ExternalInfo info = new ExternalInfo(StringsKt.substring((String)fileName, (int)0, (int)(fileName.length() - extension.length())), extension);
                info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
                info.setSchemeName(((ExternalizableScheme)scheme).getName());
                Object object = (ExternalizableScheme)scheme;
                SchemeManagerImpl schemeManagerImpl = this;
                Object object2 = this.schemeToInfo;
                void v2 = $receiver2;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                Object object3 = (Scheme)v2;
                ExternalInfo oldInfo = (ExternalInfo)object2.put(object3, (Object)info);
                ComponentStoreImplKt.getLOG().assertTrue(oldInfo == null);
                ExternalizableScheme $i$f$asExternalizable = (ExternalizableScheme)scheme;
                object = this;
                object3 = ((ExternalizableScheme)scheme).getName();
                object2 = this.readOnlyExternalizableSchemes;
                void v3 = $receiver;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                Scheme scheme2 = (Scheme)v3;
                Scheme oldScheme = (Scheme)object2.put(object3, (Object)scheme2);
                if (oldScheme != null) {
                    ComponentStoreImplKt.getLOG().warn("Duplicated scheme " + ((ExternalizableScheme)scheme).getName() + " - old: " + oldScheme + ", new " + scheme);
                }
            }
            this.schemes.add(scheme);
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName, e);
        }
    }

    private final String getFileExtension(CharSequence fileName, boolean allowAny) {
        String string;
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.schemeExtension)) {
            string = this.schemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            string = ".xml";
        } else {
            String string2;
            if (allowAny) {
                string2 = PathUtil.getFileExtension((String)((Object)fileName).toString());
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                throw (Throwable)new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
            }
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (allowAny) {\n      Pa\u2026t be filtered out\")\n    }");
        }
        return string;
    }

    private final boolean isMy(VirtualFileEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        return this.isMy(virtualFile);
    }

    private final boolean isMy(VirtualFile file) {
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.schemeExtension);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<E> loadSchemes() {
        int n;
        int newSchemesOffset = this.schemes.size();
        if (this.provider != null && this.provider.getEnabled()) {
            this.provider.processChildren(this.fileSpec, this.roamingType, (Function1<? super String, ? extends Boolean>)((Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return SchemeManagerImpl.access$canRead(this.this$0, it);
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(1);
                }
            }), (Function3<? super String, ? super InputStream, ? super Boolean, ? extends Boolean>)((Function3)new Function3<String, InputStream, Boolean, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input, boolean readOnly) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    E scheme = SchemeManagerImpl.access$loadScheme(this.this$0, name, input, true);
                    if (readOnly && scheme != null) {
                        SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$p(this.this$0).put((Object)((ExternalizableScheme)scheme).getName(), scheme);
                    }
                    return true;
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(3);
                }
            }));
        } else {
            Unit unit;
            File[] fileArray = this.ioDirectory.listFiles(new FilenameFilter(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean accept(File parent, String name) {
                    CharSequence charSequence = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"name");
                    return SchemeManagerImpl.access$canRead(this.this$0, charSequence);
                }
                {
                    this.this$0 = schemeManagerImpl;
                }
            });
            if (fileArray != null) {
                File[] $receiver = fileArray;
                File[] it = $receiver;
                for (n = 0; n < it.length; ++n) {
                    File file = it[n];
                    if (file.isDirectory()) continue;
                    try {
                        CharSequence charSequence = file.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"file.name");
                        SchemeManagerImpl.super.loadScheme(charSequence, FilesKt.inputStream((File)file), true);
                        continue;
                    }
                    catch (Throwable e) {
                        ComponentStoreImplKt.getLOG().error("Cannot read scheme " + file.getPath(), e);
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        SmartList list = new SmartList();
        int it = newSchemesOffset;
        n = this.schemes.size() - 1;
        if (it <= n) {
            while (true) {
                void $receiver;
                void i;
                T t = this.schemes.get((int)i);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.options.ExternalizableScheme");
                }
                ExternalizableScheme $i$a$4 = (ExternalizableScheme)t;
                SchemeManagerImpl schemeManagerImpl = this;
                void v4 = $receiver;
                if (v4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                Scheme scheme = (Scheme)v4;
                this.processor.initScheme((ExternalizableScheme)scheme);
                list.add((Object)scheme);
                this.processPendingCurrentSchemeName(scheme);
                if (i == n) break;
                ++i;
            }
        }
        return (Collection)list;
    }

    public final void reload() {
        this.removeExternalizableSchemes();
        this.loadSchemes();
    }

    /*
     * WARNING - void declaration
     */
    private final void removeExternalizableSchemes() {
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)this.schemes)));
        int n = ((Number)intProgression.getStart()).intValue();
        int n2 = ((Number)intProgression.getEnd()).intValue();
        int n3 = ((Number)intProgression.getIncrement()).intValue();
        int n4 = ProgressionUtilKt.getProgressionFinalElement((int)n, (int)n2, (int)n3);
        int n5 = n;
        int n6 = n2;
        if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                Scheme scheme;
                if ((scheme = (Scheme)this.schemes.get((int)i)) instanceof ExternalizableScheme) {
                    ExternalizableScheme $receiver;
                    ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
                    SchemeProcessor<Scheme> schemeProcessor = this;
                    SchemeProcessor<Scheme> schemeProcessor2 = this;
                    void v3 = $receiver;
                    if (v3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    Scheme scheme2 = (Scheme)v3;
                    if (Intrinsics.areEqual((Object)schemeProcessor2.getState(scheme2), (Object)SchemeProcessor.State.NON_PERSISTENT) ^ true) {
                        if (Intrinsics.areEqual((Object)scheme, this.currentScheme)) {
                            this.currentScheme = null;
                        }
                        $receiver = (ExternalizableScheme)scheme;
                        schemeProcessor = this;
                        schemeProcessor2 = this.processor;
                        ExternalizableScheme externalizableScheme2 = $receiver;
                        if (externalizableScheme2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type E");
                        }
                        scheme2 = (Scheme)externalizableScheme2;
                        schemeProcessor2.onSchemeDeleted((ExternalizableScheme)scheme2);
                    }
                }
                if (i == n4) break;
                n = i + n3;
            }
        }
        this.retainExternalInfo((List)this.schemes);
    }

    /*
     * WARNING - void declaration
     */
    private final E findExternalizableSchemeByFileName(String fileName) {
        for (Scheme scheme : this.schemes) {
            void $receiver;
            if (!(scheme instanceof ExternalizableScheme) || !Intrinsics.areEqual((Object)fileName, (Object)(this.getFileName((ExternalizableScheme)scheme) + this.schemeExtension))) continue;
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            SchemeManagerImpl schemeManagerImpl = this;
            void v0 = $receiver;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            return (E)((Scheme)v0);
        }
        return (E)((Scheme)null);
    }

    private final boolean isOverwriteOnLoad(E existingScheme) {
        if ((Scheme)this.readOnlyExternalizableSchemes.get((Object)((ExternalizableScheme)existingScheme).getName()) == existingScheme) {
            return true;
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(existingScheme);
        return info != null && Intrinsics.areEqual((Object)this.schemeExtension, (Object)info.getFileExtension()) ^ true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final E loadScheme(CharSequence fileName, InputStream input, boolean duringLoad) {
        try {
            ExternalInfo info;
            Element element = JDOMUtil.load((InputStream)input);
            Scheme scheme = (Scheme)this.processor.readScheme(element, duringLoad);
            if (scheme == null) return (E)((Scheme)null);
            Scheme scheme2 = scheme;
            String extension = this.getFileExtension(fileName, false);
            String fileNameWithoutExtension = ((Object)fileName.subSequence(0, fileName.length() - extension.length())).toString();
            if (duringLoad) {
                if (CollectionsKt.isNotEmpty((Collection)((Collection)this.filesToDelete)) && this.filesToDelete.contains((Object)((Object)fileName).toString())) {
                    ComponentStoreImplKt.getLOG().warn("Scheme file " + "\"" + fileName + "\"" + " is not loaded because marked to delete");
                    return (E)((Scheme)null);
                }
                String string = ((ExternalizableScheme)scheme2).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scheme.name");
                T existingScheme = this.findSchemeByName(string);
                if (existingScheme != null) {
                    Scheme existingSchemeAsExternalizable;
                    Scheme scheme3;
                    if (existingScheme instanceof ExternalizableScheme) {
                        void $receiver;
                        ExternalizableScheme externalizableScheme = (ExternalizableScheme)existingScheme;
                        SchemeManagerImpl schemeManagerImpl = this;
                        void v2 = $receiver;
                        if (v2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type E");
                        }
                        scheme3 = (Scheme)v2;
                    } else {
                        scheme3 = existingSchemeAsExternalizable = (Scheme)null;
                    }
                    if (existingSchemeAsExternalizable != null && this.isOverwriteOnLoad(existingSchemeAsExternalizable)) {
                        this.removeScheme(existingScheme);
                    } else {
                        if (Intrinsics.areEqual((Object)this.schemeExtension, (Object)extension) ^ true && existingSchemeAsExternalizable != null) {
                            ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get((Object)existingSchemeAsExternalizable);
                            if (Intrinsics.areEqual((Object)(externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null), (Object)fileNameWithoutExtension)) {
                                this.filesToDelete.add((Object)((Object)fileName).toString());
                                return (E)((Scheme)null);
                            }
                        }
                        ComponentStoreImplKt.getLOG().warn("Scheme file " + "\"" + fileName + "\"" + " is not loaded because defines duplicated name " + "\"" + ((ExternalizableScheme)scheme2).getName() + "\"");
                        return (E)((Scheme)null);
                    }
                }
            }
            if ((info = (ExternalInfo)this.schemeToInfo.get((Object)scheme2)) == null) {
                info = new ExternalInfo(fileNameWithoutExtension, extension);
                this.schemeToInfo.put((Object)scheme2, (Object)info);
            } else {
                info.setFileNameWithoutExtension(fileNameWithoutExtension, extension);
            }
            info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
            info.setSchemeName(((ExternalizableScheme)scheme2).getName());
            if (duringLoad) {
                this.schemes.add(scheme2);
                return (E)scheme2;
            }
            this.addScheme(scheme2);
            return (E)scheme2;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((Scheme)null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getFileName(ExternalizableScheme $receiver) {
        void $receiver2;
        ExternalizableScheme externalizableScheme = $receiver;
        SchemeManagerImpl schemeManagerImpl = this;
        THashMap<E, ExternalInfo> tHashMap = this.schemeToInfo;
        void v0 = $receiver2;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type E");
        }
        Scheme scheme = (Scheme)v0;
        ExternalInfo externalInfo = (ExternalInfo)tHashMap.get((Object)scheme);
        return externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null;
    }

    private final boolean canRead(CharSequence name) {
        return this.updateExtension && StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".xml") || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)this.schemeExtension);
    }

    private final E readSchemeFromFile(VirtualFile file, boolean duringLoad) {
        CharSequence fileName;
        block5: {
            block4: {
                fileName = file.getNameSequence();
                if (file.isDirectory()) break block4;
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                if (this.canRead(charSequence)) break block5;
            }
            return (E)((Scheme)null);
        }
        try {
            CharSequence charSequence = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream");
            return this.loadScheme(charSequence, inputStream, duringLoad);
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((Scheme)null);
        }
    }

    public final void save(@NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList schemesToSave = new SmartList();
        for (Scheme scheme : this.schemes) {
            Unit unit;
            if (scheme instanceof ExternalizableScheme) {
                String fileName;
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type E");
                }
                SchemeProcessor.State state = this.getState(scheme2);
                if (Intrinsics.areEqual((Object)state, (Object)SchemeProcessor.State.NON_PERSISTENT)) continue;
                hasSchemes = true;
                if (Intrinsics.areEqual((Object)state, (Object)SchemeProcessor.State.UNCHANGED) ^ true) {
                    schemesToSave.add((Object)scheme);
                }
                if ((fileName = this.getFileName((ExternalizableScheme)scheme)) != null && !this.isRenamed(scheme)) {
                    nameGenerator.addExistingName(fileName);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
        for (Scheme scheme : schemesToSave) {
            try {
                Scheme scheme3 = scheme;
                Intrinsics.checkExpressionValueIsNotNull((Object)scheme3, (String)"scheme");
                this.saveScheme(scheme3, nameGenerator);
            }
            catch (Throwable e) {
                errors.add(new RuntimeException("Cannot save scheme " + this.fileSpec + "/" + scheme, e));
            }
        }
        if (!this.filesToDelete.isEmpty()) {
            this.deleteFiles(errors);
            if (!(hasSchemes || this.provider != null && this.provider.getEnabled())) {
                this.removeDirectoryIfEmpty(errors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDirectoryIfEmpty(List<Throwable> errors) {
        VirtualFile dir;
        boolean deleteUsingIo;
        Unit unit;
        File[] fileArray = this.ioDirectory.listFiles();
        if (fileArray != null) {
            File[] $receiver = fileArray;
            File[] it = $receiver;
            for (int i = 0; i < it.length; ++i) {
                File file = it[i];
                if (file.isHidden()) continue;
                ComponentStoreImplKt.getLOG().info("Directory " + this.ioDirectory.getName() + " is not deleted: at least one file " + file.getName() + " exists");
                return;
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        ComponentStoreImplKt.getLOG().info("Remove schemes directory " + this.ioDirectory.getName());
        this.directory = null;
        boolean bl = deleteUsingIo = !this.useVfs;
        if (!deleteUsingIo && (dir = this.getDirectory()) != null) {
            AccessToken token = WriteAction.start();
            try {
                dir.delete((Object)this);
            }
            catch (Throwable e) {
                deleteUsingIo = true;
                errors.add(e);
            }
            finally {
                token.finish();
            }
        }
        if (deleteUsingIo) {
            List<Throwable> $receiver = errors;
            try {
                FileUtil.delete((File)this.ioDirectory);
            }
            catch (Throwable e) {
                $receiver.add(e);
            }
        }
    }

    private final SchemeProcessor.State getState(E scheme) {
        return this.processor.getState((ExternalizableScheme)scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveScheme(E scheme, UniqueNameGenerator nameGenerator) {
        boolean renamed;
        String providerPath;
        Element element;
        Element element2;
        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme);
        String currentFileNameWithoutExtension = externalInfo == null ? (String)null : externalInfo.getFileNameWithoutExtension();
        Parent parent = this.processor.writeScheme((ExternalizableScheme)scheme);
        if (parent == null || parent instanceof Element) {
            element2 = (Element)parent;
        } else {
            Parent parent2 = parent;
            if (parent2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jdom.Document");
            }
            element2 = element = ((Document)parent2).detachRootElement();
        }
        if (JDOMUtil.isEmpty((Element)element)) {
            Unit unit;
            ExternalInfo externalInfo2 = externalInfo;
            if (externalInfo2 != null) {
                this.scheduleDelete(externalInfo2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return;
        }
        String fileNameWithoutExtension = currentFileNameWithoutExtension;
        if (fileNameWithoutExtension == null || this.isRenamed(scheme)) {
            fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeFileName((String)((ExternalizableScheme)scheme).getName(), (boolean)false));
        }
        Element element3 = element;
        if (element3 == null) {
            Intrinsics.throwNpe();
        }
        int newHash = JDOMUtil.getTreeHash((Element)element3, (boolean)true);
        if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.getHash()) {
            return;
        }
        Scheme bundledScheme = (Scheme)this.readOnlyExternalizableSchemes.get((Object)((ExternalizableScheme)scheme).getName());
        if (bundledScheme != null) {
            ExternalInfo externalInfo3 = (ExternalInfo)this.schemeToInfo.get((Object)bundledScheme);
            if (Intrinsics.areEqual((Object)(externalInfo3 != null ? Integer.valueOf(externalInfo3.getHash()) : null), (Object)newHash)) {
                Unit unit;
                ExternalInfo externalInfo4 = externalInfo;
                if (externalInfo4 != null) {
                    this.scheduleDelete(externalInfo4);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = fileNameWithoutExtension;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String fileName = stringBuilder.append(string).append(this.schemeExtension).toString();
        this.filesToDelete.remove((Object)fileName);
        BufferExposingByteArrayOutputStream byteOut = FileBasedStorageKt.toBufferExposingByteArray$default((Parent)element, null, 1);
        if (this.provider != null && this.provider.getEnabled()) {
            providerPath = this.fileSpec + '/' + fileName;
            if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                providerPath = null;
            }
        } else {
            providerPath = null;
        }
        boolean bl = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension);
        if (providerPath == null) {
            if (this.useVfs) {
                AccessToken token;
                void file;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                VirtualFile dir = this.getDirectory();
                if (dir == null || !dir.isValid()) {
                    this.directory = dir = SchemeManagerImplKt.createDir(this.ioDirectory, (Object)this);
                }
                if (renamed) {
                    ExternalInfo externalInfo5 = externalInfo;
                    if (externalInfo5 == null) {
                        Intrinsics.throwNpe();
                    }
                    file.element = dir.findChild(externalInfo5.getFileName());
                    if ((VirtualFile)file.element != null) {
                        token = WriteAction.start();
                        try {
                            VirtualFile virtualFile = (VirtualFile)file.element;
                            if (virtualFile == null) {
                                Intrinsics.throwNpe();
                            }
                            virtualFile.rename((Object)this, fileName);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            token.finish();
                        }
                    }
                }
                if ((VirtualFile)file.element == null) {
                    file.element = SchemeManagerImplKt.getFile(fileName, dir, (Object)this);
                }
                token = WriteAction.start();
                try {
                    void $receiver;
                    VirtualFile virtualFile = (VirtualFile)file.element;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    Closeable $i$a$1 = virtualFile.getOutputStream((Object)this);
                    boolean closed = false;
                    try {
                        OutputStream it = (OutputStream)$receiver;
                        byteOut.writeTo(it);
                        it = Unit.INSTANCE;
                    }
                    catch (Exception e) {
                        closed = true;
                        try {
                            $receiver.close();
                        }
                        catch (Exception closeException) {
                            // empty catch block
                        }
                        throw (Throwable)e;
                    }
                    finally {
                        if (!closed) {
                            $receiver.close();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    token.finish();
                }
                objectRef = null;
            } else {
                if (renamed) {
                    ExternalInfo externalInfo6 = externalInfo;
                    if (externalInfo6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.scheduleDelete(externalInfo6);
                }
                FileUtil.writeToFile((File)new File(this.ioDirectory, fileName), (byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size());
            }
        } else {
            if (renamed) {
                ExternalInfo externalInfo7 = externalInfo;
                if (externalInfo7 == null) {
                    Intrinsics.throwNpe();
                }
                this.scheduleDelete(externalInfo7);
            }
            StreamProvider streamProvider = this.provider;
            if (streamProvider == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = byteOut.getInternalBuffer();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteOut.internalBuffer");
            streamProvider.write(providerPath, byArray, byteOut.size(), this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeToInfo.put(scheme, (Object)externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setHash(newHash);
        externalInfo.setSchemeName(((ExternalizableScheme)scheme).getName());
    }

    private final void scheduleDelete(ExternalInfo $receiver) {
        this.filesToDelete.add((Object)$receiver.getFileName());
    }

    private final boolean isRenamed(E scheme) {
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(scheme);
        return info != null && Intrinsics.areEqual((Object)((ExternalizableScheme)scheme).getName(), (Object)info.getSchemeName()) ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void deleteFiles(List<Throwable> errors) {
        VirtualFile file;
        void $receiver;
        boolean deleteUsingIo;
        if (this.provider != null && this.provider.getEnabled()) {
            deleteUsingIo = false;
            for (String name : this.filesToDelete) {
                VirtualFile virtualFile = errors;
                try {
                    String spec = this.fileSpec + "/" + name;
                    if (!this.provider.isApplicable(spec, this.roamingType)) continue;
                    this.provider.delete(spec, this.roamingType);
                }
                catch (Throwable e) {
                    $receiver.add(e);
                }
            }
        } else if (!this.useVfs) {
            deleteUsingIo = true;
        } else {
            VirtualFile dir = this.getDirectory();
            boolean bl = deleteUsingIo = dir == null;
            if (!deleteUsingIo) {
                AccessToken token = null;
                try {
                    VirtualFile virtualFile = dir;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile[] $i$a$1 = virtualFile.getChildren();
                    for (int spec = 0; spec < $i$a$1.length; ++spec) {
                        file = $i$a$1[spec];
                        if (!this.filesToDelete.contains((Object)file.getName())) continue;
                        if (token == null) {
                            token = WriteAction.start();
                        }
                        VirtualFile e = errors;
                        try {
                            file.delete((Object)this);
                            continue;
                        }
                        catch (Throwable e2) {
                            void $receiver2;
                            $receiver2.add(e2);
                        }
                    }
                }
                finally {
                    if (token != null) {
                        token.finish();
                    }
                }
            }
        }
        if (deleteUsingIo) {
            for (String name : this.filesToDelete) {
                file = errors;
                try {
                    FileUtil.delete((File)new File(this.ioDirectory, name));
                }
                catch (Throwable e) {
                    $receiver.add(e);
                }
            }
        }
        this.filesToDelete.clear();
    }

    private final VirtualFile getDirectory() {
        VirtualFile result2 = this.directory;
        if (result2 == null) {
            this.directory = result2 = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        }
        return result2;
    }

    @NotNull
    public File getRootDirectory() {
        return this.ioDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
        Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
        T oldCurrentScheme = this.currentScheme;
        if (removeCondition == null) {
            this.schemes.clear();
        } else {
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)this.schemes)));
            int n = ((Number)intProgression.getStart()).intValue();
            int n2 = ((Number)intProgression.getEnd()).intValue();
            int n3 = ((Number)intProgression.getIncrement()).intValue();
            int n4 = ProgressionUtilKt.getProgressionFinalElement((int)n, (int)n2, (int)n3);
            int n5 = n;
            int n6 = n2;
            if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void i;
                    if (removeCondition.value(this.schemes.get((int)i))) {
                        this.schemes.remove((int)i);
                    }
                    if (i == n4) break;
                    i += n3;
                }
            }
        }
        this.retainExternalInfo(newSchemes);
        this.schemes.addAll((Collection)newSchemes);
        if (Intrinsics.areEqual(oldCurrentScheme, newCurrentScheme) ^ true) {
            if (newCurrentScheme != null) {
                this.currentScheme = newCurrentScheme;
            } else if (oldCurrentScheme != null && !this.schemes.contains(oldCurrentScheme)) {
                this.currentScheme = (Scheme)CollectionsKt.firstOrNull((List)this.schemes);
            }
            if (Intrinsics.areEqual(oldCurrentScheme, this.currentScheme) ^ true) {
                this.processor.onCurrentSchemeChanged(oldCurrentScheme);
            }
        }
    }

    private final void retainExternalInfo(List<? extends T> newSchemes) {
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        this.schemeToInfo.retainEntries(new TObjectObjectProcedure<E, ExternalInfo>(this, newSchemes){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ List $newSchemes;

            public boolean execute(@NotNull E scheme, @NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                if (Intrinsics.areEqual((Object)((Scheme)SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$p(this.this$0).get((Object)((ExternalizableScheme)scheme).getName())), scheme)) {
                    return true;
                }
                for (Scheme t : this.$newSchemes) {
                    if (t != scheme) continue;
                    if (CollectionsKt.isNotEmpty((Collection)((Collection)SchemeManagerImpl.access$getFilesToDelete$p(this.this$0)))) {
                        SchemeManagerImpl.access$getFilesToDelete$p(this.this$0).remove((Object)String.valueOf(info.getFileName()));
                    }
                    return true;
                }
                SchemeManagerImpl.access$scheduleDelete(this.this$0, info);
                return false;
            }
            {
                this.this$0 = $outer;
                this.$newSchemes = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void addNewScheme(@NotNull T scheme, boolean replaceExisting) {
        Scheme scheme2;
        THashMap<E, ExternalInfo> tHashMap;
        Scheme existing;
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        int toReplace = -1;
        IntRange intRange = CollectionsKt.getIndices((Collection)this.schemes);
        int n = ((Number)intRange.getStart()).intValue();
        int n2 = ((Number)intRange.getEnd()).intValue();
        if (n <= n2) {
            while (true) {
                void i;
                if (Intrinsics.areEqual((Object)(existing = (Scheme)this.schemes.get((int)i)).getName(), (Object)scheme.getName())) {
                    ExternalizableScheme $receiver;
                    if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                        ComponentStoreImplKt.getLOG().warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
                    }
                    toReplace = i;
                    if (!replaceExisting || !(existing instanceof ExternalizableScheme)) break;
                    ExternalizableScheme externalizableScheme = (ExternalizableScheme)existing;
                    SchemeManagerImpl schemeManagerImpl = this;
                    tHashMap = this.schemeToInfo;
                    void v1 = $receiver;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    scheme2 = (Scheme)v1;
                    ExternalInfo oldInfo = (ExternalInfo)tHashMap.remove((Object)scheme2);
                    if (oldInfo == null || !(scheme instanceof ExternalizableScheme)) break;
                    $receiver = (ExternalizableScheme)scheme;
                    schemeManagerImpl = this;
                    tHashMap = this.schemeToInfo;
                    ExternalizableScheme externalizableScheme2 = $receiver;
                    if (externalizableScheme2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    scheme2 = (Scheme)externalizableScheme2;
                    if (tHashMap.containsKey((Object)scheme2)) break;
                    $receiver = (ExternalizableScheme)scheme;
                    schemeManagerImpl = this;
                    tHashMap = this.schemeToInfo;
                    ExternalizableScheme externalizableScheme3 = $receiver;
                    if (externalizableScheme3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type E");
                    }
                    scheme2 = (Scheme)externalizableScheme3;
                    tHashMap.put((Object)scheme2, (Object)oldInfo);
                    break;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (toReplace == -1) {
            this.schemes.add(scheme);
        } else if (replaceExisting || !(scheme instanceof ExternalizableScheme)) {
            this.schemes.set(toReplace, scheme);
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            String string = UniqueNameGenerator.generateUniqueName((String)((ExternalizableScheme)scheme).getName(), this.collectExistingNames((Collection)this.schemes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026ctExistingNames(schemes))");
            SchemeManagerImplKt.access$renameScheme(externalizableScheme, string);
            this.schemes.add(scheme);
        }
        if (scheme instanceof ExternalizableScheme && CollectionsKt.isNotEmpty((Collection)((Collection)this.filesToDelete))) {
            void $receiver;
            existing = (ExternalizableScheme)scheme;
            SchemeManagerImpl schemeManagerImpl = this;
            tHashMap = this.schemeToInfo;
            void v6 = $receiver;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            scheme2 = (Scheme)v6;
            ExternalInfo info = (ExternalInfo)tHashMap.get((Object)scheme2);
            if (info != null) {
                this.filesToDelete.remove((Object)info.getFileName());
            }
        }
        this.processPendingCurrentSchemeName(scheme);
    }

    private final Collection<String> collectExistingNames(Collection<? extends T> schemes) {
        THashSet result2 = new THashSet(schemes.size());
        for (Scheme scheme : schemes) {
            result2.add((Object)scheme.getName());
        }
        return (Collection)result2;
    }

    public void clearAllSchemes() {
        this.schemeToInfo.forEachValue((TObjectProcedure)new TObjectProcedure<ExternalInfo>(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            public boolean execute(@NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                SchemeManagerImpl.access$scheduleDelete(this.this$0, info);
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.currentScheme = null;
        this.schemes.clear();
        this.schemeToInfo.clear();
    }

    public List<T> getAllSchemes() {
        return Collections.unmodifiableList((List)this.schemes);
    }

    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
        for (Scheme scheme : this.schemes) {
            if (!Intrinsics.areEqual((Object)scheme.getName(), (Object)schemeName)) continue;
            return (T)scheme;
        }
        return (T)((Scheme)null);
    }

    public void setCurrent(@Nullable T scheme, boolean notify) {
        this.currentPendingSchemeName = null;
        T oldCurrent = this.currentScheme;
        this.currentScheme = scheme;
        if (notify && Intrinsics.areEqual(oldCurrent, scheme) ^ true) {
            this.processor.onCurrentSchemeChanged(oldCurrent);
        }
    }

    public void setCurrentSchemeName(@Nullable String schemeName, boolean notify) {
        Object scheme;
        this.currentPendingSchemeName = schemeName;
        Object object = scheme = schemeName == null ? (Scheme)null : this.findSchemeByName(schemeName);
        if (scheme != null || schemeName == null) {
            this.setCurrent(scheme, notify);
        }
    }

    @Nullable
    public T getCurrentScheme() {
        return this.currentScheme;
    }

    @Nullable
    public String getCurrentSchemeName() {
        Object object = this.currentScheme;
        if (object == null || (object = object.getName()) == null) {
            object = this.currentPendingSchemeName;
        }
        return object;
    }

    private final void processPendingCurrentSchemeName(T newScheme) {
        if (Intrinsics.areEqual((Object)newScheme.getName(), (Object)this.currentPendingSchemeName)) {
            this.setCurrent(newScheme, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeScheme(@NotNull T scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        IntProgression intProgression = RangesKt.downTo((int)(this.schemes.size() - 1), (int)0);
        int n = ((Number)intProgression.getStart()).intValue();
        int n2 = ((Number)intProgression.getEnd()).intValue();
        int n3 = ((Number)intProgression.getIncrement()).intValue();
        int n4 = ProgressionUtilKt.getProgressionFinalElement((int)n, (int)n2, (int)n3);
        int n5 = n;
        int n6 = n2;
        if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                Scheme s = (Scheme)this.schemes.get((int)i);
                if (Intrinsics.areEqual((Object)scheme.getName(), (Object)s.getName())) {
                    if (Intrinsics.areEqual(this.currentScheme, (Object)s)) {
                        this.currentScheme = null;
                    }
                    if (s instanceof ExternalizableScheme) {
                        Unit unit;
                        void $receiver;
                        ExternalizableScheme externalizableScheme = (ExternalizableScheme)s;
                        SchemeManagerImpl schemeManagerImpl = this;
                        THashMap<E, ExternalInfo> tHashMap = this.schemeToInfo;
                        void v3 = $receiver;
                        if (v3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type E");
                        }
                        Scheme scheme2 = (Scheme)v3;
                        ExternalInfo externalInfo = (ExternalInfo)tHashMap.remove((Object)scheme2);
                        if (externalInfo != null) {
                            this.scheduleDelete(externalInfo);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                    this.schemes.remove((int)i);
                    break;
                }
                if (i == n4) break;
                n = i + n3;
            }
        }
    }

    private final E asExternalizable(ExternalizableScheme $receiver) {
        ExternalizableScheme externalizableScheme = $receiver;
        if (externalizableScheme == null) {
            throw new TypeCastException("null cannot be cast to non-null type E");
        }
        return (E)((Scheme)externalizableScheme);
    }

    @NotNull
    public Collection<String> getAllSchemeNames() {
        if (this.schemes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(this.schemes.size());
        for (Scheme scheme : this.schemes) {
            names.add(scheme.getName());
        }
        return names;
    }

    public boolean isMetadataEditable(@NotNull E scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        return !this.readOnlyExternalizableSchemes.containsKey((Object)((ExternalizableScheme)scheme).getName());
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    public SchemeManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor2, @Nullable StreamProvider provider, @NotNull File ioDirectory, @NotNull RoamingType roamingType, @Nullable Disposable virtualFileTrackerDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)ioDirectory, (String)"ioDirectory");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        this.fileSpec = fileSpec;
        this.processor = processor2;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.roamingType = roamingType;
        this.schemes = new ArrayList();
        this.readOnlyExternalizableSchemes = new THashMap();
        this.filesToDelete = new THashSet();
        this.schemeToInfo = new THashMap(ContainerUtil.identityStrategy());
        boolean bl = this.useVfs = virtualFileTrackerDisposable != null;
        if (this.processor instanceof SchemeExtensionProvider) {
            String string = ((SchemeExtensionProvider)this.processor).getSchemeExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processor.schemeExtension");
            this.schemeExtension = string;
            this.updateExtension = ((SchemeExtensionProvider)this.processor).isUpgradeNeeded();
        } else {
            this.schemeExtension = ".xml";
            this.updateExtension = false;
        }
        if (this.useVfs && (this.provider == null || !this.provider.getEnabled())) {
            try {
                this.refreshVirtualDirectoryAndAddListener(virtualFileTrackerDisposable);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error(e);
            }
        }
    }

    public /* synthetic */ SchemeManagerImpl(String string, SchemeProcessor schemeProcessor, StreamProvider streamProvider, File file, RoamingType roamingType, Disposable disposable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            disposable = null;
        }
        this(string, schemeProcessor, streamProvider, file, roamingType, disposable);
    }

    @NotNull
    public static final /* synthetic */ ArrayList<T> access$getSchemes$p(SchemeManagerImpl<T, E> $this) {
        return $this.schemes;
    }

    @NotNull
    public static final /* synthetic */ THashMap<String, E> access$getReadOnlyExternalizableSchemes$p(SchemeManagerImpl<T, E> $this) {
        return $this.readOnlyExternalizableSchemes;
    }

    @Nullable
    public static final /* synthetic */ T access$getCurrentScheme$p(SchemeManagerImpl<T, E> $this) {
        return $this.currentScheme;
    }

    public static final /* synthetic */ void access$setCurrentScheme$p(SchemeManagerImpl<T, E> $this, @Nullable T t) {
        $this.currentScheme = t;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory$p(SchemeManagerImpl<T, E> $this) {
        return $this.directory;
    }

    public static final /* synthetic */ void access$setDirectory$p(SchemeManagerImpl<T, E> $this, @Nullable VirtualFile virtualFile) {
        $this.directory = virtualFile;
    }

    @NotNull
    public static final /* synthetic */ THashSet<String> access$getFilesToDelete$p(SchemeManagerImpl<T, E> $this) {
        return $this.filesToDelete;
    }

    public static final /* synthetic */ void access$addVfsListener(SchemeManagerImpl<T, E> $this, @Nullable Disposable virtualFileTrackerDisposable) {
        super.addVfsListener(virtualFileTrackerDisposable);
    }

    public static final /* synthetic */ boolean access$isMy(SchemeManagerImpl<T, E> $this, @NotNull VirtualFileEvent event) {
        return super.isMy(event);
    }

    @Nullable
    public static final /* synthetic */ E access$findExternalizableSchemeByFileName(SchemeManagerImpl<T, E> $this, @NotNull String fileName) {
        return super.findExternalizableSchemeByFileName(fileName);
    }

    @NotNull
    public static final /* synthetic */ SchemeProcessor<E> access$getProcessor$p(SchemeManagerImpl<T, E> $this) {
        return $this.processor;
    }

    @Nullable
    public static final /* synthetic */ E access$readSchemeFromFile(SchemeManagerImpl<T, E> $this, @NotNull VirtualFile file, boolean duringLoad) {
        return super.readSchemeFromFile(file, duringLoad);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory(SchemeManagerImpl<T, E> $this) {
        return super.getDirectory();
    }

    public static final /* synthetic */ boolean access$isMy(SchemeManagerImpl<T, E> $this, @NotNull VirtualFile file) {
        return super.isMy(file);
    }

    public static final /* synthetic */ void access$removeExternalizableSchemes(SchemeManagerImpl<T, E> $this) {
        super.removeExternalizableSchemes();
    }

    public static final /* synthetic */ boolean access$canRead(SchemeManagerImpl<T, E> $this, @NotNull CharSequence name) {
        return super.canRead(name);
    }

    public static final /* synthetic */ void access$scheduleDelete(SchemeManagerImpl<T, E> $this, ExternalInfo $receiver) {
        super.scheduleDelete($receiver);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA1B\u0003\u0002\u0011\u0011)\u0011\u0001b\u0002\u0006\u0003!\tQ!\u0001C\u0002\t\u0005a\u0001!G\u0001\u0019\u0002\u0005^\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!\u0003\u0003\t\u00055\u0011A\u0012\u0001M\u0002#\u000e\t\u0001RA\u0013\f\u0011\u001bi\u0011\u0001g\u0006\u001a\u0007!aQ\"\u0001M\u00023\rAI\"D\u0001\u0019\u0004\u0015\"Aa\u0003\u0005\u000e\u001b\u0005A\u001a!\u000b\b\u0005\u0007rA!!\u0004\u0002\r\u0002a\r\u0011kA\u0004\u0006\u00015\u0011Aa\u0001E\u0004#\t!A\u0001#\u0003*\u0015\u0011\u0019\u0005\u0002C\u0003\u000e\u0003a\rAdI)\u0004\u00075\u0011A1\u0002E\u0004S5!1\t\b\u0005\u0002\u001b\u0005A\u001a!U\u0002\b\u000b\u0001i!\u0001\u0002\u0004\t\bE\u0011AQ\u0002E\u0005S5!1\t\b\u0005\b\u001b\u0005Az!U\u0002\b\u000b\u0001i!\u0001\u0002\u0005\t\u0012E\u0011A!\u0003E\nS9!1\t\b\u0005\u000b\u001b\ta\t\u0001g\u0001R\u0007\u001d)\u0001!\u0004\u0002\u0005\u0016!\u001d\u0011C\u0001\u0003\f\u0011\u0013\u0001"}, strings={"Lcom/intellij/configurationStore/SchemeManagerImpl$ExternalInfo;", "", "fileNameWithoutExtension", "", "fileExtension", "(Ljava/lang/String;Ljava/lang/String;)V", "getFileExtension", "()Ljava/lang/String;", "setFileExtension", "(Ljava/lang/String;)V", "fileName", "getFileName", "getFileNameWithoutExtension", "setFileNameWithoutExtension", "hash", "", "getHash", "()I", "setHash", "(I)V", "schemeName", "getSchemeName", "setSchemeName", "", "nameWithoutExtension", "extension", "toString"}, moduleName="configuration-store-impl")
    private static final class ExternalInfo {
        @Nullable
        private String schemeName;
        private int hash;
        @NotNull
        private String fileNameWithoutExtension;
        @Nullable
        private String fileExtension;

        @Nullable
        public final String getSchemeName() {
            return this.schemeName;
        }

        public final void setSchemeName(@Nullable String string) {
            this.schemeName = string;
        }

        public final int getHash() {
            return this.hash;
        }

        public final void setHash(int n) {
            this.hash = n;
        }

        @NotNull
        public final String getFileName() {
            return this.fileNameWithoutExtension + this.fileExtension;
        }

        public final void setFileNameWithoutExtension(@NotNull String nameWithoutExtension, @NotNull String extension) {
            Intrinsics.checkParameterIsNotNull((Object)nameWithoutExtension, (String)"nameWithoutExtension");
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            this.fileNameWithoutExtension = nameWithoutExtension;
            this.fileExtension = extension;
        }

        @NotNull
        public String toString() {
            return this.getFileName();
        }

        @NotNull
        public final String getFileNameWithoutExtension() {
            return this.fileNameWithoutExtension;
        }

        public final void setFileNameWithoutExtension(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.fileNameWithoutExtension = string;
        }

        @Nullable
        public final String getFileExtension() {
            return this.fileExtension;
        }

        public final void setFileExtension(@Nullable String string) {
            this.fileExtension = string;
        }

        public ExternalInfo(@NotNull String fileNameWithoutExtension, @Nullable String fileExtension) {
            Intrinsics.checkParameterIsNotNull((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
            this.fileNameWithoutExtension = fileNameWithoutExtension;
            this.fileExtension = fileExtension;
        }
    }
}

