/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreJavaFileManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CoreJavaDirectoryService
extends JavaDirectoryService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.core.CoreJavaDirectoryService");

    public PsiPackage getPackage(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "getPackage"));
        }
        return ((CoreJavaFileManager)ServiceManager.getService((Project)dir.getProject(), CoreJavaFileManager.class)).getPackage(dir);
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "getClasses"));
        }
        LOG.assertTrue(dir.isValid());
        PsiClass[] psiClassArray = CoreJavaDirectoryService.getPsiClasses(dir, dir.getFiles());
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaDirectoryService", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public static PsiClass[] getPsiClasses(@NotNull PsiDirectory dir, PsiFile[] psiFiles) {
        VirtualFile virtualDir;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "getPsiClasses"));
        }
        FileIndexFacade index = FileIndexFacade.getInstance((Project)dir.getProject());
        boolean onlyCompiled = index.isInLibraryClasses(virtualDir = dir.getVirtualFile()) && !index.isInSourceContent(virtualDir);
        ArrayList classes = null;
        for (PsiFile file : psiFiles) {
            Object[] psiClasses;
            if (onlyCompiled && !(file instanceof ClsFileImpl) || !(file instanceof PsiClassOwner) || file.getViewProvider().getLanguages().size() != 1 || (psiClasses = ((PsiClassOwner)file).getClasses()).length == 0) continue;
            if (classes == null) {
                classes = new ArrayList();
            }
            ContainerUtil.addAll((Collection)classes, (Object[])psiClasses);
        }
        PsiClass[] psiClassArray = classes == null ? PsiClass.EMPTY_ARRAY : classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreJavaDirectoryService", "getPsiClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    public PsiClass createClass(@NotNull PsiDirectory dir, @NotNull String name, @NotNull String templateName, boolean askForUndefinedVariables, @NotNull Map<String, String> additionalProperties) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        if (additionalProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProperties", "com/intellij/core/CoreJavaDirectoryService", "createClass"));
        }
        throw new UnsupportedOperationException();
    }

    public void checkCreateClass(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "checkCreateClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "checkCreateClass"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createInterface(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "createInterface"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "createInterface"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createEnum(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "createEnum"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "createEnum"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiClass createAnnotationType(@NotNull PsiDirectory dir, @NotNull String name) throws IncorrectOperationException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "createAnnotationType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/core/CoreJavaDirectoryService", "createAnnotationType"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSourceRoot(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "isSourceRoot"));
        }
        return false;
    }

    public LanguageLevel getLanguageLevel(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/core/CoreJavaDirectoryService", "getLanguageLevel"));
        }
        return LanguageLevel.HIGHEST;
    }
}

