/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodExitRequest;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

public class MethodReturnValueWatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.requests.MethodReturnValueWatcher");
    @Nullable
    private Method myLastExecutedMethod;
    @Nullable
    private Value myLastMethodReturnValue;
    @Nullable
    private MethodExitRequest myRequest;
    private java.lang.reflect.Method myReturnValueMethod;
    private volatile boolean myEnabled;
    private boolean myFeatureEnabled;
    private final EventRequestManager myRequestManager;

    public MethodReturnValueWatcher(EventRequestManager requestManager) {
        this.myRequestManager = requestManager;
        this.myFeatureEnabled = DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
    }

    public boolean processMethodExitEvent(MethodExitEvent event) {
        if (event.request() != this.myRequest) {
            return false;
        }
        try {
            Method method = event.method();
            try {
                if (this.myReturnValueMethod == null) {
                    this.myReturnValueMethod = MethodExitEvent.class.getDeclaredMethod("returnValue", ArrayUtil.EMPTY_CLASS_ARRAY);
                }
                Value retVal = (Value)this.myReturnValueMethod.invoke((Object)event, new Object[0]);
                if (method == null || !"void".equals(method.returnTypeName())) {
                    this.myLastExecutedMethod = method;
                    this.myLastMethodReturnValue = retVal;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        catch (UnsupportedOperationException ex) {
            LOG.error((Throwable)ex);
        }
        return true;
    }

    @Nullable
    public Method getLastExecutedMethod() {
        return this.myLastExecutedMethod;
    }

    @Nullable
    public Value getLastMethodReturnValue() {
        return this.myLastMethodReturnValue;
    }

    public boolean isFeatureEnabled() {
        return this.myFeatureEnabled;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setFeatureEnabled(boolean featureEnabled) {
        this.myFeatureEnabled = featureEnabled;
        this.myLastExecutedMethod = null;
        this.myLastMethodReturnValue = null;
    }

    public void enable(ThreadReference thread) {
        this.setTrackingEnabled(true, thread);
    }

    public void disable() {
        this.setTrackingEnabled(false, null);
    }

    private void setTrackingEnabled(boolean trackingEnabled, ThreadReference thread) {
        this.myEnabled = trackingEnabled;
        this.updateRequestState(trackingEnabled && this.myFeatureEnabled, thread);
    }

    private void updateRequestState(boolean enabled, @Nullable ThreadReference thread) {
        try {
            MethodExitRequest request = this.myRequest;
            if (request != null) {
                this.myRequest = null;
                this.myRequestManager.deleteEventRequest(request);
            }
            if (enabled) {
                this.myLastExecutedMethod = null;
                this.myLastMethodReturnValue = null;
                this.myRequest = this.createRequest(thread);
                this.myRequest.enable();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    private MethodExitRequest createRequest(@Nullable ThreadReference thread) {
        MethodExitRequest request = this.myRequestManager.createMethodExitRequest();
        request.setSuspendPolicy(0);
        if (thread != null) {
            request.addThreadFilter(thread);
        }
        return request;
    }
}

