/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.errordialog;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DisablePluginWarningDialog
extends DialogWrapper {
    private JLabel myPromptLabel;
    private JLabel myRestartLabel;
    private JPanel myContentPane;
    public static final int DISABLE_EXIT_CODE = 0;
    public static final int DISABLE_AND_RESTART_EXIT_CODE = 2;
    private final boolean myRestartCapable;

    public DisablePluginWarningDialog(Component c, String pluginName, boolean hasDependants, boolean restartCapable) {
        super(c, false);
        this.myRestartCapable = restartCapable;
        this.$$$setupUI$$$();
        this.myPromptLabel.setText(DiagnosticBundle.message(hasDependants ? "error.dialog.disable.plugin.prompt.dependants" : "error.dialog.disable.plugin.prompt", pluginName));
        this.myRestartLabel.setText(DiagnosticBundle.message(restartCapable ? "error.dialog.disable.plugin.restart" : "error.dialog.disable.plugin.norestart", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.setTitle(DiagnosticBundle.message("error.dialog.disable.plugin.title", new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            if (this.myRestartCapable) {
                Action[] actionArray = new Action[]{this.getCancelAction(), new DisableAction(), new DisableAndRestartAction()};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/DisablePluginWarningDialog", "createActions"));
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{this.getCancelAction(), new DisableAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/DisablePluginWarningDialog", "createActions"));
            }
            return actionArray;
        }
        if (this.myRestartCapable) {
            Action[] actionArray = new Action[]{new DisableAction(), new DisableAndRestartAction(), this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/DisablePluginWarningDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{new DisableAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/errordialog/DisablePluginWarningDialog", "createActions"));
        }
        return actionArray;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPromptLabel = jLabel2 = new JLabel();
        jLabel2.setText("prompt");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRestartLabel = jLabel = new JLabel();
        jLabel.setText("restart");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 15), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class DisableAndRestartAction
    extends DialogWrapper.DialogWrapperAction {
        protected DisableAndRestartAction() {
            super((DialogWrapper)DisablePluginWarningDialog.this, DiagnosticBundle.message("error.dialog.disable.plugin.action.disableAndRestart", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DisablePluginWarningDialog.this.close(2);
        }
    }

    private class DisableAction
    extends DialogWrapper.DialogWrapperAction {
        protected DisableAction() {
            super((DialogWrapper)DisablePluginWarningDialog.this, DiagnosticBundle.message("error.dialog.disable.plugin.action.disable", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            DisablePluginWarningDialog.this.close(0);
        }
    }
}

