/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.openapi.util.text.LineTokenizer;
import java.util.Arrays;
import java.util.List;

public class Block {
    private final String[] mySource;
    private int myStart;
    private int myEnd;

    public Block(String source, int start, int end) {
        this(LineTokenizer.tokenize((char[])source.toCharArray(), (boolean)false), start, end);
    }

    public Block(String[] source, int start, int end) {
        this.mySource = source;
        this.myStart = start;
        this.myEnd = end;
    }

    public String getBlockContent() {
        StringBuffer result2 = new StringBuffer();
        int length = this.myEnd - this.myStart + 1;
        for (int i = 0; i < length && i + this.myStart < this.mySource.length; ++i) {
            result2.append(this.mySource[i + this.myStart]);
            if (i >= length - 1) continue;
            result2.append("\n");
        }
        return result2.toString();
    }

    public int hashCode() {
        return this.getSourceAsList().hashCode() ^ this.myStart ^ this.myEnd;
    }

    private List<String> getSourceAsList() {
        return Arrays.asList(this.mySource);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return this.getSourceAsList().equals(other.getSourceAsList()) && this.myStart == other.myStart && this.myEnd == other.myEnd;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setStart(int start) {
        this.myStart = start;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    public String[] getSource() {
        return this.mySource;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        this.appendLines(result2, 0, this.myStart);
        this.appendLineTo(result2, "<-----------------------------");
        this.appendLines(result2, this.myStart, this.myEnd + 1);
        this.appendLineTo(result2, "----------------------------->");
        this.appendLines(result2, this.myEnd + 1, this.mySource.length);
        return result2.toString();
    }

    private void appendLines(StringBuffer result2, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.appendLineTo(result2, this.mySource[i]);
        }
    }

    private void appendLineTo(StringBuffer result2, String line) {
        result2.append(line);
        result2.append("\n");
    }
}

