/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeRequestImpl
extends TextMergeRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myOutput;
    @NotNull
    private final List<DocumentContent> myContents;
    @NotNull
    private final CharSequence myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;
    @Nullable
    private final Consumer<MergeResult> myApplyCallback;

    public TextMergeRequestImpl(@Nullable Project project, @NotNull DocumentContent output, @NotNull CharSequence originalContent, @NotNull List<DocumentContent> contents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/diff/requests/TextMergeRequestImpl", "<init>"));
        }
        if (originalContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalContent", "com/intellij/diff/requests/TextMergeRequestImpl", "<init>"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/requests/TextMergeRequestImpl", "<init>"));
        }
        if (contentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/requests/TextMergeRequestImpl", "<init>"));
        }
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myOutput = output;
        this.myOriginalContent = originalContent;
        this.myContents = contents;
        this.myTitles = contentTitles;
        this.myTitle = title;
        this.myApplyCallback = applyCallback;
    }

    @NotNull
    public DocumentContent getOutputContent() {
        DocumentContent documentContent = this.myOutput;
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/TextMergeRequestImpl", "getOutputContent"));
        }
        return documentContent;
    }

    @NotNull
    public List<DocumentContent> getContents() {
        List<DocumentContent> list = this.myContents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/TextMergeRequestImpl", "getContents"));
        }
        return list;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        List<String> list = this.myTitles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/TextMergeRequestImpl", "getContentTitles"));
        }
        return list;
    }

    public void applyResult(@NotNull MergeResult result2) {
        CharSequence applyContent;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/requests/TextMergeRequestImpl", "applyResult"));
        }
        switch (result2) {
            case CANCEL: {
                applyContent = this.myOriginalContent;
                break;
            }
            case LEFT: {
                CharSequence leftContent = ((DocumentContent)ThreeSide.LEFT.select(this.getContents())).getDocument().getImmutableCharSequence();
                applyContent = StringUtil.convertLineSeparators((String)leftContent.toString());
                break;
            }
            case RIGHT: {
                CharSequence rightContent = ((DocumentContent)ThreeSide.RIGHT.select(this.getContents())).getDocument().getImmutableCharSequence();
                applyContent = StringUtil.convertLineSeparators((String)rightContent.toString());
                break;
            }
            case RESOLVED: {
                applyContent = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(result2.toString());
            }
        }
        if (applyContent != null) {
            DiffUtil.executeWriteCommand(this.myOutput.getDocument(), this.myProject, null, new Runnable(){

                @Override
                public void run() {
                    TextMergeRequestImpl.this.myOutput.getDocument().setText(applyContent);
                }
            });
        }
        if (this.myApplyCallback != null) {
            this.myApplyCallback.consume((Object)result2);
        }
    }
}

