/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class CopyPathsAction
extends AnAction
implements DumbAware {
    public CopyPathsAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files != null && files.length > 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyPathsAction.getPaths(files)));
        }
    }

    private static String getPaths(VirtualFile[] files) {
        StringBuilder buf = new StringBuilder(files.length * 64);
        for (VirtualFile file : files) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(file.getPresentableUrl());
        }
        return buf.toString();
    }

    public void update(AnActionEvent event) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(event.getDataContext());
        int num = files != null ? files.length : 0;
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(num > 0);
        presentation.setVisible(num > 0 || !ActionPlaces.isPopupPlace((String)event.getPlace()));
        presentation.setText(IdeBundle.message((String)(num == 1 ? "action.copy.path" : "action.copy.paths"), (Object[])new Object[0]));
    }
}

