/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDesktopEntryAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.CreateDesktopEntryAction");

    public static boolean isAvailable() {
        return SystemInfo.isUnix && SystemInfo.hasXdgOpen();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/CreateDesktopEntryAction", "update"));
        }
        boolean enabled = CreateDesktopEntryAction.isAvailable();
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/CreateDesktopEntryAction", "actionPerformed"));
        }
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        Project project = event.getProject();
        CreateDesktopEntryDialog dialog = new CreateDesktopEntryDialog(project);
        if (!dialog.showAndGet()) {
            return;
        }
        final boolean globalEntry = dialog.myGlobalEntryCheckBox.isSelected();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, ApplicationBundle.message((String)"desktop.entry.title", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateDesktopEntryAction$1", "run"));
                }
                CreateDesktopEntryAction.createDesktopEntry(this.getProject(), indicator, globalEntry);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createDesktopEntry(@Nullable Project project, @NotNull ProgressIndicator indicator, boolean globalEntry) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/CreateDesktopEntryAction", "createDesktopEntry"));
        }
        if (!CreateDesktopEntryAction.isAvailable()) {
            return;
        }
        double step = (1.0 - indicator.getFraction()) / 3.0;
        File entry = null;
        try {
            indicator.setText(ApplicationBundle.message((String)"desktop.entry.checking", (Object[])new Object[0]));
            CreateDesktopEntryAction.check();
            indicator.setFraction(indicator.getFraction() + step);
            indicator.setText(ApplicationBundle.message((String)"desktop.entry.preparing", (Object[])new Object[0]));
            entry = CreateDesktopEntryAction.prepare();
            indicator.setFraction(indicator.getFraction() + step);
            indicator.setText(ApplicationBundle.message((String)"desktop.entry.installing", (Object[])new Object[0]));
            CreateDesktopEntryAction.install(entry, globalEntry);
            indicator.setFraction(indicator.getFraction() + step);
            if (ApplicationManager.getApplication() != null) {
                String message = ApplicationBundle.message((String)"desktop.entry.success", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Desktop entry created", message, NotificationType.INFORMATION), (Project)project);
            }
            if (entry == null) return;
        }
        catch (Exception e) {
            try {
                if (ApplicationManager.getApplication() == null) {
                    throw new RuntimeException(e);
                }
                LOG.warn((Throwable)e);
                String message = e.getMessage();
                if (StringUtil.isEmptyOrSpaces((String)message)) {
                    message = "Internal error";
                }
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Failed to create desktop entry", message, NotificationType.ERROR), (Project)project);
                if (entry == null) return;
            }
            catch (Throwable throwable) {
                if (entry == null) throw throwable;
                FileUtil.delete(entry);
                throw throwable;
            }
            FileUtil.delete((File)entry);
            return;
        }
        FileUtil.delete((File)entry);
        return;
    }

    private static void check() throws ExecutionException, InterruptedException {
        int result2 = new GeneralCommandLine(new String[]{"which", "xdg-desktop-menu"}).createProcess().waitFor();
        if (result2 != 0) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.xdg.missing", (Object[])new Object[0]));
        }
    }

    private static File prepare() throws IOException {
        String iconPath;
        String homePath = PathManager.getHomePath();
        assert (new File(homePath).isDirectory()) : "Invalid home path: '" + homePath + "'";
        String binPath = homePath + "/bin";
        assert (new File(binPath).isDirectory()) : "Invalid bin path: '" + binPath + "'";
        String name = ApplicationNamesInfo.getInstance().getFullProductName();
        if (PlatformUtils.isIdeaCommunity()) {
            name = name + " Community Edition";
        }
        if ((iconPath = AppUIUtil.findIcon(binPath)) == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.icon.missing", (Object[])new Object[]{binPath}));
        }
        String execPath = CreateDesktopEntryAction.findScript(binPath);
        if (execPath == null) {
            throw new RuntimeException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{binPath}));
        }
        String wmClass = AppUIUtil.getFrameClass();
        Map vars = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"$NAME$", (Object)name), (Pair[])new Pair[]{Pair.pair((Object)"$SCRIPT$", (Object)execPath), Pair.pair((Object)"$ICON$", (Object)iconPath), Pair.pair((Object)"$WM_CLASS$", (Object)wmClass)});
        String content = ExecUtil.loadTemplate((ClassLoader)CreateDesktopEntryAction.class.getClassLoader(), (String)"entry.desktop", (Map)vars);
        File entryFile = new File(FileUtil.getTempDirectory(), wmClass + ".desktop");
        FileUtil.writeToFile((File)entryFile, (String)content);
        return entryFile;
    }

    @Nullable
    private static String findScript(String binPath) {
        ApplicationNamesInfo names = ApplicationNamesInfo.getInstance();
        String execPath = binPath + '/' + names.getProductName() + ".sh";
        if (new File(execPath).canExecute()) {
            return execPath;
        }
        execPath = binPath + '/' + names.getProductName().toLowerCase(Locale.US) + ".sh";
        if (new File(execPath).canExecute()) {
            return execPath;
        }
        execPath = binPath + '/' + names.getScriptName() + ".sh";
        if (new File(execPath).canExecute()) {
            return execPath;
        }
        return null;
    }

    private static void install(File entryFile, boolean globalEntry) throws IOException, ExecutionException {
        if (globalEntry) {
            String prompt = ApplicationBundle.message((String)"desktop.entry.sudo.prompt", (Object[])new Object[0]);
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "install", "--mode", "system", entryFile.getAbsolutePath()}), prompt);
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "forceupdate", "--mode", "system"}), prompt);
        } else {
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "install", "--mode", "user", entryFile.getAbsolutePath()}), null);
            CreateDesktopEntryAction.exec(new GeneralCommandLine(new String[]{"xdg-desktop-menu", "forceupdate", "--mode", "user"}), null);
        }
    }

    private static void exec(GeneralCommandLine command, @Nullable String prompt) throws IOException, ExecutionException {
        command.setRedirectErrorStream(true);
        ProcessOutput result2 = prompt != null ? ExecUtil.sudoAndGetOutput((GeneralCommandLine)command, (String)prompt) : ExecUtil.execAndGetOutput((GeneralCommandLine)command);
        int exitCode = result2.getExitCode();
        if (exitCode != 0) {
            String message = "Command '" + (prompt != null ? "sudo " : "") + command.getCommandLineString() + "' returned " + exitCode;
            String output = result2.getStdout();
            if (!StringUtil.isEmptyOrSpaces((String)output)) {
                message = message + "\nOutput: " + output.trim();
            }
            throw new RuntimeException(message);
        }
    }

    public static class CreateDesktopEntryDialog
    extends DialogWrapper {
        private JPanel myContentPane;
        private JLabel myLabel;
        private JCheckBox myGlobalEntryCheckBox;

        public CreateDesktopEntryDialog(Project project) {
            super(project);
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(ApplicationBundle.message((String)"desktop.entry.title", (Object[])new Object[0]));
            this.myLabel.setText(this.myLabel.getText().replace("$APP_NAME$", ApplicationNamesInfo.getInstance().getProductName()));
        }

        protected JComponent createCenterPanel() {
            return this.myContentPane;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.myContentPane = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
            this.myGlobalEntryCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Create entry for all users");
            jCheckBox.setMnemonic('A');
            jCheckBox.setDisplayedMnemonicIndex(17);
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myLabel = jLabel = new JLabel();
            jLabel.setText("<html>You can create a desktop entry for easier starting $APP_NAME$ from a system menu<br>and better desktop integration.<html>");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myContentPane;
        }
    }
}

