/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoRelatedSymbolAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoRelatedSymbolAction", "update"));
        }
        PsiElement element = GotoRelatedSymbolAction.getContextElement(e.getDataContext());
        e.getPresentation().setEnabled(element != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoRelatedSymbolAction", "actionPerformed"));
        }
        PsiElement element = GotoRelatedSymbolAction.getContextElement(e.getDataContext());
        if (element == null) {
            return;
        }
        List<GotoRelatedItem> items = NavigationUtil.collectRelatedItems(element, e.getDataContext());
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1 && items.get(0).getElement() != null) {
            items.get(0).navigate();
            return;
        }
        NavigationUtil.getRelatedItemsPopup(items, "Choose Target").showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    public static List<GotoRelatedItem> getItems(@NotNull PsiFile psiFile, @Nullable Editor editor, @Nullable DataContext dataContext) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/actions/GotoRelatedSymbolAction", "getItems"));
        }
        List<GotoRelatedItem> list = NavigationUtil.collectRelatedItems(GotoRelatedSymbolAction.getContextElement(psiFile, editor), dataContext);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoRelatedSymbolAction", "getItems"));
        }
        return list;
    }

    @Nullable
    private static PsiElement getContextElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/GotoRelatedSymbolAction", "getContextElement"));
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (file != null && editor != null) {
            return GotoRelatedSymbolAction.getContextElement(file, editor);
        }
        return element == null ? file : element;
    }

    @NotNull
    private static PsiElement getContextElement(@NotNull PsiFile psiFile, @Nullable Editor editor) {
        PsiElement element;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/actions/GotoRelatedSymbolAction", "getContextElement"));
        }
        PsiFile contextElement = psiFile;
        if (editor != null && (element = psiFile.findElementAt(editor.getCaretModel().getOffset())) != null) {
            contextElement = element;
        }
        PsiFile psiFile2 = contextElement;
        if (psiFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoRelatedSymbolAction", "getContextElement"));
        }
        return psiFile2;
    }
}

