/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeLookAndFeel
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeLookAndFeel", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeLookAndFeel", "fillActions"));
        }
        final LafManager manager = LafManager.getInstance();
        UIManager.LookAndFeelInfo[] lfs = manager.getInstalledLookAndFeels();
        UIManager.LookAndFeelInfo current = manager.getCurrentLookAndFeel();
        for (final UIManager.LookAndFeelInfo lf : lfs) {
            group.add((AnAction)new DumbAwareAction(lf.getName(), "", lf == current ? ourCurrentAction : ourNotCurrentAction){

                public void actionPerformed(AnActionEvent e) {
                    UIManager.LookAndFeelInfo cur = manager.getCurrentLookAndFeel();
                    if (cur == lf) {
                        return;
                    }
                    boolean needUninstall = UIUtil.isUnderDarcula();
                    manager.setCurrentLookAndFeel(lf);
                    manager.updateUI();
                    if (UIUtil.isUnderDarcula()) {
                        DarculaInstaller.install();
                    } else if (needUninstall) {
                        DarculaInstaller.uninstall();
                    }
                }
            });
        }
    }

    protected boolean isEnabled() {
        return LafManager.getInstance().getInstalledLookAndFeels().length > 1;
    }
}

