/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import org.jetbrains.annotations.NotNull;

public final class BundledFileTemplate
extends FileTemplateBase {
    private final DefaultTemplate myDefaultTemplate;
    private final boolean myInternal;
    private boolean myEnabled;

    public BundledFileTemplate(@NotNull DefaultTemplate defaultTemplate, boolean internal) {
        if (defaultTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTemplate", "com/intellij/ide/fileTemplates/impl/BundledFileTemplate", "<init>"));
        }
        this.myEnabled = true;
        this.myDefaultTemplate = defaultTemplate;
        this.myInternal = internal;
        this.setLiveTemplateEnabled(defaultTemplate.getText().contains("#[[$"));
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myDefaultTemplate.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/BundledFileTemplate", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getExtension() {
        String string = this.myDefaultTemplate.getExtension();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/BundledFileTemplate", "getExtension"));
        }
        return string;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/BundledFileTemplate", "setName"));
        }
    }

    @Override
    public void setExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/ide/fileTemplates/impl/BundledFileTemplate", "setExtension"));
        }
    }

    @Override
    @NotNull
    protected String getDefaultText() {
        String string = this.myDefaultTemplate.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/BundledFileTemplate", "getDefaultText"));
        }
        return string;
    }

    @Override
    @NotNull
    public final String getDescription() {
        String string = this.myDefaultTemplate.getDescriptionText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/BundledFileTemplate", "getDescription"));
        }
        return string;
    }

    @Override
    public boolean isDefault() {
        return this.getText().equals(this.getDefaultText());
    }

    @Override
    public BundledFileTemplate clone() {
        return (BundledFileTemplate)super.clone();
    }

    public boolean isEnabled() {
        return this.myInternal || this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.myEnabled) {
            this.myEnabled = enabled;
            if (!enabled) {
                this.revertToDefaults();
            }
        }
    }

    public void revertToDefaults() {
        this.setText(null);
        this.setReformatCode(true);
        this.setLiveTemplateEnabled(false);
    }

    public boolean isTextModified() {
        return !this.getText().equals(this.getDefaultText());
    }

    public String toString() {
        return this.myDefaultTemplate.getTemplateURL() == null ? "" : this.myDefaultTemplate.getTemplateURL().toString();
    }
}

