/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.config;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterPasswordDialog;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class PasswordSafeOptionsPanel {
    private final PasswordSafeImpl myPasswordSafe;
    private JRadioButton myDoNotRememberPasswordsRadioButton;
    private JRadioButton myRememberPasswordsUntilClosingRadioButton;
    private JRadioButton mySaveOnDiskRadioButton;
    private JButton myManagePasswordButton;
    private JPanel myRoot;
    private JBLabel myMasterPasswordStateLabel;

    public PasswordSafeOptionsPanel(PasswordSafe passwordSafe) {
        this.myPasswordSafe = (PasswordSafeImpl)passwordSafe;
        this.$$$setupUI$$$();
        this.myMasterPasswordStateLabel.setForeground((Color)JBColor.BLUE);
        this.updateMasterPasswordState();
        this.myManagePasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordSafeOptionsPanel.this.myPasswordSafe.getMasterKeyProvider().isEmpty()) {
                    MasterPasswordDialog.resetMasterPasswordDialog(null, PasswordSafeOptionsPanel.this.myPasswordSafe.getMasterKeyProvider(), PasswordSafeOptionsPanel.class).show();
                } else {
                    MasterPasswordDialog.changeMasterPasswordDialog(null, PasswordSafeOptionsPanel.this.myPasswordSafe.getMasterKeyProvider(), PasswordSafeOptionsPanel.class).show();
                }
                PasswordSafeOptionsPanel.this.updateMasterPasswordState();
            }
        });
    }

    private void updateMasterPasswordState() {
        boolean empty = this.myPasswordSafe.getMasterKeyProvider().isMasterPasswordEnabled();
        this.myMasterPasswordStateLabel.setText(empty ? "Disabled" : "Enabled");
    }

    public void reset(PasswordSafeSettings settings) {
        PasswordSafeSettings.ProviderType t = settings.getProviderType();
        this.updateMasterPasswordState();
        switch (t) {
            case DO_NOT_STORE: {
                this.myDoNotRememberPasswordsRadioButton.setSelected(true);
                break;
            }
            case MEMORY_ONLY: {
                this.myRememberPasswordsUntilClosingRadioButton.setSelected(true);
                break;
            }
            case MASTER_PASSWORD: {
                this.mySaveOnDiskRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown provider type: " + (Object)((Object)t));
            }
        }
    }

    private PasswordSafeSettings.ProviderType getProviderType() {
        if (this.myDoNotRememberPasswordsRadioButton.isSelected()) {
            return PasswordSafeSettings.ProviderType.DO_NOT_STORE;
        }
        if (this.myRememberPasswordsUntilClosingRadioButton.isSelected()) {
            return PasswordSafeSettings.ProviderType.MEMORY_ONLY;
        }
        return PasswordSafeSettings.ProviderType.MASTER_PASSWORD;
    }

    public boolean isModified(PasswordSafeSettings settings) {
        return this.getProviderType() != settings.getProviderType();
    }

    public void apply(PasswordSafeSettings settings) {
        settings.setProviderType(this.getProviderType());
    }

    public JComponent getRoot() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JButton jButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Password storage policy", (int)0, (int)0, null, null));
        this.myDoNotRememberPasswordsRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Do not remember passwords");
        jRadioButton3.setMnemonic('N');
        jRadioButton3.setDisplayedMnemonicIndex(3);
        jRadioButton3.setToolTipText("Password asked from user each time they are needed.");
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRememberPasswordsUntilClosingRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Remember passwords until the application is closed");
        jRadioButton2.setMnemonic('U');
        jRadioButton2.setDisplayedMnemonicIndex(19);
        jRadioButton2.setToolTipText("The passwords are stored only in the memory. They will be forgotten when application terminates.");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySaveOnDiskRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Save on disk with master password protection");
        jRadioButton.setMnemonic('D');
        jRadioButton.setDisplayedMnemonicIndex(8);
        jRadioButton.setToolTipText("The passwords are saved on disk and after restart only master password will be asked.");
        jRadioButton.setSelected(true);
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Disk storage protection", (int)0, (int)0, null, null));
        this.myManagePasswordButton = jButton = new JButton();
        jButton.setToolTipText("Reset or specify a password for the password database");
        jButton.setText("Master Password");
        jButton.setMnemonic('M');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMasterPasswordStateLabel = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

