/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.SmartList;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StartupManagerImpl
extends StartupManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.impl.StartupManagerImpl");
    private final List<Runnable> myPreStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myDumbAwarePostStartupActivities = Collections.synchronizedList(new LinkedList());
    private final List<Runnable> myNotDumbAwarePostStartupActivities = Collections.synchronizedList(new LinkedList());
    private boolean myPostStartupActivitiesPassed = false;
    private volatile boolean myPreStartupActivitiesPassed = false;
    private volatile boolean myStartupActivitiesRunning = false;
    private volatile boolean myStartupActivitiesPassed = false;
    private final Project myProject;

    public StartupManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerPreStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerPreStartupActivity"));
        }
        LOG.assertTrue(!this.myPreStartupActivitiesPassed, (Object)"Registering pre startup activity that will never be run");
        this.myPreStartupActivities.add(runnable2);
    }

    public void registerStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerStartupActivity"));
        }
        LOG.assertTrue(!this.myStartupActivitiesPassed, (Object)"Registering startup activity that will never be run");
        this.myStartupActivities.add(runnable2);
    }

    public synchronized void registerPostStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/startup/impl/StartupManagerImpl", "registerPostStartupActivity"));
        }
        LOG.assertTrue(!this.myPostStartupActivitiesPassed, (Object)("Registering post-startup activity that will never be run: disposed=" + this.myProject.isDisposed() + "; open=" + this.myProject.isOpen() + "; passed=" + this.myStartupActivitiesPassed));
        (DumbService.isDumbAware((Object)runnable2) ? this.myDumbAwarePostStartupActivities : this.myNotDumbAwarePostStartupActivities).add(runnable2);
    }

    @Override
    public boolean startupActivityRunning() {
        return this.myStartupActivitiesRunning;
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    @Override
    public synchronized boolean postStartupActivityPassed() {
        return this.myPostStartupActivitiesPassed;
    }

    public void runStartupActivities() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Running Startup Activities");
                try {
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myPreStartupActivities);
                    StartupManagerImpl startupManagerImpl = StartupManagerImpl.this;
                    synchronized (startupManagerImpl) {
                        StartupManagerImpl.this.myPreStartupActivitiesPassed = true;
                        StartupManagerImpl.this.myStartupActivitiesRunning = true;
                    }
                    StartupManagerImpl.runActivities(StartupManagerImpl.this.myStartupActivities);
                    startupManagerImpl = StartupManagerImpl.this;
                    synchronized (startupManagerImpl) {
                        StartupManagerImpl.this.myStartupActivitiesRunning = false;
                        StartupManagerImpl.this.myStartupActivitiesPassed = true;
                    }
                }
                finally {
                    token.finish();
                }
            }
        });
    }

    public void runPostStartupActivitiesFromExtensions() {
        for (final StartupActivity extension : (StartupActivity[])Extensions.getExtensions((ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY)) {
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    if (!StartupManagerImpl.this.myProject.isDisposed()) {
                        extension.runActivity(StartupManagerImpl.this.myProject);
                    }
                }
            };
            if (extension instanceof DumbAware) {
                StartupManagerImpl.runActivity(runnable2);
                continue;
            }
            this.queueSmartModeActivity(runnable2);
        }
    }

    private void queueSmartModeActivity(final Runnable activity) {
        DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

            @Override
            public void run() {
                StartupManagerImpl.runActivity(activity);
            }
        });
    }

    public void runPostStartupActivities() {
        if (this.postStartupActivityPassed()) {
            return;
        }
        final Application app = ApplicationManager.getApplication();
        if (!app.isHeadlessEnvironment()) {
            this.checkFsSanity();
            this.checkProjectRoots();
        }
        StartupManagerImpl.runActivities(this.myDumbAwarePostStartupActivities);
        DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                app.assertIsDispatchThread();
                StartupManagerImpl.runActivities(StartupManagerImpl.this.myDumbAwarePostStartupActivities);
                StartupManagerImpl startupManagerImpl = StartupManagerImpl.this;
                synchronized (startupManagerImpl) {
                    if (!StartupManagerImpl.this.myNotDumbAwarePostStartupActivities.isEmpty()) {
                        while (!StartupManagerImpl.this.myNotDumbAwarePostStartupActivities.isEmpty()) {
                            StartupManagerImpl.this.queueSmartModeActivity((Runnable)StartupManagerImpl.this.myNotDumbAwarePostStartupActivities.remove(0));
                        }
                        DumbService.getInstance((Project)StartupManagerImpl.this.myProject).runWhenSmart((Runnable)this);
                    } else {
                        StartupManagerImpl.this.myPostStartupActivitiesPassed = true;
                    }
                }
            }
        });
        if (!app.isUnitTestMode()) {
            Registry.get((String)"ide.firstStartup").setValue(false);
        }
    }

    public void scheduleInitialVfsRefresh() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (StartupManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                StartupManagerImpl.this.markContentRootsForRefresh();
                Application app = ApplicationManager.getApplication();
                if (!app.isHeadlessEnvironment()) {
                    final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
                    final MessageBusConnection connection = app.getMessageBus().connect();
                    connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(){

                        public void afterProjectClosed(@NotNull Project project) {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/startup/impl/StartupManagerImpl$5$1", "afterProjectClosed"));
                            }
                            RefreshQueue.getInstance().cancelSession(sessionId);
                            connection.disconnect();
                        }
                    });
                } else {
                    VirtualFileManager.getInstance().syncRefresh();
                }
            }
        });
    }

    private void markContentRootsForRefresh() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (!(contentRoot instanceof NewVirtualFile)) continue;
                ((NewVirtualFile)contentRoot).markDirtyRecursively();
            }
        }
    }

    private void checkFsSanity() {
        try {
            String path = this.myProject.getProjectFilePath();
            if (path == null || FileUtil.isAncestor((String)PathManager.getConfigPath(), (String)path, (boolean)true)) {
                return;
            }
            boolean actual = FileUtil.isFileSystemCaseSensitive((String)path);
            LOG.info(path + " case-sensitivity: " + actual);
            if (actual != SystemInfo.isFileSystemCaseSensitive) {
                int prefix = SystemInfo.isFileSystemCaseSensitive ? 1 : 0;
                String title = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.title", (Object[])new Object[0]);
                String text = ApplicationBundle.message((String)"fs.case.sensitivity.mismatch.message", (Object[])new Object[]{prefix});
                Notifications.Bus.notify((Notification)new Notification("System Messages", title, text, NotificationType.WARNING, NotificationListener.URL_OPENING_LISTENER), (Project)this.myProject);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void checkProjectRoots() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational()) {
            return;
        }
        List<String> manualWatchRoots = watcher.getManualWatchRoots();
        if (manualWatchRoots.isEmpty()) {
            return;
        }
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        if (roots.length == 0) {
            return;
        }
        SmartList nonWatched = new SmartList();
        for (VirtualFile root : roots) {
            if (!(root.getFileSystem() instanceof LocalFileSystem)) continue;
            String rootPath = root.getPath();
            for (String manualWatchRoot : manualWatchRoots) {
                if (!FileUtil.isAncestor((String)manualWatchRoot, (String)rootPath, (boolean)false)) continue;
                nonWatched.add(rootPath);
            }
        }
        if (!nonWatched.isEmpty()) {
            String message = ApplicationBundle.message((String)"watcher.non.watchable.project", (Object[])new Object[0]);
            watcher.notifyOnFailure(message, null);
            LOG.info("unwatched roots: " + nonWatched);
            LOG.info("manual watches: " + manualWatchRoots);
        }
    }

    public void startCacheUpdate() {
        try {
            DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                dumbService.queueTask(new DumbModeTask(){

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/startup/impl/StartupManagerImpl$6", "performInDumbMode"));
                        }
                        StartupManagerImpl.this.scheduleInitialVfsRefresh();
                    }

                    public String toString() {
                        return "initial refresh";
                    }
                });
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private static void runActivities(@NotNull List<Runnable> activities) {
        if (activities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activities", "com/intellij/ide/startup/impl/StartupManagerImpl", "runActivities"));
        }
        while (!activities.isEmpty()) {
            StartupManagerImpl.runActivity(activities.remove(0));
        }
    }

    private static void runActivity(Runnable runnable2) {
        ProgressManager.checkCanceled();
        try {
            runnable2.run();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable ex) {
            LOG.error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenProjectIsInitialized(final @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/ide/startup/impl/StartupManagerImpl", "runWhenProjectIsInitialized"));
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        StartupManagerImpl startupManagerImpl = this;
        synchronized (startupManagerImpl) {
            boolean initialized;
            boolean bl = initialized = this.myProject.isInitialized() || application.isUnitTestMode() && this.myPostStartupActivitiesPassed;
            if (!initialized) {
                this.registerPostStartupActivity(action);
                return;
            }
        }
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (!StartupManagerImpl.this.myProject.isDisposed()) {
                    action.run();
                }
            }
        };
        if (application.isDispatchThread() && ModalityState.current() == ModalityState.NON_MODAL) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2, ModalityState.NON_MODAL);
        }
    }

    public synchronized void prepareForNextTest() {
        this.myPreStartupActivities.clear();
        this.myStartupActivities.clear();
        this.myDumbAwarePostStartupActivities.clear();
        this.myNotDumbAwarePostStartupActivities.clear();
    }

    public synchronized void checkCleared() {
        try {
            assert (this.myStartupActivities.isEmpty()) : "Activities: " + this.myStartupActivities;
            assert (this.myDumbAwarePostStartupActivities.isEmpty()) : "DumbAware Post Activities: " + this.myDumbAwarePostStartupActivities;
            assert (this.myNotDumbAwarePostStartupActivities.isEmpty()) : "Post Activities: " + this.myNotDumbAwarePostStartupActivities;
            assert (this.myPreStartupActivities.isEmpty()) : "Pre Activities: " + this.myPreStartupActivities;
        }
        finally {
            this.prepareForNextTest();
        }
    }
}

