/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;

public class JavaModuleInsight
extends ModuleInsight {
    private final Lexer myLexer = JavaParserDefinition.createLexer(LanguageLevel.JDK_1_5);

    public JavaModuleInsight(@Nullable ProgressIndicator progress, Set<String> existingModuleNames, Set<String> existingProjectLibraryNames) {
        super(progress, existingModuleNames, existingProjectLibraryNames);
    }

    @Override
    protected boolean isSourceFile(File file) {
        return StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".java");
    }

    @Override
    protected boolean isLibraryFile(String fileName) {
        return StringUtil.endsWithIgnoreCase((String)fileName, (String)".jar") || StringUtil.endsWithIgnoreCase((String)fileName, (String)".zip");
    }

    @Override
    protected void scanSourceFileForImportedPackages(CharSequence chars, Consumer<String> result2) {
        this.myLexer.start(chars);
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(this.myLexer);
        if (this.myLexer.getTokenType() == JavaTokenType.PACKAGE_KEYWORD) {
            JavaModuleInsight.advanceLexer(this.myLexer);
            if (JavaModuleInsight.readPackageName(chars, this.myLexer) == null) {
                return;
            }
        }
        while (true) {
            String packageName;
            if (this.myLexer.getTokenType() == JavaTokenType.SEMICOLON) {
                JavaModuleInsight.advanceLexer(this.myLexer);
            }
            if (this.myLexer.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
                return;
            }
            JavaModuleInsight.advanceLexer(this.myLexer);
            boolean isStaticImport = false;
            if (this.myLexer.getTokenType() == JavaTokenType.STATIC_KEYWORD) {
                isStaticImport = true;
                JavaModuleInsight.advanceLexer(this.myLexer);
            }
            if ((packageName = JavaModuleInsight.readPackageName(chars, this.myLexer)) == null) {
                return;
            }
            if (packageName.endsWith(".*")) {
                result2.consume((Object)packageName.substring(0, packageName.length() - ".*".length()));
                continue;
            }
            int lastDot = packageName.lastIndexOf(46);
            if (lastDot <= 0) continue;
            String _packageName = packageName.substring(0, lastDot);
            if (isStaticImport) {
                lastDot = _packageName.lastIndexOf(46);
                if (lastDot <= 0) continue;
                result2.consume((Object)_packageName.substring(0, lastDot));
                continue;
            }
            result2.consume((Object)_packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String readPackageName(CharSequence text, Lexer lexer) {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            while (lexer.getTokenType() == JavaTokenType.IDENTIFIER || lexer.getTokenType() == JavaTokenType.ASTERISK) {
                buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
                JavaModuleInsight.advanceLexer(lexer);
                if (lexer.getTokenType() != JavaTokenType.DOT) break;
                buffer.append('.');
                JavaModuleInsight.advanceLexer(lexer);
            }
            String packageName = buffer.toString();
            if (packageName.length() == 0 || StringUtil.endsWithChar((CharSequence)packageName, (char)'.') || StringUtil.startsWithChar((CharSequence)packageName, (char)'*')) {
                String string = null;
                return string;
            }
            String string = packageName;
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    private static void advanceLexer(Lexer lexer) {
        lexer.advance();
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scanLibraryForDeclaredPackages(File file, Consumer<String> result2) throws IOException {
        ZipFile zip = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int index;
                String entryName = entries.nextElement().getName();
                if (!StringUtil.endsWithIgnoreCase((String)entryName, (String)".class") || (index = entryName.lastIndexOf(47)) <= 0) continue;
                String packageName = entryName.substring(0, index).replace('/', '.');
                result2.consume((Object)packageName);
            }
        }
        finally {
            zip.close();
        }
    }

    @Override
    protected ModuleDescriptor createModuleDescriptor(File moduleContentRoot, Collection<DetectedSourceRoot> sourceRoots) {
        return new ModuleDescriptor(moduleContentRoot, StdModuleTypes.JAVA, sourceRoots);
    }

    @Override
    public boolean isApplicableRoot(DetectedProjectRoot root) {
        return root instanceof JavaModuleSourceRoot;
    }
}

