/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.importProject.DetectedRootsChooser;
import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RootsDetectionStep
extends AbstractStepWithProgress<List<DetectedRootData>> {
    private static final String ROOTS_FOUND_CARD = "roots_found";
    private static final String ROOTS_NOT_FOUND_CARD = "roots_not_found";
    private final ProjectFromSourcesBuilderImpl myBuilder;
    private final WizardContext myContext;
    private final StepSequence mySequence;
    private final Icon myIcon;
    private final String myHelpId;
    private DetectedRootsChooser myDetectedRootsChooser;
    private String myCurrentBaseProjectPath = null;
    private JPanel myResultPanel;

    public RootsDetectionStep(ProjectFromSourcesBuilderImpl builder, WizardContext context, StepSequence sequence, Icon icon, @NonNls String helpId) {
        super(IdeBundle.message((String)"prompt.stop.searching.for.sources", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
        this.myBuilder = builder;
        this.myContext = context;
        this.mySequence = sequence;
        this.myIcon = icon;
        this.myHelpId = helpId;
    }

    @Override
    protected JComponent createResultsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myDetectedRootsChooser = new DetectedRootsChooser();
        this.myDetectedRootsChooser.addSelectionListener(new DetectedRootsChooser.RootSelectionListener(){

            @Override
            public void selectionChanged() {
                RootsDetectionStep.this.updateSelectedTypes();
            }
        });
        String text = IdeBundle.message((String)"label.project.roots.have.been.found", (Object[])new Object[0]);
        JLabel label = new JLabel(text);
        label.setUI((LabelUI)new MultiLineLabelUI());
        panel.add((Component)label, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 0, 10), 0, 0));
        panel.add((Component)this.myDetectedRootsChooser.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, new Insets(8, 10, 8, 10), 0, 0));
        JButton markAllButton = new JButton(IdeBundle.message((String)"button.mark.all", (Object[])new Object[0]));
        panel.add((Component)markAllButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 8, 2), 0, 0));
        JButton unmarkAllButton = new JButton(IdeBundle.message((String)"button.unmark.all", (Object[])new Object[0]));
        panel.add((Component)unmarkAllButton, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 8, 10), 0, 0));
        markAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootsDetectionStep.this.myDetectedRootsChooser.setAllElementsMarked(true);
            }
        });
        unmarkAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootsDetectionStep.this.myDetectedRootsChooser.setAllElementsMarked(false);
            }
        });
        this.myResultPanel = new JPanel(new CardLayout());
        this.myResultPanel.add(ROOTS_FOUND_CARD, panel);
        JPanel notFoundPanel = new JPanel(new BorderLayout());
        notFoundPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)5));
        notFoundPanel.add("North", new MultiLineLabel(IdeBundle.message((String)"label.project.roots.not.found", (Object[])new Object[0])));
        this.myResultPanel.add(ROOTS_NOT_FOUND_CARD, notFoundPanel);
        return this.myResultPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDetectedRootsChooser.getComponent();
    }

    public void updateDataModel() {
        List<DetectedRootData> selectedElements = this.myDetectedRootsChooser.getMarkedElements();
        this.myBuilder.setupProjectStructure(RootDetectionProcessor.createRootsMap(selectedElements));
        this.updateSelectedTypes();
    }

    private void updateSelectedTypes() {
        LinkedHashSet<String> selectedTypes = new LinkedHashSet<String>();
        selectedTypes.add("Existing Sources");
        for (DetectedRootData rootData : this.myDetectedRootsChooser.getMarkedElements()) {
            for (ProjectStructureDetector detector : rootData.getSelectedDetectors()) {
                selectedTypes.add(detector.getDetectorId());
            }
        }
        this.mySequence.setTypes(selectedTypes);
        this.myContext.requestWizardButtonsUpdate();
    }

    @Override
    protected boolean shouldRunProgress() {
        String baseProjectPath = this.getBaseProjectPath();
        return this.myCurrentBaseProjectPath == null ? baseProjectPath != null : !this.myCurrentBaseProjectPath.equals(baseProjectPath);
    }

    @Override
    protected void onFinished(List<DetectedRootData> foundRoots, boolean canceled) {
        CardLayout layout = (CardLayout)this.myResultPanel.getLayout();
        if (foundRoots.size() > 0 && !canceled) {
            this.myCurrentBaseProjectPath = this.getBaseProjectPath();
            this.myDetectedRootsChooser.setElements(foundRoots);
            this.updateSelectedTypes();
            layout.show(this.myResultPanel, ROOTS_FOUND_CARD);
        } else {
            this.myCurrentBaseProjectPath = null;
            layout.show(this.myResultPanel, ROOTS_NOT_FOUND_CARD);
        }
        this.myResultPanel.revalidate();
    }

    @Override
    protected List<DetectedRootData> calculate() {
        String baseProjectPath = this.getBaseProjectPath();
        if (baseProjectPath == null) {
            return Collections.emptyList();
        }
        return RootDetectionProcessor.detectRoots(new File(baseProjectPath));
    }

    @Nullable
    private String getBaseProjectPath() {
        return this.myBuilder.getBaseProjectPath();
    }

    @Override
    protected String getProgressText() {
        String root = this.getBaseProjectPath();
        return IdeBundle.message((String)"progress.searching.for.sources", (Object[])new Object[]{root != null ? root.replace('/', File.separatorChar) : ""});
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }
}

