/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.actions.ProjectSpecificAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.CustomStepProjectGenerator;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.NewDirectoryProjectAction;
import com.intellij.util.Function;
import com.intellij.util.NullableConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractNewProjectStep
extends DefaultActionGroup
implements DumbAware {
    protected AbstractNewProjectStep(@NotNull Customization customization) {
        if (customization == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customization", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep", "<init>"));
        }
        super("Select Project Type", true);
        NullableConsumer<ProjectSettingsStepBase> callback = customization.createCallback();
        DirectoryProjectGenerator emptyProjectGenerator = customization.createEmptyProjectGenerator();
        ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(emptyProjectGenerator, customization.createProjectSpecificSettingsStep(emptyProjectGenerator, callback));
        this.addAll(projectSpecificAction.getChildren(null));
        DirectoryProjectGenerator[] generators = customization.getProjectGenerators();
        customization.setUpBasicAction(projectSpecificAction, generators);
        for (DirectoryProjectGenerator generator : generators) {
            this.addAll(customization.getActions(generator, callback));
        }
        this.addAll(customization.getExtraActions(callback));
    }

    protected static abstract class AbstractCallback
    implements NullableConsumer<ProjectSettingsStepBase> {
        protected AbstractCallback() {
        }

        public void consume(@Nullable ProjectSettingsStepBase settings) {
            if (settings == null) {
                return;
            }
            Project project = ProjectManager.getInstance().getDefaultProject();
            final DirectoryProjectGenerator generator = settings.getProjectGenerator();
            NewDirectoryProjectAction.doGenerateProject(project, settings.getProjectLocation(), generator, new Function<VirtualFile, Object>(){

                public Object fun(VirtualFile file) {
                    return AbstractCallback.this.getProjectSettings(generator);
                }
            });
        }

        @Nullable
        protected abstract Object getProjectSettings(@NotNull DirectoryProjectGenerator var1);
    }

    protected static abstract class Customization {
        protected Customization() {
        }

        @NotNull
        protected abstract NullableConsumer<ProjectSettingsStepBase> createCallback();

        @NotNull
        protected abstract DirectoryProjectGenerator createEmptyProjectGenerator();

        @NotNull
        protected abstract ProjectSettingsStepBase createProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator var1, @NotNull NullableConsumer<ProjectSettingsStepBase> var2);

        @NotNull
        protected DirectoryProjectGenerator[] getProjectGenerators() {
            DirectoryProjectGenerator[] directoryProjectGeneratorArray = (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
            if (directoryProjectGeneratorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getProjectGenerators"));
            }
            return directoryProjectGeneratorArray;
        }

        @NotNull
        public AnAction[] getActions(@NotNull DirectoryProjectGenerator generator, @NotNull NullableConsumer<ProjectSettingsStepBase> callback) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            if (this.shouldIgnore(generator)) {
                if (AnAction.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
                }
                return AnAction.EMPTY_ARRAY;
            }
            ProjectSettingsStepBase step = generator instanceof CustomStepProjectGenerator ? (ProjectSettingsStepBase)((CustomStepProjectGenerator)((Object)generator)).createStep(generator, callback) : this.createProjectSpecificSettingsStep(generator, callback);
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(generator, step);
            AnAction[] anActionArray = projectSpecificAction.getChildren(null);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            return anActionArray;
        }

        protected boolean shouldIgnore(@NotNull DirectoryProjectGenerator generator) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "shouldIgnore"));
            }
            return false;
        }

        @NotNull
        public AnAction[] getExtraActions(@NotNull NullableConsumer<ProjectSettingsStepBase> callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getExtraActions"));
            }
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getExtraActions"));
            }
            return AnAction.EMPTY_ARRAY;
        }

        public void setUpBasicAction(@NotNull ProjectSpecificAction projectSpecificAction, @NotNull DirectoryProjectGenerator[] generators) {
            if (projectSpecificAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSpecificAction", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "setUpBasicAction"));
            }
            if (generators == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generators", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "setUpBasicAction"));
            }
        }
    }
}

