/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"'\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005!\u0011!$\u0007\t\u00055\t\u0001TA\r\u0004\u0011\ri\u0011\u0001g\u0002\u001a\u0007!!Q\"\u0001M\u0005)\u000e\tQr\u0005\u0005\u0006\u001b\u0005A*!G\u0002\t\u00075\t\u0001tA\r\u0004\u0011\u0011i\u0011\u0001'\u0001\u001a\r!-Q\u0002B\u0005\u0003\u0013\u0005A\n\u0001\u0007\u0004U\u0007\u0005i\u0019\u0002B\u0001\t\u000e5\t\u0001tA\r\u0004\u0011\u001di\u0011\u0001'\u0001U\u0007\u0005\t\u0012\u0002B!I\u0003!\u0001Q\"\u0001M\u0001#\u000e\tQ\u0001\u0001+\u0004\u0003EIA!\u0011%\u0002\u0011\u0007i\u0011\u0001'\u0001R\u0007\u0005)\u0001\u0001V\u0002\u0002"}, strings={"kilo", "", "StatisticsUtilKt", "mega", "getBooleanUsage", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "key", "", "value", "", "getCountingUsage", "steps", "", "humanize", "number"}, moduleName="platform-impl")
public final class StatisticsUtilKt {
    private static final int kilo = 1000;
    private static final int mega = 1000000;

    @NotNull
    public static final UsageDescriptor getBooleanUsage(@NotNull String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new UsageDescriptor(key + (value ? ".enabled" : ".disabled"), 1);
    }

    @NotNull
    public static final UsageDescriptor getCountingUsage(@NotNull String key, int value, @NotNull List<? extends Integer> steps) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(steps, (String)"steps");
        int index = CollectionsKt.binarySearch$default(steps, (Comparable)Integer.valueOf(value), (int)0, (int)0, (int)6);
        int stepIndex = index == steps.size() ? ((Number)CollectionsKt.last(steps)).intValue() : (index >= 0 ? index : -index - 2);
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        String maybePlus = addPlus ? "+" : "";
        return new UsageDescriptor(key + "." + StatisticsUtilKt.humanize(step) + maybePlus, 1);
    }

    private static final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / mega;
        int k = number % mega / kilo;
        int r = number % kilo;
        String ms = m > 0 ? m + "M" : "";
        String ks = k > 0 ? k + "K" : "";
        String rs = r > 0 ? String.valueOf(r) : "";
        return ms + ks + rs;
    }

    static {
        kilo = 1000;
        mega = kilo * kilo;
    }
}

