/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockVirtualFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.SmartList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFile
extends VirtualFile {
    private static final MockVirtualFileSystem ourFileSystem = new MockVirtualFileSystem();
    private VirtualFile myParent;
    private final String myName;
    private final boolean myDirectory;
    private final List<VirtualFile> myChildren = new SmartList();
    private String myText;
    private boolean myIsWritable = true;
    private long myModStamp = LocalTimeCounter.currentTime();
    private final long myTimeStamp = System.currentTimeMillis();
    private VirtualFileListener myListener = null;

    public MockVirtualFile(String name) {
        this(false, name);
    }

    public MockVirtualFile(boolean directory, String name) {
        this.myDirectory = directory;
        this.myName = name;
    }

    public MockVirtualFile(String name, String text) {
        this.myName = name;
        this.myText = text;
        this.myDirectory = false;
    }

    public void setText(String text) {
        this.myText = text;
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFile", "getName"));
        }
        return string;
    }

    public void setParent(VirtualFile parent) {
        this.myParent = parent;
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockVirtualFile", "createChildData"));
        }
        MockVirtualFile file = new MockVirtualFile(name);
        this.addChild(file);
        MockVirtualFile mockVirtualFile = file;
        if (mockVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFile", "createChildData"));
        }
        return mockVirtualFile;
    }

    public void addChild(@NotNull MockVirtualFile child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/mock/MockVirtualFile", "addChild"));
        }
        child.setParent(this);
        this.myChildren.add(child);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        MockVirtualFileSystem mockVirtualFileSystem = ourFileSystem;
        if (mockVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFile", "getFileSystem"));
        }
        return mockVirtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String prefix = this.myParent == null ? "MOCK_ROOT:" : this.myParent.getPath();
        String string = prefix + "/" + this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return this.myIsWritable;
    }

    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return VfsUtilCore.toVirtualFileArray(this.myChildren);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void close() {
                MockVirtualFile.this.myModStamp = newModificationStamp;
                MockVirtualFile.this.myText = this.toString();
            }
        };
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFile", "getOutputStream"));
        }
        return byteArrayOutputStream;
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    public void setModificationStamp(long modStamp) {
        this.myModStamp = modStamp;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = this.myText.getBytes();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getTimeStamp() {
        return this.myTimeStamp;
    }

    public long getLength() {
        return this.myText.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Method getInputStream is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void setListener(VirtualFileListener listener) {
        this.myListener = listener;
    }

    public void setContent(@Nullable Object requestor, String content, boolean fireEvent) {
        long oldStamp = this.myModStamp;
        this.myText = content;
        if (fireEvent) {
            this.myModStamp = LocalTimeCounter.currentTime();
            this.myListener.contentsChanged(new VirtualFileEvent(requestor, (VirtualFile)this, null, oldStamp, this.myModStamp));
        }
    }
}

