/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
implements EditorColorsScheme {
    private static final int CURR_VERSION = 142;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    protected float myLineSpacing;
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);
    @NotNull
    private final FontPreferences myFontPreferences = new FontPreferences();
    @NotNull
    private final FontPreferences myConsoleFontPreferences = new FontPreferences();
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String myFallbackFontName;
    private String mySchemeName;
    private float myConsoleLineSpacing = -1.0f;
    private int myVersion = 142;
    private int myOriginalVersion = 142;
    protected Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = ContainerUtilRt.newHashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    @Deprecated
    public static final Map<String, Color> DEFAULT_ERROR_STRIPE_COLOR = new THashMap();
    private static final Map<String, Couple<Color>> DEFAULT_STRIPE_COLORS = new THashMap<String, Couple<Color>>(){
        {
            this.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.red, (Object)ColorUtil.fromHex((String)"CF5B56")));
            this.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Couple.of((Object)Color.yellow, (Object)ColorUtil.fromHex((String)"EBC700")));
            this.put("EXECUTIONPOINT_ATTRIBUTES", Couple.of((Object)Color.blue, (Object)ColorUtil.fromHex((String)"3763b0")));
            this.put(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"CCCFFF"), (Object)ColorUtil.fromHex((String)"BAA8FF")));
            this.put(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"FFCCE5"), (Object)ColorUtil.fromHex((String)"F0ADF0")));
            this.put(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"586E75"), (Object)ColorUtil.fromHex((String)"71B362")));
            this.put(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES.getExternalName(), Couple.of((Object)ColorUtil.fromHex((String)"268BD2"), (Object)ColorUtil.fromHex((String)"54AAE3")));
        }
    };

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
        this.myFontPreferences.setChangeListener(new Runnable(){

            @Override
            public void run() {
                AbstractColorsScheme.this.initFonts();
            }
        });
    }

    public AbstractColorsScheme() {
    }

    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultBackground"));
        }
        return color;
    }

    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultForeground"));
        }
        return color;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getName"));
        }
        return string;
    }

    public void setFont(EditorFontType key, Font font) {
        this.myFonts.put(key, font);
    }

    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        this.myFontPreferences.copyTo(newScheme.myFontPreferences);
        newScheme.myLineSpacing = this.myLineSpacing;
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        this.myConsoleFontPreferences.copyTo(newScheme.myConsoleFontPreferences);
        newScheme.myConsoleLineSpacing = this.myConsoleLineSpacing;
        Set<EditorFontType> types = this.myFonts.keySet();
        for (EditorFontType type : types) {
            Font font = this.myFonts.get(type);
            newScheme.setFont(type, font);
        }
        newScheme.myAttributesMap = new HashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    public void setEditorFontName(String fontName) {
        int editorFontSize = this.getEditorFontSize();
        this.myFontPreferences.clear();
        this.myFontPreferences.register(fontName, editorFontSize);
        this.initFonts();
    }

    public void setEditorFontSize(int fontSize) {
        this.myFontPreferences.register(this.getEditorFontName(), fontSize);
        this.initFonts();
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setQuickDocFontSize"));
        }
        this.myQuickDocFontSize = fontSize;
    }

    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = lineSpacing;
    }

    public Font getFont(EditorFontType key) {
        if (UISettings.getInstance().PRESENTATION_MODE) {
            Font font = this.myFonts.get(key);
            return new Font(font.getName(), font.getStyle(), UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE);
        }
        return this.myFonts.get(key);
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setName"));
        }
        this.mySchemeName = name;
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFontPreferences"));
        }
        return fontPreferences;
    }

    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setFontPreferences"));
        }
        preferences.copyTo(this.myFontPreferences);
        this.initFonts();
    }

    public String getEditorFontName() {
        if (this.myFallbackFontName != null) {
            return this.myFallbackFontName;
        }
        return this.myFontPreferences.getFontFamily();
    }

    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.getEditorFontName());
    }

    @NotNull
    public FontSize getQuickDocFontSize() {
        FontSize fontSize = this.myQuickDocFontSize;
        if (fontSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getQuickDocFontSize"));
        }
        return fontSize;
    }

    public float getLineSpacing() {
        float spacing = this.myLineSpacing;
        return spacing <= 0.0f ? 1.0f : spacing;
    }

    protected void initFonts() {
        String editorFontName = this.getEditorFontName();
        int editorFontSize = this.getEditorFontSize();
        this.myFallbackFontName = FontPreferences.getFallbackName((String)editorFontName, (int)editorFontSize, (EditorColorsScheme)this.myParentScheme);
        if (this.myFallbackFontName != null) {
            editorFontName = this.myFallbackFontName;
        }
        Font plainFont = new Font(editorFontName, 0, editorFontSize);
        Font boldFont = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        String consoleFontName = this.getConsoleFontName();
        int consoleFontSize = this.getConsoleFontSize();
        Font consolePlainFont = new Font(consoleFontName, 0, consoleFontSize);
        Font consoleBoldFont = new Font(consoleFontName, 1, consoleFontSize);
        Font consoleItalicFont = new Font(consoleFontName, 2, consoleFontSize);
        Font consoleBoldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
        this.myFonts.put(EditorFontType.CONSOLE_PLAIN, consolePlainFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD, consoleBoldFont);
        this.myFonts.put(EditorFontType.CONSOLE_ITALIC, consoleItalicFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD_ITALIC, consoleBoldItalicFont);
    }

    public String toString() {
        return this.getName();
    }

    public void readExternal(Element parentNode) {
        UISettings settings = UISettings.getInstance();
        ColorBlindness blindness = settings == null ? null : settings.COLOR_BLINDNESS;
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            for (Element element : parentNode.getChildren(SCHEME_ELEMENT)) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue(NAME_ATTR));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        this.myOriginalVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = DefaultColorSchemesManager.getInstance().getScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Default"));
        }
        for (Object o : node.getChildren()) {
            Element childNode = (Element)o;
            String childName = childNode.getName();
            if (OPTION_ELEMENT.equals(childName)) {
                this.readSettings(childNode, isDefault);
                continue;
            }
            if (EDITOR_FONT.equals(childName)) {
                this.readFontSettings(childNode, this.myFontPreferences, isDefault);
                continue;
            }
            if (CONSOLE_FONT.equals(childName)) {
                this.readFontSettings(childNode, this.myConsoleFontPreferences, isDefault);
                continue;
            }
            if (COLORS_ELEMENT.equals(childName)) {
                this.readColors(childNode);
                continue;
            }
            if (!ATTRIBUTES_ELEMENT.equals(childName)) continue;
            this.readAttributes(childNode);
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readAttributes"));
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            TextAttributesKey key = TextAttributesKey.find((String)e.getAttributeValue(NAME_ATTR));
            String baseKeyName = e.getAttributeValue(BASE_ATTRIBUTES_ATTR);
            if (baseKeyName != null) {
                TextAttributesKey baseKey = TextAttributesKey.find((String)baseKeyName);
                key.setFallbackAttributeKey(baseKey);
            }
            Element valueElement = e.getChild(VALUE_ELEMENT);
            TextAttributes attr = this.myValueReader.read(TextAttributes.class, valueElement);
            this.myAttributesMap.put(key, attr);
            this.migrateErrorStripeColorFrom14(key, attr);
        }
    }

    private void migrateErrorStripeColorFrom14(@NotNull TextAttributesKey name, @NotNull TextAttributes attr) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (this.myVersion >= 141 || this.myParentScheme == null) {
            return;
        }
        Couple<Color> m = DEFAULT_STRIPE_COLORS.get(name.getExternalName());
        if (m != null && Comparing.equal((Object)m.first, (Object)attr.getErrorStripeColor())) {
            attr.setErrorStripeColor((Color)m.second);
        }
    }

    private void readColors(Element childNode) {
        for (Object o : childNode.getChildren(OPTION_ELEMENT)) {
            Element colorElement = (Element)o;
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            String colorName = colorElement.getAttributeValue(NAME_ATTR);
            if (BACKGROUND_COLOR_NAME.equals(colorName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)colorName);
            this.myColorsMap.put(name, valueColor);
        }
    }

    private void readSettings(Element childNode, boolean isDefault) {
        FontSize value;
        String name = childNode.getAttributeValue(NAME_ATTR);
        if (LINE_SPACING.equals(name)) {
            Float value2 = this.myValueReader.read(Float.class, childNode);
            if (value2 != null) {
                this.myLineSpacing = value2.floatValue();
            }
        } else if (EDITOR_FONT_SIZE.equals(name)) {
            int value3 = this.readFontSize(childNode, isDefault);
            if (value3 > 0) {
                this.setEditorFontSize(value3);
            }
        } else if (EDITOR_FONT_NAME.equals(name)) {
            String value4 = this.myValueReader.read(String.class, childNode);
            if (value4 != null) {
                this.setEditorFontName(value4);
            }
        } else if (CONSOLE_LINE_SPACING.equals(name)) {
            Float value5 = this.myValueReader.read(Float.class, childNode);
            if (value5 != null) {
                this.setConsoleLineSpacing(value5.floatValue());
            }
        } else if (CONSOLE_FONT_SIZE.equals(name)) {
            int value6 = this.readFontSize(childNode, isDefault);
            if (value6 > 0) {
                this.setConsoleFontSize(value6);
            }
        } else if (CONSOLE_FONT_NAME.equals(name)) {
            String value7 = this.myValueReader.read(String.class, childNode);
            if (value7 != null) {
                this.setConsoleFontName(value7);
            }
        } else if (EDITOR_QUICK_JAVADOC_FONT_SIZE.equals(name) && (value = this.myValueReader.read(FontSize.class, childNode)) != null) {
            this.myQuickDocFontSize = value;
        }
    }

    private int readFontSize(Element element, boolean isDefault) {
        Integer size = this.myValueReader.read(Integer.class, element);
        return size == null ? -1 : (!isDefault ? size : JBUI.scaleFontSize((int)size));
    }

    private void readFontSettings(@NotNull Element element, @NotNull FontPreferences preferences, boolean isDefaultScheme) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        List children2 = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child : children2) {
            Element e = (Element)child;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue(NAME_ATTR))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue(NAME_ATTR))) continue;
            size = this.readFontSize(e, isDefaultScheme);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        boolean useOldFontFormat;
        parentNode.setAttribute(NAME_ATTR, this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (this.myParentScheme != null) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        Element element = new Element(OPTION_ELEMENT);
        element.setAttribute(NAME_ATTR, LINE_SPACING);
        element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getLineSpacing()));
        parentNode.addContent(element);
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (useOldFontFormat) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, EDITOR_FONT_SIZE);
            element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getEditorFontSize()));
            parentNode.addContent(element);
        } else {
            AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
        }
        if (!this.myFontPreferences.equals((Object)this.myConsoleFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                element = new Element(OPTION_ELEMENT);
                element.setAttribute(NAME_ATTR, CONSOLE_FONT_NAME);
                element.setAttribute(VALUE_ELEMENT, this.getConsoleFontName());
                parentNode.addContent(element);
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    element = new Element(OPTION_ELEMENT);
                    element.setAttribute(NAME_ATTR, CONSOLE_FONT_SIZE);
                    element.setAttribute(VALUE_ELEMENT, Integer.toString(this.getConsoleFontSize()));
                    parentNode.addContent(element);
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
        }
        if (this.getConsoleLineSpacing() != this.getLineSpacing()) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, CONSOLE_LINE_SPACING);
            element.setAttribute(VALUE_ELEMENT, Float.toString(this.getConsoleLineSpacing()));
            parentNode.addContent(element);
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, EDITOR_QUICK_JAVADOC_FONT_SIZE);
            element.setAttribute(VALUE_ELEMENT, this.getQuickDocFontSize().toString());
            parentNode.addContent(element);
        }
        if (useOldFontFormat) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, EDITOR_FONT_NAME);
            element.setAttribute(VALUE_ELEMENT, this.getEditorFontName());
            parentNode.addContent(element);
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (colorElements.getChildren().size() > 0) {
            parentNode.addContent(colorElements);
        }
        if (attrElements.getChildren().size() > 0) {
            parentNode.addContent(attrElements);
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            Element e = new Element(OPTION_ELEMENT);
            e.setAttribute(NAME_ATTR, EDITOR_FONT_NAME);
            e.setAttribute(VALUE_ELEMENT, fontFamily);
            element.addContent(e);
            e = new Element(OPTION_ELEMENT);
            e.setAttribute(NAME_ATTR, EDITOR_FONT_SIZE);
            e.setAttribute(VALUE_ELEMENT, String.valueOf(preferences.getSize(fontFamily)));
            element.addContent(e);
            parent.addContent(element);
        }
    }

    private void writeAttributes(Element attrElements) throws WriteExternalException {
        ArrayList<TextAttributesKey> list = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        Collections.sort(list);
        for (TextAttributesKey key : list) {
            TextAttributes defaultAttr = this.myParentScheme != null ? this.myParentScheme.getAttributes(key) : new TextAttributes();
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            TextAttributes defaultFallbackAttr = baseKey != null && this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getFallbackAttributes(baseKey) : null;
            TextAttributes value = this.myAttributesMap.get(key);
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, key.getExternalName());
            if (baseKey != null && value.isFallbackEnabled()) {
                if (defaultFallbackAttr == null || defaultAttr == null || defaultAttr == defaultFallbackAttr) continue;
                element.setAttribute(BASE_ATTRIBUTES_ATTR, baseKey.getExternalName());
                attrElements.addContent(element);
                continue;
            }
            if ((!value.containsValue() || value.equals((Object)defaultAttr)) && defaultAttr != defaultFallbackAttr) continue;
            Element valueElement = new Element(VALUE_ELEMENT);
            value.writeExternal(valueElement);
            element.addContent(valueElement);
            attrElements.addContent(element);
        }
    }

    protected Color getOwnColor(ColorKey key) {
        return this.myColorsMap.get(key);
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        Collections.sort(list);
        for (ColorKey key : list) {
            if (!this.haveToWrite(key)) continue;
            Color value = this.myColorsMap.get(key);
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute(NAME_ATTR, key.getExternalName());
            element.setAttribute(VALUE_ELEMENT, value != null ? Integer.toString(value.getRGB() & 0xFFFFFF, 16) : "");
            colorElements.addContent(element);
        }
    }

    private boolean haveToWrite(ColorKey key) {
        Color value = this.myColorsMap.get(key);
        return this.myParentScheme == null || !(this.myParentScheme instanceof AbstractColorsScheme ? Comparing.equal((Object)((AbstractColorsScheme)this.myParentScheme).getOwnColor(key), (Object)value) && ((AbstractColorsScheme)this.myParentScheme).myColorsMap.containsKey(key) : Comparing.equal((Object)this.myParentScheme.getColor(key), (Object)value));
    }

    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getConsoleFontPreferences"));
        }
        return fontPreferences;
    }

    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setConsoleFontPreferences"));
        }
        preferences.copyTo(this.myConsoleFontPreferences);
        this.initFonts();
    }

    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    public void setConsoleFontName(String fontName) {
        int consoleFontSize = this.getConsoleFontSize();
        this.myConsoleFontPreferences.clear();
        this.myConsoleFontPreferences.register(fontName, consoleFontSize);
    }

    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstance();
        if ((uiSettings == null || !uiSettings.PRESENTATION_MODE) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    public void setConsoleFontSize(int fontSize) {
        this.myConsoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    public float getConsoleLineSpacing() {
        float consoleLineSpacing = this.myConsoleLineSpacing;
        if (consoleLineSpacing == -1.0f) {
            return this.getLineSpacing();
        }
        return consoleLineSpacing;
    }

    public void setConsoleLineSpacing(float lineSpacing) {
        this.myConsoleLineSpacing = lineSpacing;
    }

    protected TextAttributes getFallbackAttributes(TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            return null;
        }
        TextAttributes fallbackAttributes = this.getDirectlyDefinedAttributes(fallbackKey);
        if (!(fallbackAttributes == null || fallbackAttributes.isFallbackEnabled() && fallbackKey.getFallbackAttributeKey() != null)) {
            return fallbackAttributes;
        }
        return this.getFallbackAttributes(fallbackKey.getFallbackAttributeKey());
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDirectlyDefinedAttributes"));
        }
        TextAttributes attributes = this.myAttributesMap.get(key);
        if (attributes != null) {
            return attributes;
        }
        return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
    }

    protected static boolean containsValue(@Nullable TextAttributes attributes) {
        return attributes != null && attributes.containsValue();
    }
}

