/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483645)
public class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ContentRootDataService.class.getName()));

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        Key key = ProjectKeys.CONTENT_ROOT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.MODULE);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, (Collection)entry.getValue(), module);
        }
    }

    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<DataNode<ContentRootData>> data, @NotNull Module module) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "importData"));
        }
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap contentEntriesMap = ContainerUtilRt.newHashMap();
        for (ContentEntry contentEntry : contentEntries) {
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
        }
        boolean createEmptyContentRootDirectories = false;
        if (!data.isEmpty()) {
            ProjectSystemId projectSystemId = ((ContentRootData)data.iterator().next().getData()).getOwner();
            AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)module.getProject(), (ProjectSystemId)projectSystemId);
            String path = module.getOptionValue("external.root.project.path");
            if (path != null) {
                ExternalProjectSettings projectSettings = externalSystemSettings.getLinkedProjectSettings(path);
                createEmptyContentRootDirectories = projectSettings != null && projectSettings.isCreateEmptyContentRootDirectories();
            }
        }
        for (DataNode<ContentRootData> node : data) {
            ContentRootData contentRoot = (ContentRootData)node.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            contentEntry.clearSourceFolders();
            LOG.debug(String.format("Importing content root '%s' for module '%s'", contentRoot.getRootPath(), module.getName()));
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.SOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module.getName(), JavaSourceRootType.SOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module.getName(), JavaSourceRootType.TEST_SOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.RESOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module.getName(), JavaResourceRootType.RESOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST_RESOURCE)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module.getName(), JavaResourceRootType.TEST_RESOURCE, false, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.SOURCE_GENERATED)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module.getName(), JavaSourceRootType.SOURCE, true, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.TEST_GENERATED)) {
                ContentRootDataService.createSourceRootIfAbsent(contentEntry, path, module.getName(), JavaSourceRootType.TEST_SOURCE, true, createEmptyContentRootDirectories);
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module.getName(), module.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
        }
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file = entry.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(path)) continue;
            ContentEntry contentEntry = entry;
            if (contentEntry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
            }
            return contentEntry;
        }
        ContentEntry contentEntry = model.addContentEntry(ContentRootDataService.toVfsUrl(path));
        if (contentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "findOrCreateContentRoot"));
        }
        return contentEntry;
    }

    private static void createSourceRootIfAbsent(@NotNull ContentEntry entry, final @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean generated, boolean createEmptyContentRootDirectories) {
        JavaSourceRootProperties properties;
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        if (sourceRootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRootType", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createSourceRootIfAbsent"));
        }
        List folders = entry.getSourceFolders(sourceRootType);
        for (SourceFolder folder : folders) {
            VirtualFile file = folder.getFile();
            if (file == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(root.getPath())) continue;
            return;
        }
        LOG.debug(String.format("Importing %s for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        SourceFolder sourceFolder = entry.addSourceFolder(ContentRootDataService.toVfsUrl(root.getPath()), sourceRootType);
        if (!StringUtil.isEmpty((String)root.getPackagePrefix())) {
            sourceFolder.setPackagePrefix(root.getPackagePrefix());
        }
        if (generated && (properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null) {
            properties.setForGeneratedSources(true);
        }
        if (createEmptyContentRootDirectories) {
            ExternalSystemApiUtil.doWriteAction((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        VfsUtil.createDirectoryIfMissing((String)root.getPath());
                    }
                    catch (IOException e) {
                        LOG.warn(String.format("Unable to create directory for the path: %s", root.getPath()), (Throwable)e);
                    }
                }
            });
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createExcludedRootIfAbsent"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createExcludedRootIfAbsent"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createExcludedRootIfAbsent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "createExcludedRootIfAbsent"));
        }
        String rootPath = root.getPath();
        for (VirtualFile file : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file).equals(rootPath)) continue;
            return;
        }
        LOG.debug(String.format("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName));
        entry.addExcludeFolder(ContentRootDataService.toVfsUrl(rootPath));
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            ChangeListManager.getInstance((Project)project).addDirectoryToIgnoreImplicitly(rootPath);
        }
    }

    private static String toVfsUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/service/project/manage/ContentRootDataService", "toVfsUrl"));
        }
        return "file://" + path;
    }
}

