/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483645)
public class LibraryDependencyDataService
extends AbstractDependencyDataService<LibraryDependencyData, LibraryOrderEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + LibraryDependencyDataService.class.getName()));
    @NotNull
    private final LibraryDataService myLibraryManager;

    public LibraryDependencyDataService(@NotNull LibraryDataService libraryManager) {
        if (libraryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryManager", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "<init>"));
        }
        this.myLibraryManager = libraryManager;
    }

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryDependencyData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.MODULE);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't import library dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry.getValue(), entry.getKey()));
                continue;
            }
            this.importData((Collection)entry.getValue(), module, modelsProvider);
        }
    }

    @Override
    @NotNull
    public Class<LibraryOrderEntry> getOrderEntryType() {
        if (LibraryOrderEntry.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "getOrderEntryType"));
        }
        return LibraryOrderEntry.class;
    }

    @Override
    protected String getOrderEntryName(@NotNull LibraryOrderEntry orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "getOrderEntryName"));
        }
        return orderEntry.getLibraryName();
    }

    private void importData(@NotNull Collection<DataNode<LibraryDependencyData>> nodesToImport, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (nodesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodesToImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        HashMap moduleLibrariesToImport = ContainerUtilRt.newHashMap();
        HashMap projectLibrariesToImport = ContainerUtilRt.newHashMap();
        LinkedHashSet toImport = ContainerUtilRt.newLinkedHashSet();
        boolean hasUnresolved = false;
        for (DataNode<LibraryDependencyData> dependencyNode : nodesToImport) {
            LibraryDependencyData dependencyData = (LibraryDependencyData)dependencyNode.getData();
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            hasUnresolved |= libraryData.isUnresolved();
            switch (dependencyData.getLevel()) {
                case MODULE: {
                    if (libraryData.isUnresolved()) break;
                    HashSet paths = ContainerUtilRt.newHashSet();
                    for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
                        paths.add(ExternalSystemApiUtil.toCanonicalPath((String)path) + dependencyData.getScope().name());
                    }
                    moduleLibrariesToImport.put(paths, dependencyData);
                    toImport.add(dependencyData);
                    break;
                }
                case PROJECT: {
                    projectLibrariesToImport.put(libraryData.getInternalName() + dependencyData.getScope().name(), dependencyData);
                    toImport.add(dependencyData);
                }
            }
        }
        boolean finalHasUnresolved = hasUnresolved;
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        LibraryTable moduleLibraryTable = modifiableRootModel.getModuleLibraryTable();
        this.syncExistingAndRemoveObsolete(modelsProvider, moduleLibrariesToImport, projectLibrariesToImport, toImport, modifiableRootModel, finalHasUnresolved);
        if (!toImport.isEmpty()) {
            this.importMissing(modelsProvider, toImport, modifiableRootModel, moduleLibraryTable, module);
        }
    }

    private void importMissing(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Set<LibraryDependencyData> toImport, @NotNull ModifiableRootModel moduleRootModel, @NotNull LibraryTable moduleLibraryTable, @NotNull Module module) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (moduleRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootModel", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (moduleLibraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleLibraryTable", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        for (LibraryDependencyData dependencyData : toImport) {
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            String libraryName = libraryData.getInternalName();
            switch (dependencyData.getLevel()) {
                case MODULE: {
                    Library moduleLib = moduleLibraryTable.createLibrary(libraryName);
                    this.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLib, moduleRootModel, module);
                    break;
                }
                case PROJECT: {
                    Library projectLib = modelsProvider.getLibraryByName(libraryName);
                    if (projectLib == null) {
                        this.syncExistingLibraryDependency(modelsProvider, dependencyData, moduleLibraryTable.createLibrary(libraryName), moduleRootModel, module);
                        break;
                    }
                    LibraryOrderEntry orderEntry = moduleRootModel.addLibraryEntry(projectLib);
                    LibraryDependencyDataService.setLibraryScope(orderEntry, projectLib, module, dependencyData);
                }
            }
        }
    }

    private static void setLibraryScope(@NotNull LibraryOrderEntry orderEntry, @NotNull Library lib, @NotNull Module module, @NotNull LibraryDependencyData dependencyData) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        if (lib == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lib", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        if (dependencyData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyData", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        LOG.debug(String.format("Adding library dependency '%s' to module '%s'", lib.getName(), module.getName()));
        orderEntry.setExported(dependencyData.isExported());
        orderEntry.setScope(dependencyData.getScope());
        LOG.debug(String.format("Configuring library dependency '%s' of module '%s' to be%s exported and have scope %s", lib.getName(), module.getName(), dependencyData.isExported() ? " not" : "", dependencyData.getScope()));
    }

    private void syncExistingAndRemoveObsolete(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<Set<String>, LibraryDependencyData> moduleLibrariesToImport, @NotNull Map<String, LibraryDependencyData> projectLibrariesToImport, @NotNull Set<LibraryDependencyData> toImport, @NotNull ModifiableRootModel moduleRootModel, boolean hasUnresolvedLibraries) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingAndRemoveObsolete"));
        }
        if (moduleLibrariesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleLibrariesToImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingAndRemoveObsolete"));
        }
        if (projectLibrariesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLibrariesToImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingAndRemoveObsolete"));
        }
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingAndRemoveObsolete"));
        }
        if (moduleRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootModel", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingAndRemoveObsolete"));
        }
        HashSet moduleLibraryKey = ContainerUtilRt.newHashSet();
        for (OrderEntry entry : moduleRootModel.getOrderEntries()) {
            LibraryDependencyData existing;
            if (entry instanceof ModuleLibraryOrderEntryImpl) {
                ModuleLibraryOrderEntryImpl moduleLibraryOrderEntry = (ModuleLibraryOrderEntryImpl)entry;
                Library library = moduleLibraryOrderEntry.getLibrary();
                if (library == null) {
                    LOG.warn("Skipping module-level library entry because it doesn't have backing Library object. Entry: " + entry);
                    continue;
                }
                moduleLibraryKey.clear();
                for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                    moduleLibraryKey.add(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file) + moduleLibraryOrderEntry.getScope().name());
                }
                existing = moduleLibrariesToImport.remove(moduleLibraryKey);
                if (existing == null) {
                    moduleRootModel.removeOrderEntry(entry);
                    continue;
                }
                this.syncExistingLibraryDependency(modelsProvider, existing, library, moduleRootModel, moduleLibraryOrderEntry.getOwnerModule());
                toImport.remove(existing);
                continue;
            }
            if (!(entry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            String libraryName = libraryOrderEntry.getLibraryName();
            existing = projectLibrariesToImport.remove(libraryName + libraryOrderEntry.getScope().name());
            if (existing != null) {
                toImport.remove(existing);
                continue;
            }
            if (hasUnresolvedLibraries) continue;
            moduleRootModel.removeOrderEntry(entry);
        }
    }

    private void syncExistingLibraryDependency(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependencyData libraryDependencyData, @NotNull Library library, @NotNull ModifiableRootModel moduleRootModel, @NotNull Module module) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingLibraryDependency"));
        }
        if (libraryDependencyData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDependencyData", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingLibraryDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingLibraryDependency"));
        }
        if (moduleRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootModel", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingLibraryDependency"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "syncExistingLibraryDependency"));
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        String libraryName = libraryDependencyData.getInternalName();
        Map<OrderRootType, Collection<File>> files = this.myLibraryManager.prepareLibraryFiles((LibraryData)libraryDependencyData.getTarget());
        this.myLibraryManager.registerPaths(files, libraryModel, libraryName);
        LibraryOrderEntry orderEntry = moduleRootModel.findLibraryOrderEntry(library);
        assert (orderEntry != null);
        LibraryDependencyDataService.setLibraryScope(orderEntry, library, module, libraryDependencyData);
    }
}

