/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import java.awt.Image;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockableEditorTabbedContainer
implements DockContainer.Persistent {
    private final EditorsSplitters mySplitters;
    private final Project myProject;
    private final CopyOnWriteArraySet<DockContainer.Listener> myListeners = new CopyOnWriteArraySet();
    private JBTabs myCurrentOver;
    private Image myCurrentOverImg;
    private TabInfo myCurrentOverInfo;
    private boolean myDisposeWhenEmpty;
    private boolean myWasEverShown;

    DockableEditorTabbedContainer(Project project) {
        this(project, null, true);
    }

    DockableEditorTabbedContainer(Project project, @Nullable EditorsSplitters splitters, boolean disposeWhenEmpty) {
        this.myProject = project;
        this.mySplitters = splitters;
        this.myDisposeWhenEmpty = disposeWhenEmpty;
    }

    public String getDockContainerType() {
        return "file-editors";
    }

    public Element getState() {
        Element editors = new Element("state");
        this.mySplitters.writeExternal(editors);
        return editors;
    }

    void fireContentClosed(VirtualFile file) {
        for (DockContainer.Listener each : this.myListeners) {
            each.contentRemoved((Object)file);
        }
    }

    void fireContentOpen(VirtualFile file) {
        for (DockContainer.Listener each : this.myListeners) {
            each.contentAdded((Object)file);
        }
    }

    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle((JComponent)((Object)this.mySplitters));
    }

    public RelativeRectangle getAcceptAreaFallback() {
        JRootPane root = this.mySplitters.getRootPane();
        return root != null ? new RelativeRectangle((JComponent)root) : new RelativeRectangle((JComponent)((Object)this.mySplitters));
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer", "getContentResponse"));
        }
        DockContainer.ContentResponse contentResponse = this.getTabsAt(content, point) != null ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        if (contentResponse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer", "getContentResponse"));
        }
        return contentResponse;
    }

    @Nullable
    private JBTabs getTabsAt(DockableContent content, RelativePoint point) {
        if (content instanceof EditorTabbedContainer.DockableEditor) {
            JBTabs targetTabs = this.mySplitters.getTabsAt(point);
            if (targetTabs != null) {
                return targetTabs;
            }
            EditorWindow wnd = this.mySplitters.getCurrentWindow();
            if (wnd != null) {
                EditorTabbedContainer tabs = wnd.getTabbedPane();
                if (tabs != null) {
                    return tabs.getTabs();
                }
            } else {
                EditorWindow[] windows;
                for (EditorWindow each : windows = this.mySplitters.getWindows()) {
                    if (each.getTabbedPane() == null || each.getTabbedPane().getTabs() == null) continue;
                    return each.getTabbedPane().getTabs();
                }
            }
        }
        return null;
    }

    public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
        DataProvider provider;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer", "add"));
        }
        EditorWindow window = null;
        if (this.myCurrentOver != null && (provider = this.myCurrentOver.getDataProvider()) != null) {
            window = (EditorWindow)EditorWindow.DATA_KEY.getData(provider);
        }
        EditorTabbedContainer.DockableEditor dockableEditor = (EditorTabbedContainer.DockableEditor)content;
        VirtualFile file = dockableEditor.getFile();
        if (window == null || window.isDisposed()) {
            window = this.mySplitters.getOrCreateCurrentWindow(file);
        }
        if (this.myCurrentOver != null) {
            int index = ((JBTabsImpl)this.myCurrentOver).getDropInfoIndex();
            file.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)index);
        }
        ((FileEditorManagerImpl)FileEditorManagerEx.getInstanceEx(this.myProject)).openFileImpl2(window, file, true);
        window.setFilePinned(file, dockableEditor.isPinned());
    }

    public Image startDropOver(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer", "startDropOver"));
        }
        return null;
    }

    public Image processDropOver(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer", "processDropOver"));
        }
        JBTabs current = this.getTabsAt(content, point);
        if (this.myCurrentOver != null && this.myCurrentOver != current) {
            this.resetDropOver(content);
        }
        if (this.myCurrentOver == null && current != null) {
            this.myCurrentOver = current;
            Presentation presentation = content.getPresentation();
            this.myCurrentOverInfo = new TabInfo((JComponent)new JLabel("")).setText(presentation.getText()).setIcon(presentation.getIcon());
            this.myCurrentOverImg = this.myCurrentOver.startDropOver(this.myCurrentOverInfo, point);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.processDropOver(this.myCurrentOverInfo, point);
        }
        return this.myCurrentOverImg;
    }

    public void resetDropOver(@NotNull DockableContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/DockableEditorTabbedContainer", "resetDropOver"));
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.resetDropOver(this.myCurrentOverInfo);
            this.myCurrentOver = null;
            this.myCurrentOverInfo = null;
            this.myCurrentOverImg = null;
        }
    }

    public JComponent getContainerComponent() {
        return this.mySplitters;
    }

    public EditorsSplitters getSplitters() {
        return this.mySplitters;
    }

    public void close(VirtualFile file) {
        this.mySplitters.closeFile(file, false);
    }

    public void closeAll() {
        VirtualFile[] files;
        for (VirtualFile each : files = this.mySplitters.getOpenFiles()) {
            this.close(each);
        }
    }

    public void addListener(final DockContainer.Listener listener, Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                DockableEditorTabbedContainer.this.myListeners.remove(listener);
            }
        });
    }

    public boolean isEmpty() {
        return this.mySplitters.isEmptyVisible();
    }

    public void dispose() {
        this.closeAll();
    }

    public boolean isDisposeWhenEmpty() {
        return this.myDisposeWhenEmpty;
    }

    public void showNotify() {
        if (!this.myWasEverShown) {
            this.myWasEverShown = true;
            this.getSplitters().openFiles();
        }
    }

    public void hideNotify() {
    }
}

