/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class IgnoredFileCache {
    private final ConcurrentBitSet myCheckedIds;
    private final ConcurrentIntObjectMap<Object> myIgnoredIds;
    private final IgnoredPatternSet myIgnoredPatterns;
    private volatile int myVfsEventNesting;

    IgnoredFileCache(@NotNull IgnoredPatternSet ignoredPatterns) {
        if (ignoredPatterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredPatterns", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache", "<init>"));
        }
        this.myCheckedIds = new ConcurrentBitSet();
        this.myIgnoredIds = ContainerUtil.createConcurrentIntObjectMap();
        this.myVfsEventNesting = 0;
        this.myIgnoredPatterns = ignoredPatterns;
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
        connect.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "before"));
                }
                IgnoredFileCache.this.myVfsEventNesting++;
                this.clearCacheForChangedFiles(events);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "after"));
                }
                this.clearCacheForChangedFiles(events);
                IgnoredFileCache.this.myVfsEventNesting--;
            }

            private void clearCacheForChangedFiles(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache$1", "clearCacheForChangedFiles"));
                }
                for (VFileEvent vFileEvent : events) {
                    int id;
                    VirtualFile file = vFileEvent.getFile();
                    if (!(file instanceof NewVirtualFile) || !(vFileEvent instanceof VFilePropertyChangeEvent) || (id = ((NewVirtualFile)file).getId()) < 0) continue;
                    IgnoredFileCache.this.myCheckedIds.clear(id);
                    IgnoredFileCache.this.myIgnoredIds.remove(id);
                }
            }
        });
    }

    void clearCache() {
        this.myCheckedIds.clear();
        this.myIgnoredIds.clear();
    }

    boolean isFileIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache", "isFileIgnored"));
        }
        if (this.myVfsEventNesting != 0 || !(file instanceof NewVirtualFile)) {
            return this.isFileIgnoredNoCache(file);
        }
        int id = ((NewVirtualFile)file).getId();
        if (id < 0) {
            return this.isFileIgnoredNoCache(file);
        }
        ConcurrentBitSet checkedIds = this.myCheckedIds;
        if (checkedIds.get(id)) {
            return this.myIgnoredIds.containsKey(id);
        }
        boolean result2 = this.isFileIgnoredNoCache(file);
        if (result2) {
            this.myIgnoredIds.put(id, (Object)Boolean.TRUE);
        } else {
            this.myIgnoredIds.remove(id);
        }
        checkedIds.set(id);
        return result2;
    }

    private boolean isFileIgnoredNoCache(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/impl/IgnoredFileCache", "isFileIgnoredNoCache"));
        }
        return this.myIgnoredPatterns.isIgnored(file.getName());
    }
}

