/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.jrt.JrtFileSystem;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;

public class JavaSdkImpl
extends JavaSdk {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.JavaSdkImpl");
    public static final DataKey<Boolean> KEY = DataKey.create((String)"JavaSdk");
    private static final String VM_EXE_NAME = "java";
    private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("^(.*)java version \"([1234567890_.]*)\"(.*)$");
    private static final String JAVA_VERSION_PREFIX = "java version ";
    private static final String OPENJDK_VERSION_PREFIX = "openjdk version ";
    private final Map<String, String> myCachedVersionStrings = Collections.synchronizedMap(new HashMap());

    public JavaSdkImpl(VirtualFileManager fileManager, final FileTypeManager fileTypeManager) {
        super("JavaSDK");
        fileManager.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1", "fileDeleted"));
                }
                this.updateCache(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1", "contentsChanged"));
                }
                this.updateCache(event);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1", "fileCreated"));
                }
                this.updateCache(event);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateCache(VirtualFileEvent event) {
                VirtualFile file = event.getFile();
                if (FileTypes.ARCHIVE.equals(fileTypeManager.getFileTypeByFileName(event.getFileName()))) {
                    String filePath = file.getPath();
                    Map map = JavaSdkImpl.this.myCachedVersionStrings;
                    synchronized (map) {
                        for (String sdkHome : JavaSdkImpl.this.myCachedVersionStrings.keySet()) {
                            if (!FileUtil.isAncestor((String)sdkHome, (String)filePath, (boolean)false)) continue;
                            JavaSdkImpl.this.myCachedVersionStrings.remove(sdkHome);
                            break;
                        }
                    }
                }
            }
        });
    }

    public String getPresentableName() {
        return ProjectBundle.message((String)"sdk.java.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.PpJdk;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.java" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getHelpTopic"));
        }
        return "reference.project.structure.sdk.java";
    }

    public Icon getIconForAddAction() {
        return AllIcons.General.AddJdk;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getDefaultDocumentationUrl"));
        }
        JavaSdkVersion version = this.getVersion(sdk);
        if (version == JavaSdkVersion.JDK_1_5) {
            return "http://docs.oracle.com/javase/1.5.0/docs/api/";
        }
        if (version == JavaSdkVersion.JDK_1_6) {
            return "http://docs.oracle.com/javase/6/docs/api/";
        }
        if (version == JavaSdkVersion.JDK_1_7) {
            return "http://docs.oracle.com/javase/7/docs/api/";
        }
        if (version == JavaSdkVersion.JDK_1_8) {
            return "http://docs.oracle.com/javase/8/docs/api";
        }
        return null;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "saveAdditionalData"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "saveAdditionalData"));
        }
    }

    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getBinPath"));
        }
        return JavaSdkImpl.getConvertedHomePath(sdk) + "bin";
    }

    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getToolsPath"));
        }
        String versionString = sdk.getVersionString();
        boolean isJdk1_x = versionString != null && (versionString.contains("1.0") || versionString.contains("1.1"));
        return JavaSdkImpl.getConvertedHomePath(sdk) + "lib" + File.separator + (isJdk1_x ? "classes.zip" : "tools.jar");
    }

    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVMExecutablePath"));
        }
        return this.getBinPath(sdk) + File.separator + VM_EXE_NAME;
    }

    private static String getConvertedHomePath(Sdk sdk) {
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        String path = FileUtil.toSystemDependentName((String)homePath);
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public String suggestHomePath() {
        String home;
        if (SystemInfo.isMac) {
            String path;
            if (new File("/usr/libexec/java_home").canExecute() && (path = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"/usr/libexec/java_home"}))) != null && new File(path).isDirectory()) {
                return path;
            }
            home = JavaSdkImpl.checkKnownLocations("/Library/Java/JavaVirtualMachines", "/System/Library/Java/JavaVirtualMachines");
            if (home != null) {
                return home;
            }
        }
        if (SystemInfo.isLinux && (home = JavaSdkImpl.checkKnownLocations("/usr/java", "/opt/java", "/usr/lib/jvm")) != null) {
            return home;
        }
        if (SystemInfo.isSolaris && (home = JavaSdkImpl.checkKnownLocations("/usr/jdk")) != null) {
            return home;
        }
        String property = System.getProperty("java.home");
        if (property != null) {
            File javaHome = new File(property);
            if (javaHome.getName().equals("jre")) {
                javaHome = javaHome.getParentFile();
            }
            if (javaHome != null && javaHome.isDirectory()) {
                return javaHome.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    private static String checkKnownLocations(String ... locations) {
        for (String home : locations) {
            if (!new File(home).isDirectory()) continue;
            return home;
        }
        return null;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        String x86Suffix;
        boolean x86;
        File anotherJavasFolder;
        String name;
        if (!SystemInfo.isWindows) {
            List<String> list = Collections.singletonList(this.suggestHomePath());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "suggestHomePaths"));
            }
            return list;
        }
        String property = System.getProperty("java.home");
        if (property == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "suggestHomePaths"));
            }
            return list;
        }
        File javaHome = new File(property).getParentFile();
        if (javaHome == null || !javaHome.isDirectory() || javaHome.getParentFile() == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "suggestHomePaths"));
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        File javasFolder = javaHome.getParentFile();
        JavaSdkImpl.scanFolder(javasFolder, result2);
        File parentFile = javasFolder.getParentFile();
        File root = parentFile != null ? parentFile.getParentFile() : null;
        String string = name = parentFile != null ? parentFile.getName() : "";
        if (name.contains("Program Files") && root != null && (anotherJavasFolder = (x86 = name.endsWith(x86Suffix = " (x86)") && name.length() > x86Suffix.length()) ? new File(root, name.substring(0, name.length() - x86Suffix.length())) : new File(root, name + x86Suffix)).isDirectory()) {
            JavaSdkImpl.scanFolder(new File(anotherJavasFolder, javasFolder.getName()), result2);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "suggestHomePaths"));
        }
        return arrayList;
    }

    private static void scanFolder(File javasFolder, ArrayList<String> result2) {
        Object[] candidates = javasFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return JdkUtil.checkForJdk((File)pathname);
            }
        });
        if (candidates != null) {
            result2.addAll(ContainerUtil.map2List((Object[])candidates, (Function)new Function<File, String>(){

                public String fun(File file) {
                    return file.getAbsolutePath();
                }
            }));
        }
    }

    public FileChooserDescriptor getHomeChooserDescriptor() {
        final FileChooserDescriptor baseDescriptor = super.getHomeChooserDescriptor();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(baseDescriptor){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                String path;
                if (files.length > 0 && !JrtFileSystem.isSupported() && (JrtFileSystem.isModularJdk(path = files[0].getPath()) || JrtFileSystem.isModularJdk(JavaSdkImpl.this.adjustSelectedSdkHome(path)))) {
                    throw new Exception(LangBundle.message("jrt.not.available.message", new Object[0]));
                }
                baseDescriptor.validateSelectedFiles(files);
            }
        };
        descriptor.putUserData(KEY, (Object)Boolean.TRUE);
        return descriptor;
    }

    public String adjustSelectedSdkHome(String homePath) {
        if (SystemInfo.isMac) {
            File home = new File(homePath, "/Home");
            if (home.exists()) {
                return home.getPath();
            }
            home = new File(homePath, "Contents/Home");
            if (home.exists()) {
                return home.getPath();
            }
        }
        return homePath;
    }

    public boolean isValidSdkHome(String path) {
        if (!JavaSdkImpl.checkForJdk((File)new File(path))) {
            return false;
        }
        return !JrtFileSystem.isModularJdk(path) || JrtFileSystem.isSupported();
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String versionString;
        String versionString2;
        Matcher matcher;
        boolean replaceNameWithVersion;
        String suggestedName = currentSdkName != null && !currentSdkName.isEmpty() ? ((replaceNameWithVersion = (matcher = VERSION_STRING_PATTERN.matcher(currentSdkName)).matches()) ? ((versionString2 = this.getVersionString(sdkHome)) == null ? currentSdkName : matcher.replaceFirst("$1" + versionString2 + "$3")) : currentSdkName) : ((versionString = this.getVersionString(sdkHome)) == null ? ProjectBundle.message((String)"sdk.java.unknown.name", (Object[])new Object[0]) : JavaSdkImpl.getVersionNumber(versionString));
        return suggestedName;
    }

    @NotNull
    private static String getVersionNumber(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersionNumber"));
        }
        if (versionString.startsWith(JAVA_VERSION_PREFIX) || versionString.startsWith(OPENJDK_VERSION_PREFIX)) {
            int dotIdx;
            boolean openJdk = versionString.startsWith(OPENJDK_VERSION_PREFIX);
            if ((versionString = versionString.substring(openJdk ? OPENJDK_VERSION_PREFIX.length() : JAVA_VERSION_PREFIX.length())).startsWith("\"") && versionString.endsWith("\"")) {
                versionString = versionString.substring(1, versionString.length() - 1);
            }
            if ((dotIdx = versionString.indexOf(46)) > 0) {
                try {
                    int major = Integer.parseInt(versionString.substring(0, dotIdx));
                    int minorDot = versionString.indexOf(46, dotIdx + 1);
                    if (minorDot > 0) {
                        int minor = Integer.parseInt(versionString.substring(dotIdx + 1, minorDot));
                        versionString = major + "." + minor;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String string = versionString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersionNumber"));
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        VirtualFile javaFxSources;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "setupSdkPaths"));
        }
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        File jdkHome = new File(homePath);
        List<VirtualFile> classes = JavaSdkImpl.findClasses(jdkHome, false);
        VirtualFile sources = JavaSdkImpl.findSources(jdkHome);
        VirtualFile docs = JavaSdkImpl.findDocs(jdkHome, "docs/api");
        SdkModificator sdkModificator = sdk.getSdkModificator();
        LinkedHashSet<VirtualFile> previousRoots = new LinkedHashSet<VirtualFile>(Arrays.asList(sdkModificator.getRoots(OrderRootType.CLASSES)));
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        previousRoots.removeAll(new HashSet<VirtualFile>(classes));
        for (VirtualFile aClass : classes) {
            sdkModificator.addRoot(aClass, OrderRootType.CLASSES);
        }
        for (VirtualFile root : previousRoots) {
            sdkModificator.addRoot(root, OrderRootType.CLASSES);
        }
        if (sources != null) {
            sdkModificator.addRoot(sources, OrderRootType.SOURCES);
        }
        if ((javaFxSources = JavaSdkImpl.findSources(jdkHome, "javafx-src")) != null) {
            sdkModificator.addRoot(javaFxSources, OrderRootType.SOURCES);
        }
        if (docs != null) {
            sdkModificator.addRoot(docs, JavadocOrderRootType.getInstance());
        } else if (SystemInfo.isMac) {
            String url;
            VirtualFile appleDocs;
            VirtualFile commonDocs = JavaSdkImpl.findDocs(jdkHome, "docs");
            if (commonDocs == null && (commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "doc/api")) == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "docs/api");
            }
            if (commonDocs != null) {
                sdkModificator.addRoot(commonDocs, JavadocOrderRootType.getInstance());
            }
            if ((appleDocs = JavaSdkImpl.findDocs(jdkHome, "appledocs")) == null) {
                appleDocs = JavaSdkImpl.findInJar(new File(jdkHome, "appledocs.jar"), "appledoc/api");
            }
            if (appleDocs != null) {
                sdkModificator.addRoot(appleDocs, JavadocOrderRootType.getInstance());
            }
            if (commonDocs == null && appleDocs == null && sources == null && (url = this.getDefaultDocumentationUrl(sdk)) != null) {
                sdkModificator.addRoot(VirtualFileManager.getInstance().findFileByUrl(url), JavadocOrderRootType.getInstance());
            }
        } else if (this.getVersion(sdk) == JavaSdkVersion.JDK_1_7) {
            VirtualFile url = VirtualFileManager.getInstance().findFileByUrl("http://docs.oracle.com/javafx/2/api/");
            sdkModificator.addRoot(url, JavadocOrderRootType.getInstance());
        }
        JavaSdkImpl.attachJdkAnnotations(sdkModificator);
        sdkModificator.commitChanges();
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        if (modificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modificator", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "attachJdkAnnotations"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile root = lfs.findFileByPath(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/java/jdkAnnotations");
        if (root == null) {
            root = lfs.findFileByPath(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/community/java/jdkAnnotations");
        }
        if (root == null) {
            root = VirtualFileManager.getInstance().findFileByUrl("jar://" + FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar!/");
        }
        if (root == null) {
            LOG.error("jdk annotations not found in: " + FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar!/");
            return;
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        modificator.removeRoot(root, annoType);
        modificator.addRoot(root, annoType);
    }

    public final String getVersionString(String sdkHome) {
        String versionString = this.myCachedVersionStrings.get(sdkHome);
        if (versionString == null && !StringUtil.isEmpty((String)(versionString = JavaSdkImpl.getJdkVersion((String)sdkHome)))) {
            this.myCachedVersionStrings.put(sdkHome, versionString);
        }
        return versionString;
    }

    public int compareTo(@NotNull String versionString, @NotNull String versionNumber) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "compareTo"));
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionNumber", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "compareTo"));
        }
        return JavaSdkImpl.getVersionNumber(versionString).compareTo(versionNumber);
    }

    public JavaSdkVersion getVersion(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersion"));
        }
        String version = sdk.getVersionString();
        if (version == null) {
            return null;
        }
        return JdkVersionUtil.getVersion((String)version);
    }

    @Nullable
    public JavaSdkVersion getVersion(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "getVersion"));
        }
        return JdkVersionUtil.getVersion((String)versionString);
    }

    public boolean isOfVersionOrHigher(@NotNull Sdk sdk, @NotNull JavaSdkVersion version) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "isOfVersionOrHigher"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "isOfVersionOrHigher"));
        }
        JavaSdkVersion sdkVersion = this.getVersion(sdk);
        return sdkVersion != null && sdkVersion.isAtLeast(version);
    }

    @NotNull
    public Sdk createJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        if (jdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkName", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createJdk"));
        }
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createJdk"));
        }
        ProjectJdkImpl jdk = new ProjectJdkImpl(jdkName, (SdkTypeId)this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        String path = home.replace(File.separatorChar, '/');
        sdkModificator.setHomePath(path);
        sdkModificator.setVersionString(jdkName);
        File jdkHomeFile = new File(home);
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        JavaSdkImpl.addDocs(jdkHomeFile, sdkModificator);
        sdkModificator.commitChanges();
        ProjectJdkImpl projectJdkImpl = jdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl", "createJdk"));
        }
        return projectJdkImpl;
    }

    private static void addClasses(File file, SdkModificator sdkModificator, boolean isJre) {
        for (VirtualFile virtualFile : JavaSdkImpl.findClasses(file, isJre)) {
            sdkModificator.addRoot(virtualFile, OrderRootType.CLASSES);
        }
    }

    private static List<VirtualFile> findClasses(File file, boolean isJre) {
        List roots = JavaSdkUtil.getJdkClassesRoots((File)file, (boolean)isJre);
        ArrayList urls = ContainerUtil.newArrayListWithCapacity((int)(roots.size() + 1));
        if (JrtFileSystem.isModularJdk(file.getPath())) {
            urls.add(VirtualFileManager.constructUrl((String)"jrt", (String)(FileUtil.toSystemIndependentName((String)file.getPath()) + "!/")));
        }
        for (File root : roots) {
            urls.add(VfsUtil.getUrlForLibraryRoot((File)root));
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)urls.size());
        for (String url : urls) {
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile == null) continue;
            result2.add(vFile);
        }
        Collections.sort(result2, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return result2;
    }

    private static void addSources(File file, SdkModificator sdkModificator) {
        VirtualFile vFile = JavaSdkImpl.findSources(file);
        if (vFile != null) {
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    @Nullable
    public static VirtualFile findSources(File file) {
        return JavaSdkImpl.findSources(file, "src");
    }

    @Nullable
    public static VirtualFile findSources(File file, String srcName) {
        File srcDir = new File(file, "src");
        File jarFile = new File(file, srcName + ".jar");
        if (!jarFile.exists()) {
            jarFile = new File(file, srcName + ".zip");
        }
        if (jarFile.exists()) {
            VirtualFile vFile = JavaSdkImpl.findInJar(jarFile, "src");
            if (vFile != null) {
                return vFile;
            }
            vFile = JavaSdkImpl.findInJar(jarFile, "");
            return vFile;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return null;
        }
        String path = srcDir.getAbsolutePath().replace(File.separatorChar, '/');
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    private static void addDocs(File file, SdkModificator rootContainer) {
        VirtualFile vFile = JavaSdkImpl.findDocs(file, "docs/api");
        if (vFile != null) {
            rootContainer.addRoot(vFile, JavadocOrderRootType.getInstance());
        }
    }

    @Nullable
    private static VirtualFile findInJar(File jarFile, String relativePath) {
        if (!jarFile.exists()) {
            return null;
        }
        String url = "jar://" + jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/" + relativePath;
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Nullable
    public static VirtualFile findDocs(File file, String relativePath) {
        if (!(file = new File(file.getAbsolutePath() + File.separator + relativePath.replace('/', File.separatorChar))).exists() || !file.isDirectory()) {
            return null;
        }
        String path = file.getAbsolutePath().replace(File.separatorChar, '/');
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    public boolean isRootTypeApplicable(OrderRootType type) {
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }
}

