/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.TableItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class AnnotationsEditor
extends ModuleElementsEditor {
    private JTable myTable;
    public static final String NAME = ProjectBundle.message((String)"project.roots.external.annotations.tab.title", (Object[])new Object[0]);

    public AnnotationsEditor(ModuleConfigurationState state) {
        super(state);
    }

    public String getHelpTopic() {
        return "project.paths.annotations";
    }

    public String getDisplayName() {
        return NAME;
    }

    public void saveData() {
        TableUtil.stopEditing((JTable)this.myTable);
        int count = this.myTable.getRowCount();
        String[] urls = ArrayUtil.newStringArray((int)count);
        for (int row = 0; row < count; ++row) {
            TableItem item = ((MyTableModel)this.myTable.getModel()).getTableItemAt(row);
            urls[row] = item.getUrl();
        }
        ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).setExternalAnnotationUrls(urls);
    }

    @Override
    public JComponent createComponentImpl() {
        DefaultTableModel tableModel = this.createModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setDefaultRenderer(TableItem.class, (TableCellRenderer)((Object)new MyRenderer()));
        this.myTable.setShowGrid(false);
        this.myTable.setDragEnabled(false);
        this.myTable.setShowHorizontalLines(false);
        this.myTable.setShowVerticalLines(false);
        this.myTable.getSelectionModel().setSelectionMode(2);
        JPanel tablePanel = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor myDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                myDescriptor.setTitle(ProjectBundle.message((String)"add.external.annotations.path.title", (Object[])new Object[0]));
                myDescriptor.setDescription(ProjectBundle.message((String)"add.external.annotations.path.description", (Object[])new Object[0]));
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)myDescriptor, (Component)AnnotationsEditor.this.myTable, (Project)AnnotationsEditor.this.myProject, null);
                MyTableModel tableModel = (MyTableModel)AnnotationsEditor.this.myTable.getModel();
                boolean changes = false;
                for (VirtualFile file : files) {
                    if (file == null) continue;
                    tableModel.addTableItem(new TableItem(file));
                    changes = true;
                }
                if (changes) {
                    AnnotationsEditor.this.saveData();
                    TableUtil.selectRows((JTable)AnnotationsEditor.this.myTable, (int[])new int[]{tableModel.getRowCount() - 1});
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List removedItems = TableUtil.removeSelectedItems((JTable)AnnotationsEditor.this.myTable);
                if (removedItems.size() > 0) {
                    AnnotationsEditor.this.saveData();
                }
            }
        }).createPanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)tablePanel, "Center");
        mainPanel.add((Component)new JBLabel(ProjectBundle.message((String)"project.roots.external.annotations.description", (Object[])new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), "North");
        return mainPanel;
    }

    protected DefaultTableModel createModel() {
        String[] urls;
        MyTableModel tableModel = new MyTableModel();
        for (String javadocUrl : urls = ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).getExternalAnnotationsUrls()) {
            tableModel.addTableItem(new TableItem(javadocUrl));
        }
        return tableModel;
    }

    @Override
    public void moduleStateChanged() {
        if (this.myTable != null) {
            DefaultTableModel tableModel = this.createModel();
            this.myTable.setModel(tableModel);
        }
    }

    private static class MyTableModel
    extends DefaultTableModel
    implements ItemRemovable {
        private MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            return TableItem.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public TableItem getTableItemAt(int row) {
            return (TableItem)this.getValueAt(row, 0);
        }

        public void addTableItem(TableItem item) {
            this.addRow(new Object[]{item});
        }
    }

    private static class MyRenderer
    extends ColoredTableCellRenderer {
        private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private MyRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(NO_FOCUS_BORDER);
            TableItem tableItem = (TableItem)value;
            tableItem.getCellAppearance().customize((SimpleColoredComponent)this);
        }
    }
}

