/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.CreateModuleLibraryChooser;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.util.PlatformIcons;

class AddNewModuleLibraryAction
extends AddItemPopupAction<Library> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.classpath.AddNewModuleLibraryAction");
    private final StructureConfigurableContext myContext;

    public AddNewModuleLibraryAction(ClasspathPanel classpathPanel, int actionIndex, StructureConfigurableContext context) {
        super(classpathPanel, actionIndex, ProjectBundle.message((String)"classpath.add.simple.module.library.action", (Object[])new Object[0]), PlatformIcons.JAR_ICON);
        this.myContext = context;
    }

    @Override
    protected ClasspathTableItem<?> createTableItem(Library item) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = this.myClasspathPanel.getRootModel().getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            if (!(entry instanceof LibraryOrderEntry) || !item.equals((libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary())) continue;
            return ClasspathTableItem.createLibItem(libraryOrderEntry, this.myContext);
        }
        LOG.error("Unknown library " + item);
        return null;
    }

    @Override
    protected ClasspathElementChooser<Library> createChooser() {
        LibraryTable.ModifiableModel moduleLibraryModel = this.myClasspathPanel.getRootModel().getModuleLibraryTable().getModifiableModel();
        return new CreateModuleLibraryChooser(this.myClasspathPanel, moduleLibraryModel);
    }
}

