/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowWrapperBuilder {
    @NotNull
    private final WindowWrapper.Mode myMode;
    @NotNull
    private final JComponent myComponent;
    @Nullable
    private Project myProject;
    @Nullable
    private Component myParent;
    @Nullable
    private String myTitle;
    @Nullable
    private JComponent myPreferredFocusedComponent;
    @Nullable
    private String myDimensionServiceKey;
    @Nullable
    private Runnable myOnShowCallback;

    public WindowWrapperBuilder(@NotNull WindowWrapper.Mode mode, @NotNull JComponent component) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/openapi/ui/WindowWrapperBuilder", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/WindowWrapperBuilder", "<init>"));
        }
        this.myMode = mode;
        this.myComponent = component;
    }

    @NotNull
    public WindowWrapperBuilder setProject(@Nullable Project project) {
        this.myProject = project;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "setProject"));
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setParent(@Nullable Component parent) {
        this.myParent = parent;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "setParent"));
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setTitle(@Nullable String title) {
        this.myTitle = title;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "setTitle"));
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = preferredFocusedComponent;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "setPreferredFocusedComponent"));
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setDimensionServiceKey(@Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "setDimensionServiceKey"));
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setOnShowCallback(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/ui/WindowWrapperBuilder", "setOnShowCallback"));
        }
        this.myOnShowCallback = callback;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "setOnShowCallback"));
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapper build() {
        switch (this.myMode) {
            case FRAME: {
                FrameWindowWrapper frameWindowWrapper = new FrameWindowWrapper(this);
                if (frameWindowWrapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "build"));
                }
                return frameWindowWrapper;
            }
            case MODAL: 
            case NON_MODAL: {
                DialogWindowWrapper dialogWindowWrapper = new DialogWindowWrapper(this);
                if (dialogWindowWrapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder", "build"));
                }
                return dialogWindowWrapper;
            }
        }
        throw new IllegalArgumentException(this.myMode.toString());
    }

    private static class FrameWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @Nullable
        private final Runnable myOnShowCallback;
        @NotNull
        private final FrameWrapper myFrame;

        public FrameWindowWrapper(@NotNull WindowWrapperBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper", "<init>"));
            }
            assert (builder.myMode == WindowWrapper.Mode.FRAME);
            this.myProject = builder.myProject;
            this.myComponent = builder.myComponent;
            this.myMode = builder.myMode;
            this.myOnShowCallback = builder.myOnShowCallback;
            this.myFrame = new FrameWrapper(builder.myProject, builder.myDimensionServiceKey);
            this.myFrame.setComponent(builder.myComponent);
            this.myFrame.setPreferredFocusedComponent(builder.myPreferredFocusedComponent);
            this.myFrame.setTitle(builder.myTitle);
            this.myFrame.closeOnEsc();
            Disposer.register((Disposable)this.myFrame, (Disposable)this);
        }

        public void show() {
            this.myFrame.show();
            if (this.myOnShowCallback != null) {
                this.myOnShowCallback.run();
            }
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper", "getComponent"));
            }
            return jComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            WindowWrapper.Mode mode = this.myMode;
            if (mode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper", "getMode"));
            }
            return mode;
        }

        @NotNull
        public Window getWindow() {
            Window window = this.myFrame.getFrame();
            if (window == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper", "getWindow"));
            }
            return window;
        }

        public void setTitle(@Nullable String title) {
            title = StringUtil.notNullize((String)title);
            this.myFrame.setTitle(title);
            Window window = this.getWindow();
            if (window instanceof JFrame) {
                ((JFrame)window).setTitle(title);
            }
            if (window instanceof JDialog) {
                ((JDialog)window).setTitle(title);
            }
        }

        public void setImage(@Nullable Image image) {
            this.myFrame.setImage(image);
        }

        public void close() {
            this.myFrame.close();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFrame);
        }
    }

    private static class DialogWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @NotNull
        private final MyDialogWrapper myDialog;

        public DialogWindowWrapper(@NotNull WindowWrapperBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper", "<init>"));
            }
            this.myProject = builder.myProject;
            this.myComponent = builder.myComponent;
            this.myMode = builder.myMode;
            this.myDialog = builder.myParent != null ? new MyDialogWrapper(builder.myParent, builder.myComponent) : new MyDialogWrapper(builder.myProject, builder.myComponent);
            this.myDialog.setParameters(builder.myDimensionServiceKey, builder.myPreferredFocusedComponent);
            final Runnable onShowCallback = builder.myOnShowCallback;
            if (onShowCallback != null) {
                this.myDialog.getWindow().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        onShowCallback.run();
                    }
                });
            }
            this.setTitle(builder.myTitle);
            switch (builder.myMode) {
                case MODAL: {
                    this.myDialog.setModal(true);
                    break;
                }
                case NON_MODAL: {
                    this.myDialog.setModal(false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.myDialog.init();
            Disposer.register((Disposable)this.myDialog.getDisposable(), (Disposable)this);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myDialog.getDisposable());
        }

        public void show() {
            this.myDialog.show();
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper", "getComponent"));
            }
            return jComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            WindowWrapper.Mode mode = this.myMode;
            if (mode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper", "getMode"));
            }
            return mode;
        }

        @NotNull
        public Window getWindow() {
            Window window = this.myDialog.getWindow();
            if (window == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper", "getWindow"));
            }
            return window;
        }

        public void setTitle(@Nullable String title) {
            this.myDialog.setTitle(StringUtil.notNullize((String)title));
        }

        public void setImage(@Nullable Image image) {
        }

        public void close() {
            this.myDialog.close(1);
        }

        private static class MyDialogWrapper
        extends DialogWrapper {
            @NotNull
            private JComponent myComponent;
            @Nullable
            private String myDimensionServiceKey;
            @Nullable
            private JComponent myPreferredFocusedComponent;

            public MyDialogWrapper(@Nullable Project project, @NotNull JComponent component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper$MyDialogWrapper", "<init>"));
                }
                super(project, true);
                this.myComponent = component;
            }

            public MyDialogWrapper(@NotNull Component parent, @NotNull JComponent component) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper$MyDialogWrapper", "<init>"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper$MyDialogWrapper", "<init>"));
                }
                super(parent, true);
                this.myComponent = component;
            }

            public void setParameters(@Nullable String dimensionServiceKey, @Nullable JComponent preferredFocusedComponent) {
                this.myDimensionServiceKey = dimensionServiceKey;
                this.myPreferredFocusedComponent = preferredFocusedComponent;
            }

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            protected JComponent createCenterPanel() {
                return this.myComponent;
            }

            @NotNull
            protected Action[] createActions() {
                Action[] actionArray = new Action[]{};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper$MyDialogWrapper", "createActions"));
                }
                return actionArray;
            }

            @Nullable
            protected JComponent createSouthPanel() {
                return null;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return this.myDimensionServiceKey;
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myPreferredFocusedComponent;
            }
        }
    }
}

