/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import java.io.File;
import java.io.IOException;

public class CdCommand
extends AbstractCommand {
    public static final String PREFIX = "%cd";
    private String myDir;

    public CdCommand(String text, int line) {
        super(text, line);
        this.myDir = text.substring(PREFIX.length()).trim();
    }

    @Override
    protected ActionCallback _execute(PlaybackContext context) {
        File file = context.getPathMacro().resolveFile(this.myDir, context.getBaseDir());
        if (!file.exists()) {
            context.message("Cannot cd, directory doesn't exist: " + file.getAbsoluteFile(), this.getLine());
            return ActionCallback.REJECTED;
        }
        try {
            context.setBaseDir(file.getCanonicalFile());
        }
        catch (IOException e) {
            context.setBaseDir(file);
        }
        context.message("{base.dir} set to " + context.getBaseDir().getAbsolutePath(), this.getLine());
        return ActionCallback.DONE;
    }
}

