/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.annotations.NotNull;

public class VFSForAnnotationListener
extends VirtualFileAdapter {
    private final VirtualFile myFile;
    private final FileAnnotation myFileAnnotation;

    public VFSForAnnotationListener(VirtualFile file, FileAnnotation fileAnnotation) {
        this.myFileAnnotation = fileAnnotation;
        this.myFile = file;
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/annotate/VFSForAnnotationListener", "propertyChanged"));
        }
        if (!Comparing.equal((Object)this.myFile, (Object)event.getFile())) {
            return;
        }
        if (!event.isFromRefresh()) {
            return;
        }
        if ("writable".equals(event.getPropertyName()) && ((Boolean)event.getOldValue()).booleanValue()) {
            this.myFileAnnotation.close();
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/annotate/VFSForAnnotationListener", "contentsChanged"));
        }
        if (!Comparing.equal((Object)this.myFile, (Object)event.getFile())) {
            return;
        }
        if (!event.isFromRefresh()) {
            return;
        }
        if (!this.myFile.isWritable()) {
            this.myFileAnnotation.close();
        }
    }
}

