/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import java.util.List;
import javax.swing.Icon;

public class RenameShelvedChangeListAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changes = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        ShelvedChangeList[] recycledChanges = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY);
        assert (changes != null || recycledChanges != null);
        final ShelvedChangeList changeList = changes != null && changes.length == 1 ? changes[0] : recycledChanges[0];
        String newName = Messages.showInputDialog((Project)project, (String)VcsBundle.message((String)"shelve.changes.rename.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"shelve.changes.rename.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)changeList.DESCRIPTION, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                if (inputString.length() == 0) {
                    return false;
                }
                List<ShelvedChangeList> list = ShelveChangesManager.getInstance(project).getShelvedChangeLists();
                for (ShelvedChangeList oldList : list) {
                    if (oldList == changeList || !oldList.DESCRIPTION.equals(inputString)) continue;
                    return false;
                }
                return true;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (newName != null && !newName.equals(changeList.DESCRIPTION)) {
            ShelveChangesManager.getInstance(project).renameChangeList(changeList, newName);
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changes = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        ShelvedChangeList[] recycledChanges = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY);
        e.getPresentation().setEnabled(project != null && (changes != null && changes.length == 1 || recycledChanges != null && recycledChanges.length == 1));
    }
}

