/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelveWithDialogAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        if (project == null || changeLists == null || changeLists.length != 1) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ShelvedChangeList changeList = changeLists[0];
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(changeList.PATH));
        if (virtualFile == null) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Can not find path file", MessageType.ERROR, new NamedRunnable[0]);
            return;
        }
        Object[] preselectedChanges = (Change[])e.getData(VcsDataKeys.CHANGES);
        List binaryShelvedPatches = ContainerUtil.map(changeList.getBinaryFiles(), (Function)new Function<ShelvedBinaryFile, ShelveChangesManager.ShelvedBinaryFilePatch>(){

            public ShelveChangesManager.ShelvedBinaryFilePatch fun(ShelvedBinaryFile file) {
                return new ShelveChangesManager.ShelvedBinaryFilePatch(file);
            }
        });
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.<ApplyPatchExecutor>emptyList(), ApplyPatchMode.UNSHELVE, virtualFile, null, ChangeListUtil.getPredefinedChangeList(changeList.DESCRIPTION, ChangeListManager.getInstance((Project)project)), binaryShelvedPatches, UnshelveWithDialogAction.hasNotAllSelectedChanges(project, changeList, (Change[])preselectedChanges) ? ContainerUtil.newArrayList((Object[])preselectedChanges) : null, changeList.DESCRIPTION);
        dialog.setHelpId("reference.dialogs.vcs.unshelve");
        dialog.show();
    }

    private static boolean hasNotAllSelectedChanges(@NotNull Project project, @NotNull ShelvedChangeList list, @Nullable Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "hasNotAllSelectedChanges"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/shelf/UnshelveWithDialogAction", "hasNotAllSelectedChanges"));
        }
        return changes != null && list.getChanges(project).size() + list.getBinaryFiles().size() != changes.length;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] changes = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        e.getPresentation().setEnabled(project != null && changes != null && changes.length == 1);
    }
}

