/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDiffFromHistoryHandler<T extends VcsFileRevision>
implements DiffFromHistoryHandler {
    private static final Logger LOG = Logger.getInstance(BaseDiffFromHistoryHandler.class);
    @NotNull
    protected final Project myProject;

    protected BaseDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "<init>"));
        }
        this.myProject = project;
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (previousRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousRevision", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForOne"));
        }
        this.doShowDiff(filePath, previousRevision, revision);
    }

    public void showDiffForTwo(@NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForTwo"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForTwo"));
        }
        if (older == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "older", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForTwo"));
        }
        if (newer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newer", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showDiffForTwo"));
        }
        this.doShowDiff(filePath, older, newer);
    }

    protected void doShowDiff(@NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "doShowDiff"));
        }
        if (older == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "older", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "doShowDiff"));
        }
        if (newer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newer", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "doShowDiff"));
        }
        if (!filePath.isDirectory()) {
            VcsHistoryUtil.showDifferencesInBackground(this.myProject, filePath, older, newer);
        } else if (older.equals(VcsFileRevision.NULL)) {
            VcsFileRevision right = newer;
            this.showAffectedChanges(filePath, right);
        } else if (newer instanceof CurrentRevision) {
            VcsFileRevision left = older;
            this.showChangesBetweenRevisions(filePath, left, null);
        } else {
            VcsFileRevision left = older;
            VcsFileRevision right = newer;
            this.showChangesBetweenRevisions(filePath, left, right);
        }
    }

    protected void showChangesBetweenRevisions(final @NotNull FilePath path, @NotNull T older, @Nullable T newer) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showChangesBetweenRevisions"));
        }
        if (older == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "older", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showChangesBetweenRevisions"));
        }
        new CollectChangesTask("Comparing revisions...", (VcsFileRevision)older, (VcsFileRevision)newer){
            final /* synthetic */ VcsFileRevision val$older;
            final /* synthetic */ VcsFileRevision val$newer;
            {
                this.val$older = vcsFileRevision;
                this.val$newer = vcsFileRevision2;
                super(title);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                List<Change> list = BaseDiffFromHistoryHandler.this.getChangesBetweenRevisions(path, this.val$older, this.val$newer);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$1", "getChanges"));
                }
                return list;
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                String string = BaseDiffFromHistoryHandler.this.getChangesBetweenRevisionsDialogTitle(path, this.val$older, this.val$newer);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$1", "getDialogTitle"));
                }
                return string;
            }
        }.queue();
    }

    protected void showAffectedChanges(final @NotNull FilePath path, @NotNull T rev) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showAffectedChanges"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showAffectedChanges"));
        }
        new CollectChangesTask("Collecting affected changes...", (VcsFileRevision)rev){
            final /* synthetic */ VcsFileRevision val$rev;
            {
                this.val$rev = vcsFileRevision;
                super(title);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                List<Change> list = BaseDiffFromHistoryHandler.this.getAffectedChanges(path, this.val$rev);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$2", "getChanges"));
                }
                return list;
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                String string = BaseDiffFromHistoryHandler.this.getAffectedChangesDialogTitle(path, this.val$rev);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$2", "getDialogTitle"));
                }
                return string;
            }
        }.queue();
    }

    @NotNull
    protected abstract List<Change> getChangesBetweenRevisions(@NotNull FilePath var1, @NotNull T var2, @Nullable T var3) throws VcsException;

    @NotNull
    protected abstract List<Change> getAffectedChanges(@NotNull FilePath var1, @NotNull T var2) throws VcsException;

    @NotNull
    protected abstract String getPresentableName(@NotNull T var1);

    protected void showChangesDialog(@NotNull String title, @NotNull List<Change> changes) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showChangesDialog"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showChangesDialog"));
        }
        DialogBuilder dialogBuilder = new DialogBuilder(this.myProject);
        dialogBuilder.setTitle(title);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        ChangesBrowser changesBrowser = new ChangesBrowser(this.myProject, null, changes, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        changesBrowser.setChangesToDisplay(changes);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser);
        dialogBuilder.setPreferredFocusComponent(changesBrowser.getPreferredFocusedComponent());
        dialogBuilder.showNotModal();
    }

    protected void showError(@NotNull VcsException e, @NotNull String logMessage) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showError"));
        }
        if (logMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logMessage", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "showError"));
        }
        LOG.info(logMessage, (Throwable)e);
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myProject, e.getMessage(), MessageType.ERROR);
    }

    @NotNull
    protected String getChangesBetweenRevisionsDialogTitle(@NotNull FilePath path, @NotNull T rev1, @Nullable T rev2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "getChangesBetweenRevisionsDialogTitle"));
        }
        if (rev1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev1", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "getChangesBetweenRevisionsDialogTitle"));
        }
        String rev1Title = this.getPresentableName(rev1);
        String string = rev2 != null ? String.format("Difference between %s and %s in %s", rev1Title, this.getPresentableName(rev2), path.getName()) : String.format("Difference between %s and local version in %s", rev1Title, path.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "getChangesBetweenRevisionsDialogTitle"));
        }
        return string;
    }

    @NotNull
    protected String getAffectedChangesDialogTitle(@NotNull FilePath path, @NotNull T rev) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "getAffectedChangesDialogTitle"));
        }
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "getAffectedChangesDialogTitle"));
        }
        String string = String.format("Initial commit %s in %s", this.getPresentableName(rev), path.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler", "getAffectedChangesDialogTitle"));
        }
        return string;
    }

    protected abstract class CollectChangesTask
    extends Task.Backgroundable {
        private List<Change> myChanges;

        public CollectChangesTask(String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$CollectChangesTask", "<init>"));
            }
            super(BaseDiffFromHistoryHandler.this.myProject, title);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$CollectChangesTask", "run"));
            }
            try {
                this.myChanges = this.getChanges();
            }
            catch (VcsException e) {
                BaseDiffFromHistoryHandler.this.showError(e, "Error during task: " + this.getDialogTitle());
            }
        }

        @NotNull
        public abstract List<Change> getChanges() throws VcsException;

        @NotNull
        public abstract String getDialogTitle();

        public void onSuccess() {
            BaseDiffFromHistoryHandler.this.showChangesDialog(this.getDialogTitle(), ContainerUtil.notNullize(this.myChanges));
        }
    }
}

