/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.jetbrains.annotations.NotNull;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance(DefaultRemoteContentProvider.class);

    @Override
    public boolean canProvideContent(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "canProvideContent"));
        }
        return true;
    }

    @Override
    public void saveContent(final @NotNull Url url, final @NotNull File file, final @NotNull RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "saveContent"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                DefaultRemoteContentProvider.downloadContent(url, file, callback);
            }
        });
    }

    private static void downloadContent(final @NotNull Url url, final File file, final RemoteContentProvider.DownloadingCallback callback) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "downloadContent"));
        }
        LOG.debug("Downloading started: " + url);
        final String presentableUrl = StringUtil.trimMiddle((String)url.trimParameters().toDecodedForm(), (int)40);
        callback.setProgressText(VfsBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
        try {
            HttpRequests.request((String)url.toExternalForm()).connectTimeout(60000).productNameAsUserAgent().hostNameVerifier(CertificateManager.HOSTNAME_VERIFIER).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Object>(){

                public Object process(@NotNull HttpRequests.Request request) throws IOException {
                    FileType fileTypeByFileName;
                    if (request == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider$2", "process"));
                    }
                    if (!request.isSuccessful()) {
                        throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{((HttpURLConnection)request.getConnection()).getResponseCode()}));
                    }
                    int size = request.getConnection().getContentLength();
                    callback.setProgressText(VfsBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size == -1);
                    request.saveToFile(file, (ProgressIndicator)new AbstractProgressIndicatorExBase(){

                        @Override
                        public void setFraction(double fraction) {
                            callback.setProgressFraction(0.0);
                        }
                    });
                    FileType fileType = RemoteFileUtil.getFileType(request.getConnection().getContentType());
                    if (fileType == FileTypes.PLAIN_TEXT && (fileTypeByFileName = FileTypeRegistry.getInstance().getFileTypeByFileName(PathUtilRt.getFileName((String)url.getPath()))) != FileTypes.UNKNOWN) {
                        fileType = fileTypeByFileName;
                    }
                    LOG.debug("Downloading finished, " + size + " bytes downloaded");
                    callback.finished(fileType);
                    return null;
                }
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback.errorOccurred(VfsBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
    }

    @Override
    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "isUpToDate"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/openapi/vfs/impl/http/DefaultRemoteContentProvider", "isUpToDate"));
        }
        return false;
    }
}

