/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.win32;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.win32.Win32FsCache;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Win32LocalFileSystem
extends LocalFileSystemBase {
    private static final ThreadLocal<Win32LocalFileSystem> THREAD_LOCAL = new ThreadLocal<Win32LocalFileSystem>(){

        @Override
        protected Win32LocalFileSystem initialValue() {
            return new Win32LocalFileSystem();
        }
    };
    private final Win32FsCache myFsCache = new Win32FsCache();

    public static boolean isAvailable() {
        return IdeaWin32.isAvailable();
    }

    public static Win32LocalFileSystem getWin32Instance() {
        if (!Win32LocalFileSystem.isAvailable()) {
            throw new RuntimeException("Native filesystem for Windows is not loaded");
        }
        Win32LocalFileSystem fileSystem = THREAD_LOCAL.get();
        fileSystem.myFsCache.clearCache();
        return fileSystem;
    }

    private Win32LocalFileSystem() {
    }

    @Override
    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem", "list"));
        }
        String[] stringArray = this.myFsCache.list(file.getPath());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem", "list"));
        }
        return stringArray;
    }

    @Override
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem", "getAttributes"));
        }
        return this.myFsCache.getAttributes(file);
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPaths", "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem", "addRootsToWatch"));
        }
        throw new UnsupportedOperationException();
    }

    public void removeWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests) {
        if (watchRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchRequests", "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem", "removeWatchedRoots"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        if (watchRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchRequests", "com/intellij/openapi/vfs/impl/win32/Win32LocalFileSystem", "replaceWatchedRoots"));
        }
        throw new UnsupportedOperationException();
    }
}

