/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactUtil {
    private ArtifactUtil() {
    }

    public static CompositePackagingElement<?> copyFromRoot(@NotNull CompositePackagingElement<?> oldRoot, @NotNull Project project) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyFromRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyFromRoot"));
        }
        CompositePackagingElement newRoot = (CompositePackagingElement)ArtifactUtil.copyElement(oldRoot, project);
        ArtifactUtil.copyChildren(oldRoot, newRoot, project);
        return newRoot;
    }

    public static void copyChildren(CompositePackagingElement<?> oldParent, CompositePackagingElement<?> newParent, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyChildren"));
        }
        for (PackagingElement child : oldParent.getChildren()) {
            newParent.addOrFindChild(ArtifactUtil.copyWithChildren(child, project));
        }
    }

    @NotNull
    public static <S> PackagingElement<S> copyWithChildren(@NotNull PackagingElement<S> element, @NotNull Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyWithChildren"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyWithChildren"));
        }
        PackagingElement<S> copy = ArtifactUtil.copyElement(element, project);
        if (element instanceof CompositePackagingElement) {
            ArtifactUtil.copyChildren((CompositePackagingElement)element, (CompositePackagingElement)copy, project);
        }
        PackagingElement<S> packagingElement = copy;
        if (packagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyWithChildren"));
        }
        return packagingElement;
    }

    @NotNull
    private static <S> PackagingElement<S> copyElement(@NotNull PackagingElement<S> element, @NotNull Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyElement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyElement"));
        }
        PackagingElement copy = element.getType().createEmpty(project);
        copy.loadState(element.getState());
        PackagingElement packagingElement = copy;
        if (packagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "copyElement"));
        }
        return packagingElement;
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, final @NotNull Processor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvingContext", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        return ArtifactUtil.processPackagingElements(artifact, type, new PackagingElementProcessor<E>(){

            @Override
            public boolean process(@NotNull E e, @NotNull PackagingElementPath path) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/packaging/impl/artifacts/ArtifactUtil$1", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil$1", "process"));
                }
                return processor2.process(e);
            }
        }, resolvingContext, processSubstitutions);
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(@NotNull Artifact artifact, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvingContext", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        return ArtifactUtil.processPackagingElements(artifact.getRootElement(), type, processor2, resolvingContext, processSubstitutions, artifact.getArtifactType());
    }

    public static <E extends PackagingElement<?>> boolean processPackagingElements(PackagingElement<?> rootElement, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvingContext", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processPackagingElements"));
        }
        return ArtifactUtil.processElementRecursively(rootElement, type, processor2, resolvingContext, processSubstitutions, artifactType, PackagingElementPath.EMPTY, new HashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsRecursively(List<? extends PackagingElement<?>> elements, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsRecursively"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvingContext", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsRecursively"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsRecursively"));
        }
        for (PackagingElement<?> element : elements) {
            if (ArtifactUtil.processElementRecursively(element, type, processor2, resolvingContext, processSubstitutions, artifactType, path, processed)) continue;
            return false;
        }
        return true;
    }

    public static void processRecursivelySkippingIncludedArtifacts(Artifact artifact, final Processor<PackagingElement<?>> processor2, PackagingElementResolvingContext context) {
        ArtifactUtil.processPackagingElements(artifact.getRootElement(), null, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil$2", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil$2", "process"));
                }
                return processor2.process(element);
            }

            @Override
            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                return !(element instanceof ArtifactPackagingElement);
            }
        }, context, true, artifact.getArtifactType());
    }

    private static <E extends PackagingElement<?>> boolean processElementRecursively(@NotNull PackagingElement<?> element, @Nullable PackagingElementType<E> type, @NotNull PackagingElementProcessor<? super E> processor2, @NotNull PackagingElementResolvingContext resolvingContext, boolean processSubstitutions, ArtifactType artifactType, @NotNull PackagingElementPath path, Set<PackagingElement<?>> processed) {
        List substitution;
        ComplexPackagingElement complexElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementRecursively"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementRecursively"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvingContext", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementRecursively"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementRecursively"));
        }
        if (!processor2.shouldProcess(element) || !processed.add(element)) {
            return true;
        }
        if ((type == null || element.getType().equals(type)) && !processor2.process(element, path)) {
            return false;
        }
        if (element instanceof CompositePackagingElement) {
            CompositePackagingElement composite = (CompositePackagingElement)element;
            return ArtifactUtil.processElementsRecursively(composite.getChildren(), type, processor2, resolvingContext, processSubstitutions, artifactType, path.appendComposite(composite), processed);
        }
        if (element instanceof ComplexPackagingElement && processSubstitutions && processor2.shouldProcessSubstitution(complexElement = (ComplexPackagingElement)element) && (substitution = complexElement.getSubstitution(resolvingContext, artifactType)) != null) {
            return ArtifactUtil.processElementsRecursively(substitution, type, processor2, resolvingContext, processSubstitutions, artifactType, path.appendComplex(complexElement), processed);
        }
        return true;
    }

    public static void removeDuplicates(@NotNull CompositePackagingElement<?> parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "removeDuplicates"));
        }
        ArrayList<PackagingElement> prevChildren = new ArrayList<PackagingElement>();
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : parent.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                ArtifactUtil.removeDuplicates((CompositePackagingElement)child);
            }
            boolean merged = false;
            for (PackagingElement prevChild : prevChildren) {
                if (!child.isEqualTo(prevChild)) continue;
                if (child instanceof CompositePackagingElement) {
                    for (PackagingElement childElement : ((CompositePackagingElement)child).getChildren()) {
                        ((CompositePackagingElement)prevChild).addOrFindChild(childElement);
                    }
                }
                merged = true;
                break;
            }
            if (merged) {
                toRemove.add(child);
                continue;
            }
            prevChildren.add(child);
        }
        for (PackagingElement child : toRemove) {
            parent.removeChild(child);
        }
    }

    public static <S> void copyProperties(ArtifactProperties<?> from, ArtifactProperties<S> to) {
        to.loadState(from.getState());
    }

    @Nullable
    public static String getDefaultArtifactOutputPath(@NotNull String artifactName, @NotNull Project project) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getDefaultArtifactOutputPath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getDefaultArtifactOutputPath"));
        }
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)project);
        if (extension == null) {
            return null;
        }
        String outputUrl = extension.getCompilerOutputUrl();
        if (outputUrl == null || outputUrl.length() == 0) {
            VirtualFile baseDir = project.getBaseDir();
            if (baseDir == null) {
                return null;
            }
            outputUrl = baseDir.getUrl() + "/out";
        }
        return VfsUtilCore.urlToPath((String)outputUrl) + "/artifacts/" + FileUtil.sanitizeFileName((String)artifactName);
    }

    public static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor2) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        return ArtifactUtil.processElementsWithSubstitutions(elements, context, artifactType, parentPath, processor2, new THashSet());
    }

    private static <E extends PackagingElement<?>> boolean processElementsWithSubstitutions(@NotNull List<? extends PackagingElement<?>> elements, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, @NotNull PackagingElementProcessor<E> processor2, Set<PackagingElement<?>> processed) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsWithSubstitutions"));
        }
        for (PackagingElement<?> element : elements) {
            ComplexPackagingElement complexElement;
            List substitution;
            if (!processed.add(element) || !(element instanceof ComplexPackagingElement && processor2.shouldProcessSubstitution((ComplexPackagingElement)element) ? (substitution = (complexElement = (ComplexPackagingElement)element).getSubstitution(context, artifactType)) != null && !ArtifactUtil.processElementsWithSubstitutions(substitution, context, artifactType, parentPath.appendComplex(complexElement), processor2, processed) : !processor2.process(element, parentPath))) continue;
            return false;
        }
        return true;
    }

    public static List<PackagingElement<?>> findByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "findByRelativePath"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "findByRelativePath"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "findByRelativePath"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "findByRelativePath"));
        }
        final ArrayList result2 = new ArrayList();
        ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath path) {
                if (packagingElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagingElement", "com/intellij/packaging/impl/artifacts/ArtifactUtil$3", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil$3", "process"));
                }
                result2.add(packagingElement);
                return true;
            }
        });
        return result2;
    }

    public static boolean processElementsByRelativePath(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, @NotNull PackagingElementPath parentPath, final @NotNull PackagingElementProcessor<PackagingElement<?>> processor2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsByRelativePath"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsByRelativePath"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsByRelativePath"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsByRelativePath"));
        }
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsByRelativePath"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processElementsByRelativePath"));
        }
        if ((relativePath = StringUtil.trimStart((String)relativePath, (String)"/")).isEmpty()) {
            return true;
        }
        int i = relativePath.indexOf(47);
        final String firstName = i != -1 ? relativePath.substring(0, i) : relativePath;
        final String tail = i != -1 ? relativePath.substring(i + 1) : "";
        return ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, parentPath.appendComposite(parent), new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                FileCopyPackagingElement fileCopy;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil$4", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil$4", "process"));
                }
                boolean process = false;
                if (element instanceof CompositePackagingElement && firstName.equals(((CompositePackagingElement)element).getName())) {
                    process = true;
                } else if (element instanceof FileCopyPackagingElement && firstName.equals((fileCopy = (FileCopyPackagingElement)element).getOutputFileName())) {
                    process = true;
                }
                if (process) {
                    if (tail.length() == 0) {
                        if (!processor2.process(element, path)) {
                            return false;
                        }
                    } else if (element instanceof CompositePackagingElement) {
                        return ArtifactUtil.processElementsByRelativePath((CompositePackagingElement)element, tail, context, artifactType, path, processor2);
                    }
                }
                return true;
            }
        });
    }

    public static boolean processDirectoryChildren(@NotNull CompositePackagingElement<?> parent, @NotNull PackagingElementPath pathToParent, @NotNull String relativePath, final @NotNull PackagingElementResolvingContext context, final @NotNull ArtifactType artifactType, final @NotNull PackagingElementProcessor<PackagingElement<?>> processor2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processDirectoryChildren"));
        }
        if (pathToParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToParent", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processDirectoryChildren"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processDirectoryChildren"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processDirectoryChildren"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processDirectoryChildren"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processDirectoryChildren"));
        }
        return ArtifactUtil.processElementsByRelativePath(parent, relativePath, context, artifactType, pathToParent, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                List children2;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil$5", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil$5", "process"));
                }
                return !(element instanceof DirectoryPackagingElement) || ArtifactUtil.processElementsWithSubstitutions(children2 = ((DirectoryPackagingElement)element).getChildren(), context, artifactType, path.appendComposite((DirectoryPackagingElement)element), processor2);
            }
        });
    }

    public static void processFileOrDirectoryCopyElements(Artifact artifact, PackagingElementProcessor<FileOrDirectoryCopyPackagingElement<?>> processor2, PackagingElementResolvingContext context, boolean processSubstitutions) {
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, processor2, context, processSubstitutions);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.DIRECTORY_COPY_ELEMENT_TYPE, processor2, context, processSubstitutions);
        ArtifactUtil.processPackagingElements(artifact, PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, processor2, context, processSubstitutions);
    }

    public static Collection<Trinity<Artifact, PackagingElementPath, String>> findContainingArtifactsWithOutputPaths(final @NotNull VirtualFile file, @NotNull Project project, Artifact[] artifacts) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "findContainingArtifactsWithOutputPaths"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "findContainingArtifactsWithOutputPaths"));
        }
        final boolean isResourceFile = CompilerConfiguration.getInstance((Project)project).isResourceFile(file);
        final ArrayList<Trinity<Artifact, PackagingElementPath, String>> result2 = new ArrayList<Trinity<Artifact, PackagingElementPath, String>>();
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        for (final Artifact artifact : artifacts) {
            ArtifactUtil.processPackagingElements(artifact, null, new PackagingElementProcessor<PackagingElement<?>>(){

                @Override
                public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                    String relativePath;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil$6", "process"));
                    }
                    if (path == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil$6", "process"));
                    }
                    if (element instanceof FileOrDirectoryCopyPackagingElement) {
                        VirtualFile root = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                        if (root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
                            String relativePath2 = root.equals(file) && element instanceof FileCopyPackagingElement ? ((FileCopyPackagingElement)element).getOutputFileName() : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
                            result2.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath2));
                            return false;
                        }
                    } else if (isResourceFile && element instanceof ModuleOutputPackagingElement && (relativePath = ArtifactUtil.getRelativePathInSources(file, (ModuleOutputPackagingElement)element, context)) != null) {
                        result2.add(Trinity.create((Object)artifact, (Object)path, (Object)relativePath));
                        return false;
                    }
                    return true;
                }
            }, context, true);
        }
        return result2;
    }

    @Nullable
    private static String getRelativePathInSources(@NotNull VirtualFile file, @NotNull ModuleOutputPackagingElement moduleElement, @NotNull PackagingElementResolvingContext context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getRelativePathInSources"));
        }
        if (moduleElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleElement", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getRelativePathInSources"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getRelativePathInSources"));
        }
        for (VirtualFile sourceRoot : moduleElement.getSourceRoots(context)) {
            if (!VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)file, (boolean)true)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
        }
        return null;
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(Artifact artifact, String outputPath, PackagingElementResolvingContext context) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(artifact.getRootElement(), outputPath, context, artifact.getArtifactType());
        return files.isEmpty() ? null : files.get(0);
    }

    @Nullable
    public static VirtualFile findSourceFileByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        List<VirtualFile> files = ArtifactUtil.findSourceFilesByOutputPath(parent, outputPath, context, artifactType);
        return files.isEmpty() ? null : files.get(0);
    }

    public static List<VirtualFile> findSourceFilesByOutputPath(CompositePackagingElement<?> parent, String outputPath, PackagingElementResolvingContext context, ArtifactType artifactType) {
        String path = StringUtil.trimStart((String)outputPath, (String)"/");
        if (path.isEmpty()) {
            return Collections.emptyList();
        }
        int i = path.indexOf(47);
        final String firstName = i != -1 ? path.substring(0, i) : path;
        String tail = i != -1 ? path.substring(i + 1) : "";
        SmartList result2 = new SmartList();
        ArtifactUtil.processElementsWithSubstitutions(parent.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>((List)result2, tail, context, artifactType, path){
            final /* synthetic */ List val$result;
            final /* synthetic */ String val$tail;
            final /* synthetic */ PackagingElementResolvingContext val$context;
            final /* synthetic */ ArtifactType val$artifactType;
            final /* synthetic */ String val$path;
            {
                this.val$result = list;
                this.val$tail = string2;
                this.val$context = packagingElementResolvingContext;
                this.val$artifactType = artifactType;
                this.val$path = string3;
            }

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath elementPath) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil$7", "process"));
                }
                if (elementPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementPath", "com/intellij/packaging/impl/artifacts/ArtifactUtil$7", "process"));
                }
                if (element instanceof CompositePackagingElement) {
                    CompositePackagingElement compositeElement = (CompositePackagingElement)element;
                    if (firstName.equals(compositeElement.getName())) {
                        this.val$result.addAll(ArtifactUtil.findSourceFilesByOutputPath(compositeElement, this.val$tail, this.val$context, this.val$artifactType));
                    }
                } else if (element instanceof FileCopyPackagingElement) {
                    FileCopyPackagingElement fileCopyElement = (FileCopyPackagingElement)element;
                    if (firstName.equals(fileCopyElement.getOutputFileName()) && this.val$tail.isEmpty()) {
                        ContainerUtil.addIfNotNull((Object)fileCopyElement.findFile(), (Collection)this.val$result);
                    }
                } else if (element instanceof DirectoryCopyPackagingElement || element instanceof ExtractedDirectoryPackagingElement) {
                    VirtualFile sourceRoot = ((FileOrDirectoryCopyPackagingElement)element).findFile();
                    if (sourceRoot != null) {
                        ContainerUtil.addIfNotNull((Object)sourceRoot.findFileByRelativePath(this.val$path), (Collection)this.val$result);
                    }
                } else if (element instanceof ModuleOutputPackagingElement) {
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.val$context.getProject());
                    for (VirtualFile sourceRoot : ((ModuleOutputPackagingElement)element).getSourceRoots(this.val$context)) {
                        VirtualFile sourceFile = sourceRoot.findFileByRelativePath(this.val$path);
                        if (sourceFile == null || !compilerConfiguration.isResourceFile(sourceFile)) continue;
                        this.val$result.add(sourceFile);
                    }
                }
                return true;
            }
        });
        return result2;
    }

    public static boolean processParents(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ParentElementProcessor processor2, int maxLevel) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processParents"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processParents"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processParents"));
        }
        return ArtifactUtil.processParents(artifact, context, processor2, FList.emptyList(), maxLevel, (Set<Artifact>)new THashSet());
    }

    private static boolean processParents(final @NotNull Artifact artifact, final @NotNull PackagingElementResolvingContext context, final @NotNull ParentElementProcessor processor2, FList<Pair<Artifact, CompositePackagingElement<?>>> pathToElement, final int maxLevel, final Set<Artifact> processed) {
        FList pathFromRoot;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processParents"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processParents"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "processParents"));
        }
        if (!processed.add(artifact)) {
            return true;
        }
        CompositePackagingElement rootElement = artifact.getRootElement();
        if (rootElement instanceof ArtifactRootElement) {
            pathFromRoot = pathToElement;
        } else {
            if (!processor2.process((CompositePackagingElement<?>)rootElement, (List<Pair<Artifact, CompositePackagingElement<?>>>)pathToElement, artifact)) {
                return false;
            }
            pathFromRoot = pathToElement.prepend((Object)new Pair((Object)artifact, (Object)rootElement));
        }
        if (pathFromRoot.size() > maxLevel) {
            return true;
        }
        for (final Artifact anArtifact : context.getArtifactModel().getArtifacts()) {
            PackagingElementProcessor<ArtifactPackagingElement> elementProcessor;
            if (processed.contains(anArtifact) || ArtifactUtil.processPackagingElements(anArtifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, elementProcessor = new PackagingElementProcessor<ArtifactPackagingElement>(){

                @Override
                public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                    return !(element instanceof ArtifactPackagingElement);
                }

                @Override
                public boolean process(@NotNull ArtifactPackagingElement element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil$8", "process"));
                    }
                    if (path == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/artifacts/ArtifactUtil$8", "process"));
                    }
                    if (artifact.getName().equals(element.getArtifactName())) {
                        CompositePackagingElement<?> lastParent;
                        FList currentPath = pathFromRoot;
                        List<CompositePackagingElement<?>> parents = path.getParents();
                        int parentsSize = parents.size();
                        for (int i = 0; i < parentsSize - 1; ++i) {
                            CompositePackagingElement<?> parent = parents.get(i);
                            if (!processor2.process(parent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                                return false;
                            }
                            if ((currentPath = currentPath.prepend((Object)new Pair((Object)anArtifact, parent))).size() <= maxLevel) continue;
                            return true;
                        }
                        if (!parents.isEmpty() && (lastParent = parents.get(parents.size() - 1)) instanceof ArtifactRootElement && !processor2.process(lastParent, (List<Pair<Artifact, CompositePackagingElement<?>>>)currentPath, anArtifact)) {
                            return false;
                        }
                        return ArtifactUtil.processParents(anArtifact, context, processor2, currentPath, maxLevel, processed);
                    }
                    return true;
                }
            }, context, true)) continue;
            return false;
        }
        return true;
    }

    public static void removeChildrenRecursively(@NotNull CompositePackagingElement<?> element, @NotNull Condition<PackagingElement<?>> condition) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "removeChildrenRecursively"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "removeChildrenRecursively"));
        }
        ArrayList<PackagingElement> toRemove = new ArrayList<PackagingElement>();
        for (PackagingElement child : element.getChildren()) {
            if (child instanceof CompositePackagingElement) {
                CompositePackagingElement compositeChild = (CompositePackagingElement)child;
                ArtifactUtil.removeChildrenRecursively(compositeChild, condition);
                if (!compositeChild.getChildren().isEmpty()) continue;
                toRemove.add(child);
                continue;
            }
            if (!condition.value((Object)child)) continue;
            toRemove.add(child);
        }
        element.removeChildren(toRemove);
    }

    public static boolean shouldClearArtifactOutputBeforeRebuild(Artifact artifact) {
        String outputPath = artifact.getOutputPath();
        return !StringUtil.isEmpty((String)outputPath) && artifact.getRootElement() instanceof ArtifactRootElement;
    }

    public static Set<Module> getModulesIncludedInArtifacts(@NotNull Collection<? extends Artifact> artifacts, @NotNull Project project) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getModulesIncludedInArtifacts"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getModulesIncludedInArtifacts"));
        }
        THashSet modules = new THashSet();
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project).getResolvingContext();
        for (Artifact artifact : artifacts) {
            ArtifactUtil.processPackagingElements(artifact, null, new Processor<PackagingElement<?>>((Set)modules, resolvingContext){
                final /* synthetic */ Set val$modules;
                final /* synthetic */ PackagingElementResolvingContext val$resolvingContext;
                {
                    this.val$modules = set;
                    this.val$resolvingContext = packagingElementResolvingContext;
                }

                public boolean process(PackagingElement<?> element) {
                    if (element instanceof ModuleOutputPackagingElement) {
                        ContainerUtil.addIfNotNull((Collection)this.val$modules, (Object)((ModuleOutputPackagingElement)element).findModule(this.val$resolvingContext));
                    }
                    return true;
                }
            }, resolvingContext, true);
        }
        return modules;
    }

    public static Collection<Artifact> getArtifactsContainingModuleOutput(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "getArtifactsContainingModuleOutput"));
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)module.getProject());
        final PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        final HashSet<Artifact> result2 = new HashSet<Artifact>();
        Processor processor2 = new Processor<PackagingElement<?>>(){

            public boolean process(@NotNull PackagingElement<?> element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/artifacts/ArtifactUtil$10", "process"));
                }
                if (element instanceof ProductionModuleOutputPackagingElement && module.equals(((ProductionModuleOutputPackagingElement)element).findModule(context))) {
                    return false;
                }
                return !(element instanceof ArtifactPackagingElement) || !result2.contains(((ArtifactPackagingElement)element).findArtifact(context));
            }
        };
        for (Artifact artifact : artifactManager.getSortedArtifacts()) {
            boolean contains;
            boolean bl = contains = !ArtifactUtil.processPackagingElements(artifact, null, processor2, context, true);
            if (!contains) continue;
            result2.add(artifact);
        }
        return result2;
    }

    public static List<Artifact> getArtifactWithOutputPaths(Project project) {
        ArrayList<Artifact> result2 = new ArrayList<Artifact>();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getSortedArtifacts()) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            result2.add(artifact);
        }
        return result2;
    }

    public static String suggestArtifactFileName(String artifactName) {
        return PathUtil.suggestFileName((String)artifactName, (boolean)true, (boolean)true);
    }

    @Nullable
    public static Artifact addArtifact(@NotNull ModifiableArtifactModel artifactModel, @NotNull ArtifactType type, @NotNull ArtifactTemplate artifactTemplate) {
        String baseName;
        if (artifactModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactModel", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "addArtifact"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "addArtifact"));
        }
        if (artifactTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactTemplate", "com/intellij/packaging/impl/artifacts/ArtifactUtil", "addArtifact"));
        }
        ArtifactTemplate.NewArtifactConfiguration configuration = artifactTemplate.createArtifact();
        if (configuration == null) {
            return null;
        }
        String name = baseName = configuration.getArtifactName();
        int i = 2;
        while (artifactModel.findArtifact(name) != null) {
            name = baseName + i;
            ++i;
        }
        ArtifactType actualType = configuration.getArtifactType();
        if (actualType == null) {
            actualType = type;
        }
        ModifiableArtifact artifact = artifactModel.addArtifact(name, actualType, configuration.getRootElement());
        artifactTemplate.setUpArtifact((Artifact)artifact, configuration);
        return artifact;
    }
}

