/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleAttachProcessor
extends ProjectAttachProcessor {
    private static final Logger LOG = Logger.getInstance(ModuleAttachProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attachToProject(Project project, File projectDir, @Nullable ProjectOpenedCallback callback) {
        int rc;
        VirtualFile files;
        if (!projectDir.exists()) {
            Project newProject = ((ProjectManagerEx)ProjectManager.getInstance()).newProject(projectDir.getParentFile().getName(), projectDir.getParent(), true, false);
            if (newProject == null) {
                return false;
            }
            VirtualFile baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(projectDir.getParent());
            PlatformProjectOpenProcessor.runDirectoryProjectConfigurators(baseDir, newProject);
            newProject.save();
            AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(null);
            try {
                Disposer.dispose((Disposable)newProject);
            }
            finally {
                token.finish();
            }
        }
        if ((files = projectDir.list()) != null) {
            for (VirtualFile file : files) {
                VirtualFile imlFile;
                if (!FileUtilRt.extensionEquals((String)file, (String)"iml") || (imlFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(projectDir, (String)file))) == null) continue;
                ModuleAttachProcessor.attachModule(project, imlFile, callback);
                return true;
            }
        }
        return (rc = Messages.showYesNoDialog((Project)project, (String)("The project at " + FileUtil.toSystemDependentName((String)projectDir.getPath()) + " uses a non-standard layout and cannot be attached to this project. Would you like to open it in a new window?"), (String)"Open Project", (Icon)Messages.getQuestionIcon())) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachModule(Project project, VirtualFile imlFile, @Nullable ProjectOpenedCallback callback) {
        try {
            VirtualFile dotIdeaDir;
            ModifiableModuleModel model = ModuleManager.getInstance((Project)project).getModifiableModel();
            Module module = model.loadModule(imlFile.getPath());
            AccessToken token = WriteAction.start();
            try {
                model.commit();
            }
            finally {
                token.finish();
            }
            Module newModule = ModuleManager.getInstance((Project)project).findModuleByName(module.getName());
            assert (newModule != null);
            Module primaryModule = ModuleAttachProcessor.addPrimaryModuleDependency(project, newModule);
            if (primaryModule != null && (dotIdeaDir = imlFile.getParent()) != null) {
                ModuleAttachProcessor.updateVcsMapping(primaryModule, dotIdeaDir.getParent());
            }
            if (callback != null) {
                callback.projectOpened(project, newModule);
            }
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
            Messages.showErrorDialog((Project)project, (String)("Cannot attach project: " + ex.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void updateVcsMapping(Module primaryModule, VirtualFile addedModuleContentRoot) {
        AbstractVcs vcs;
        VirtualFile[] contentRoots;
        Project project = primaryModule.getProject();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        List mappings = vcsManager.getDirectoryMappings();
        if (mappings.size() == 1 && (contentRoots = ModuleRootManager.getInstance((Module)primaryModule).getContentRoots()).length == 1 && FileUtil.filesEqual((File)new File(contentRoots[0].getPath()), (File)new File(((VcsDirectoryMapping)mappings.get(0)).getDirectory())) && (vcs = vcsManager.findVersioningVcs(addedModuleContentRoot)) != null && vcs.getName().equals(((VcsDirectoryMapping)mappings.get(0)).getVcs())) {
            vcsManager.setDirectoryMappings(Arrays.asList(new VcsDirectoryMapping("", vcs.getName())));
            return;
        }
        AbstractVcs vcs2 = vcsManager.findVersioningVcs(addedModuleContentRoot);
        if (vcs2 != null) {
            ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(mappings);
            newMappings.add(new VcsDirectoryMapping(addedModuleContentRoot.getPath(), vcs2.getName()));
            vcsManager.setDirectoryMappings(newMappings);
        }
    }

    @Nullable
    private static Module addPrimaryModuleDependency(Project project, @NotNull Module newModule) {
        if (newModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModule", "com/intellij/platform/ModuleAttachProcessor", "addPrimaryModuleDependency"));
        }
        Module module = ModuleAttachProcessor.getPrimaryModule(project);
        if (module != null && module != newModule) {
            ModuleRootModificationUtil.addDependency((Module)module, (Module)newModule);
            return module;
        }
        return null;
    }

    @Nullable
    public static Module getPrimaryModule(Project project) {
        if (!ModuleAttachProcessor.canAttachToProject()) {
            return null;
        }
        return ModuleAttachProcessor.findModuleInBaseDir(project);
    }

    @Nullable
    public static Module findModuleInBaseDir(Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (!Comparing.equal((Object)root, (Object)project.getBaseDir())) continue;
                return module;
            }
        }
        return null;
    }

    public static List<Module> getSortedModules(Project project) {
        Module[] modules;
        ArrayList<Module> result2 = new ArrayList<Module>();
        Module primaryModule = ModuleAttachProcessor.getPrimaryModule(project);
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (module == primaryModule) continue;
            result2.add(module);
        }
        Collections.sort(result2, new Comparator<Module>(){

            @Override
            public int compare(Module module, Module module2) {
                return module.getName().compareTo(module2.getName());
            }
        });
        if (primaryModule != null) {
            result2.add(0, primaryModule);
        }
        return result2;
    }

    @Nullable
    public static String getMultiProjectDisplayName(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/ModuleAttachProcessor", "getMultiProjectDisplayName"));
        }
        if (!ProjectAttachProcessor.canAttachToProject()) {
            return null;
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length <= 1) {
            return null;
        }
        Module primaryModule = ModuleAttachProcessor.getPrimaryModule(project);
        if (primaryModule == null) {
            primaryModule = modules[0];
        }
        StringBuilder result2 = new StringBuilder(primaryModule.getName());
        result2.append(", ");
        for (Module module : modules) {
            if (module == primaryModule) continue;
            result2.append(module.getName());
            break;
        }
        if (modules.length > 2) {
            result2.append("...");
        }
        return result2.toString();
    }
}

