/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiJavaDirectoryImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiJavaDirectoryFactory
extends PsiDirectoryFactory {
    private final PsiManagerImpl myManager;

    public PsiJavaDirectoryFactory(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiDirectory createDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "createDirectory"));
        }
        PsiJavaDirectoryImpl psiJavaDirectoryImpl = new PsiJavaDirectoryImpl(this.myManager, file);
        if (psiJavaDirectoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "createDirectory"));
        }
        return psiJavaDirectoryImpl;
    }

    @Override
    @NotNull
    public String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "getQualifiedName"));
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage != null) {
            String qualifiedName = aPackage.getQualifiedName();
            if (!qualifiedName.isEmpty()) {
                String string = qualifiedName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "getQualifiedName"));
                }
                return string;
            }
            if (presentable) {
                String string = PsiBundle.message((String)"default.package.presentation", (Object[])new Object[0]) + " (" + directory.getVirtualFile().getPresentableUrl() + ")";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "getQualifiedName"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "getQualifiedName"));
            }
            return "";
        }
        String string = presentable ? StringUtil.notNullize((String)FileUtil.getLocationRelativeToUserHome((String)directory.getVirtualFile().getPresentableUrl()), (String)"") : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "getQualifiedName"));
        }
        return string;
    }

    @Override
    @Nullable
    public PsiDirectoryContainer getDirectoryContainer(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "getDirectoryContainer"));
        }
        return JavaDirectoryService.getInstance().getPackage(directory);
    }

    @Override
    public boolean isPackage(@NotNull PsiDirectory directory) {
        VirtualFile virtualFile;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/psi/impl/file/PsiJavaDirectoryFactory", "isPackage"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex();
        return fileIndex.isUnderSourceRootOfType(virtualFile = directory.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) && fileIndex.getPackageNameByDirectory(virtualFile) != null;
    }

    @Override
    public boolean isValidPackageName(String name) {
        return PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(name);
    }
}

