/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiParameterStubImpl
extends StubBase<PsiParameter>
implements PsiParameterStub {
    private StringRef myName;
    private final TypeInfo myType;
    private final boolean myIsEllipsis;

    public PsiParameterStubImpl(StubElement parent, @NotNull String name, @NotNull TypeInfo type, boolean isEllipsis) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        this(parent, StringRef.fromString((String)name), type, isEllipsis);
    }

    public PsiParameterStubImpl(StubElement parent, @NotNull StringRef name, @NotNull TypeInfo type, boolean isEllipsis) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "<init>"));
        }
        super(parent, (IStubElementType)JavaStubElementTypes.PARAMETER);
        this.myName = name;
        this.myType = type;
        this.myIsEllipsis = isEllipsis;
    }

    @Override
    public boolean isParameterTypeEllipsis() {
        return this.myIsEllipsis;
    }

    @Override
    @NotNull
    public TypeInfo getType(boolean doResolve) {
        TypeInfo typeInfo = doResolve ? this.myType.applyAnnotations(this) : this.myType;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "getType"));
        }
        return typeInfo;
    }

    @Override
    public PsiModifierListStub getModList() {
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiModifierListStub)) continue;
            return (PsiModifierListStub)child;
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = StringRef.toString((StringRef)this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiParameterStubImpl", "getName"));
        }
        return string;
    }

    public void setName(String name) {
        this.myName = StringRef.fromString((String)name);
    }

    public boolean isAutoGeneratedName() {
        List children2 = this.getParentStub().getChildrenStubs();
        int paramIndex = 0;
        for (Object o : children2) {
            if (!(o instanceof PsiParameterStub)) continue;
            ++paramIndex;
            if (o != this) continue;
            break;
        }
        return ("p" + paramIndex).equals(this.getName());
    }

    public String toString() {
        return "PsiParameterStub[" + this.myName + ':' + this.myType + ']';
    }
}

